/***************************************************************************
                           kmagoappiface.h -
                         ---------------------------
    begin                : Fri Apr  6 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.1 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMAGOAPPIFACE_H
#define KMAGOAPPIFACE_H

#include <qstring.h>
#include <dcopobject.h>

class KMagoAppIface : virtual public DCOPObject
{
   K_DCOP
public:

k_dcop:
   virtual int appId() const = 0;
   virtual QString title() const = 0;
   virtual bool isClosed() const = 0;
   virtual bool isTmp() const = 0;
   virtual bool isIdle() const = 0;
   virtual bool isRunning() const = 0;
   virtual void openNewDocument() = 0;
   virtual void openDocument(const QString &filename) = 0;
   virtual void saveDocumentAs(const QString &filename) = 0;
   virtual void closeApp() = 0;
   virtual void setDownloadLock(bool v) = 0;
   virtual bool getDownloadLock() const = 0;
   virtual void setExitOnIdle(bool v) = 0;
   virtual bool getExitOnIdle() const = 0;
   virtual void setExecuteOnIdle(bool v) = 0;
   virtual bool getExecuteOnIdle() const = 0;
   virtual int getCurrentManager() const = 0;
   virtual void setCurrentManager(int id) = 0;
   virtual int getCurrentTransfer() const = 0;
   virtual void setCurrentTransfer(int id) = 0;
   virtual void addTransfer(const QString &url, int mode) = 0;
   virtual void addTransferTo(int id, const QString &url, int mode) = 0;
   virtual void removeObject(int id) = 0;
   virtual void transferStart(int id) = 0;
   virtual void transferKill(int id) = 0;
   virtual void managerKill(int id) = 0;
   virtual void kill() = 0;
   virtual bool hasObject(int id) const = 0;
   virtual QValueList<int> managers() const = 0;
   virtual QValueList<int> transfers(int id) const = 0;
   virtual QStringList managersString() const = 0;
   virtual QStringList transfersString(int id) const = 0;
   virtual QString transferRemote(int id) const = 0;
   virtual QString transferLocal(int id) const = 0;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
