/***************************************************************************
                           kdlgtransferprogress.cpp -
                         ---------------------------
    begin                : Tue Apr  3 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.2 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <qpushbutton.h>
#include <kprogress.h>
#include <qtooltip.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qgroupbox.h>
#include <kdebug.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <kiconloader.h>
#include <qtimer.h>
#include "km.h"
#include "ktransfer.h"
#include "kdlgtransferprogress.h"


KDlgTransferProgress::KDlgTransferProgress(KTransfer trn, bool viewTray,
					   QWidget *parent, const char *name)
   : QWidget(parent, name,
	     WDestructiveClose
	     | WType_TopLevel | WStyle_Customize | WStyle_NormalBorder
	     | WStyle_Title | WStyle_SysMenu | WStyle_MinMax), t(trn),
     _id(trn.id()), _tray(0)
{
   setIcon(SmallIcon("kmago"));
   initDialog(t);
   t.connect(SIGNAL(sigPercent(int)),
	     this, SLOT(slotUpdate(int)));
   if (viewTray)
   {
      _tray = new KSystemTray(this, QString("systray-%1").arg(t.id()));
      _tray->setPixmap(BarIcon("kmago"));
      _tray->show();
   }
   slotUpdate(t.percent());
}

KDlgTransferProgress::~KDlgTransferProgress()
{
   kdDebug(D_INI) << name() << ": destroy" << endl;
   emit sigClose(_id);
}

void KDlgTransferProgress::initDialog(KTransfer t)
{
   QBoxLayout * l = new QVBoxLayout(this, 8);

   QGroupBox *gbox = new QGroupBox(2, Horizontal, i18n("Url & File"),
				   this, "GB1");
   l->addWidget(gbox);

   new QLabel(i18n("From"), gbox);
   QLineEdit *lne = new QLineEdit(gbox);
   lne->setReadOnly(true);
   lne->setText(t.remote().prettyURL());

   new QLabel(i18n("To"), gbox);
   lne = new QLineEdit(gbox);
   lne->setReadOnly(true);
   lne->setText(t.local().prettyURL());

   KProgress *p =
      new KProgress(0, 100, t.percent(), Horizontal, this, "progress");
   //p->setBarStyle(KProgress::Blocked);
   l->addWidget(p);
   t.connect(SIGNAL(sigPercent(int)),
	     p, SLOT(setValue(int)));

   QHBox *box = new QHBox(this);
   l->addWidget(box);

   QPushButton *btn = new QPushButton(i18n("Start"), box, "BtnStart");
   connect(btn, SIGNAL(clicked()), this, SLOT(slotStart()));

   btn = new QPushButton(i18n("Stop"), box, "BtnStop");
   connect(btn, SIGNAL(clicked()), this, SLOT(slotStop()));

   btn = new QPushButton(i18n("Close"), box, "BtnOK");
   btn->setDefault(true);
   connect(btn, SIGNAL(clicked()), this, SLOT(close()));
}

void KDlgTransferProgress::slotUpdate(int p)
{
   if (t.isNull())
      return;
   QString caption = QString("%1% : %2").arg(p).arg(t.remote().prettyURL());
   setCaption(caption);
   if (_tray)
      QToolTip::add(_tray, caption);
}

void KDlgTransferProgress::slotStart()
{
   if (t.isNull() || t.isRunning())
      return;
   t.start();
}

void KDlgTransferProgress::slotStop()
{
   if (t.isNull() || !t.isRunning())
      return;
   t.kill();
}

#include "kdlgtransferprogress.moc"

/* Local Variables: */
/* mode: c++ */
/* End: */
