#!/bin/sh

pwd=`pwd`
if [ "`basename $pwd`" = script ]; then
    cd ..
fi

conf=config.status
if [ ! -f "$conf" ]; then
    echo "\"config.status\" not found. You should run \"configure\" first."
    exit -1
fi

get_word()
{
    file=$1
    word=$2

    grep "$word=" $file | sed "s/$word=\(.*\)/\1/"
    unset file word
}

OS=`get_word $conf OS`
CFLAGS=`get_word $conf CFLAGS`
CC=`get_word $conf CC`
XINC=`get_word $conf XINC`
XLIB=`get_word $conf XLIB`
DEFS=`get_word $conf DEFS`
UTMP=`get_word $conf UTMP`

PATH_CRXVT_PREFIX=`get_word $conf PATH_CRXVT_PREFIX`
PATH_CRXVT_BIN=`get_word $conf PATH_CRXVT_BIN`
PATH_CRXVT_MAN=`get_word $conf PATH_CRXVT_MAN`

OPT_CRXVT_CFONT=`get_word $conf OPT_CRXVT_CFONT`
OPT_CRXVT_EFONT=`get_word $conf OPT_CRXVT_EFONT`


#
#  Checking for install
#
# Make sure to not get the incompatible SysV /etc/install and
# /usr/sbin/install, which might be in PATH before a BSD-like install,
# or the SunOS /usr/etc/install directory, or the AIX /bin/install,
# or the AFS install, which mishandles nonexistent args, or
# /usr/ucb/install on SVR4, which tries to use the nonexistent group
# `staff'.  On most BSDish systems install is in /usr/bin, not /usr/ucb
# anyway.  Sigh.
if test "z${INSTALL}" = "z" ; then
  echo checking for install
  IFS="${IFS=   }"; saveifs="$IFS"; IFS="${IFS}:"
  for dir in $PATH; do
    test -z "$dir" && dir=.
    case $dir in
    /etc|/usr/sbin|/usr/etc|/usr/afsws/bin) ;;
    *)
      if test -f $dir/installbsd; then
        INSTALL="$dir/installbsd -c" # OSF1
        INSTALL_PROGRAM='$(INSTALL)'
        INSTALL_DATA='$(INSTALL) -m 644'
        INSTALL_DIR='$(INSTALL) -d'
        break
      fi
      if test -f $dir/install; then
        if grep dspmsg $dir/install >/dev/null 2>&1; then
          : # AIX
        else
          INSTALL="$dir/install -c"
          INSTALL_PROGRAM='$(INSTALL)'
          INSTALL_DATA='$(INSTALL) -m 644'
          INSTALL_DIR='$(INSTALL) -d'
          break
        fi
      fi
      ;;
    esac
  done
  IFS="$saveifs"
fi
INSTALL=${INSTALL-cp}
INSTALL_PROGRAM=${INSTALL_PROGRAM-'$(INSTALL)'}
INSTALL_DATA=${INSTALL_DATA-'$(INSTALL)'}
INSTALL_DIR=${INSTALL_DIR-mkdir}

cat >> $conf << EOF
INSTALL=$INSTALL
INSTALL_PROGRAM=$INSTALL_PROGRAM
INSTALL_DATA=$INSTALL_DATA
INSTALL_DIR=$INSTALL_DIR
EOF


#
#  Create src/Makefile
#
echo "Creating src/Makefile ...."
src=src/Makefile.in
dist=src/Makefile

extra_defs='-DPRINT_PIPE -DMULTIPLE_CLICKS -DMAX_REFRESH_PERIOD=10 -DCOLOR -DGRAPHICS -DOPT_CRXVT_CFONT=\\\"$(OPT_CRXVT_CFONT)\\\" -DOPT_CRXVT_EFONT=\\\"$(OPT_CRXVT_EFONT)\\\"'

if [ ! -z "$UTMP" ]; then
    extra_defs="$extra_defs -DUTMP_SUPPORT -DUTMP=\\\\\"$UTMP\\\\\""
fi

sed "s|@EXTRA_DEFINES@|$extra_defs|" $src > $dist


#
#  Create doc/Makefile
#
echo "Creating doc/Makefile ...."
src=doc/Makefile.in
dist=doc/Makefile

sed "s/@MAKEALL@/$makeall/;\
     s/@INSTALLALL@/$installall/" $src > $dist
    

