/*
 * dstumbler v1.0 [audio.c]
 * by h1kari - (c) Dachb0den Labs 2001
 * based on generous contributions by Kevin Kadow <dstumbler@msg.net>
 */

/*
 * Copyright (c) 2001 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"

#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>

#include "dstumbler.h"

/*
 * play audio pitch depending on the supplied number (for audio graphs)
 */
#define AUDIO_BUF_LEN 10
void
audio_graph(int pitch)
{
  char audio_buf[AUDIO_BUF_LEN];
  int a, b;

  a = MIN((pitch / 10), 5);
  b = (pitch % 10) / 2;

  snprintf(audio_buf, AUDIO_BUF_LEN - 1, "L8o%dao%da", a, b);
  audio_play(audio_buf);

  return;
}

/*
 * play specified audio string though the audio device
 */
void
audio_play(char *string)
{
  if((sp_fd = open(SPKR_DEV, O_WRONLY|O_NONBLOCK|O_SYNC)) < 0)
  {
    alert("error: unable to open speaker device: %s", strerror(errno));
    return;
  }

  if(write(sp_fd, string, strlen(string)) < strlen(string))
  {
    alert("error: error writing data to speaker device: %s", strerror(errno));
    return;
  }

  if(close(sp_fd) < 0)
  {
    alert("error: error closing speaker device: %s", strerror(errno));
    return;
  }
}
