/*
 * Copyright (c) 2000, Mark Buser.
 * Copyright (c) 2003, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/reportP.h,v 1.3 2003/11/19 19:35:12 danny Exp $
 */
#ifndef reportP_h
#define reportP_h

#ifdef DEBUG
#define DEBUGXY  fprintf( stderr, "x -> %d  y -> %d\n", attrib->x, attrib->y)
#else
#define DEBUGXY
#endif

/* Border around report drawing area */
#define BORDER		      32

/* Settings of accounts to report on */
#define REPORT_ACTIVE_ACCOUNT 1
#define REPORT_ALL_ACCOUNTS   2
#define REPORT_PORTFOLIO      4

/* Settings of details to report on */
#define REPORT_DETAIL_ON      1
#define REPORT_RTN_DETAIL_ON  2
#define REPORT_SINGLEWIN_ON   4

/* Special account value when reporting on portfolio */
#define REPORT_PORTFOLIO_ACCOUNT      -1

/* Number of time frames we can report on */
#define REPORT_TIMES          12 
#define TIME_CUSTOM           REPORT_TIMES-1
#define TIME_INCEP            REPORT_TIMES-2
#define TIME_YTD              REPORT_TIMES-8

/* Width in chars of a report */
#define REPORT_CHAR_WIDTH     76

/* Resource queries for REPORT_TYPE */
#define REPVALUE   0
#define REPPRICE   1
#define REPSHARE   2
#define REPDVALUE  3
#define REPDPRICE  4
#define REPDSHARE  5
#define REPCOST    6
#define REPDEBIT   7
#define REPFEE     8
#define REPTR      9
#define REPIRR     10
#define REPYIELD   11
#define REPGAIN    12
#define REPDIST    13
#define REPNA      14
#define REPPORT    15
#define REP_NUM_QUERY_VALUES REPPORT+1

#endif
