/*
**  Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
**	All rights reserved.
**
**  $Id: util.h,v 1.3 2005/11/30 21:52:46 msk Exp $
*/

#ifndef _UTIL_H_
#define _UTIL_H_

/* system includes */
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

/* libsm includes */
#include <sm/gen.h>

/* dkim-filter includes */
#include "dkim-filter.h"

#ifndef lint
static char util_h_id[] = "@(#)$Id: util.h,v 1.3 2005/11/30 21:52:46 msk Exp $";
#endif /* !lint */

/* PROTOTYPES */
extern bool dkimf_checkhost(Peer list, char *host);
extern bool dkimf_checkip(Peer list, struct sockaddr *ip);
#ifdef _FFR_POPAUTH
extern bool dkimf_checkpopauth(char* dbfile, struct sockaddr *ip);
#endif
extern void dkimf_ffrlist(FILE *where);
extern size_t dkimf_inet_ntoa(struct in_addr a, char *buf, size_t buflen);
extern bool dkimf_load_list(FILE *in, struct Peer **list);
extern void dkimf_lowercase(char *str);
extern void dkimf_setmaxfd(void);
extern void dkimf_stripbrackets(char *addr);
extern void dkimf_stripcr(char *str);
extern void dkimf_trimspaces(char *str);

#endif /* _UTIL_H_ */
