/* This is an Scheme48/C interface file, 
** automatically generated by cig.
*/

#include <stdio.h>
#include <stdlib.h> /* For malloc. */
#include "libcig.h"

#include <sys/signal.h>
#include <sys/types.h>
#include <sys/times.h>
#include <sys/time.h>
#include <fcntl.h>		/* for O_RDWR */
#include <sys/stat.h>
#include <errno.h>
#include <netdb.h>
#include <pwd.h>
#include <unistd.h>

/* Make sure foreign-function stubs interface to the C funs correctly: */
#include "dirstuff1.h"
#include "fdports1.h"
#include "select1.h"
#include "syscalls1.h"
#include "userinfo1.h"

#define errno_on_zero_or_false(x) ((x) ? SCHFALSE : ENTER_FIXNUM(errno))
#define errno_or_false(x) (((x) == -1) ? ENTER_FIXNUM(errno) : SCHFALSE)
#define False_on_zero(x) ((x) ? ENTER_FIXNUM(x) : SCHFALSE)

scheme_value df_scheme_exec(long nargs, scheme_value *args)
{
    extern int scheme_exec(const char *, scheme_value , scheme_value );
    scheme_value ret1;
    int r1;

    cig_check_nargs(3, nargs, "scheme_exec");
    r1 = scheme_exec(cig_string_body(args[2]), args[1], args[0]);
    ret1 = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_exit(long nargs, scheme_value *args)
{
    extern void exit(int );

    cig_check_nargs(1, nargs, "exit");
    exit(EXTRACT_FIXNUM(args[0]));
    return SCHFALSE;
    }

scheme_value df__exit(long nargs, scheme_value *args)
{
    extern void _exit(int );

    cig_check_nargs(1, nargs, "_exit");
    _exit(EXTRACT_FIXNUM(args[0]));
    return SCHFALSE;
    }

scheme_value df_fork(long nargs, scheme_value *args)
{
    extern pid_t fork(void);
    scheme_value ret1;
    pid_t r1;

    cig_check_nargs(1, nargs, "fork");
    r1 = fork();
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_wait_pid(long nargs, scheme_value *args)
{
    extern scheme_value wait_pid(int , int , int *, int *);
    scheme_value ret1;
    scheme_value r1;
    int r2;
    int r3;

    cig_check_nargs(3, nargs, "wait_pid");
    r1 = wait_pid(EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]), &r2, &r3);
    ret1 = r1;
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r2);
    VECTOR_REF(*args,1) = ENTER_FIXNUM(r3);
    return ret1;
    }

scheme_value df_chdir(long nargs, scheme_value *args)
{
    extern int chdir(const char *);
    scheme_value ret1;
    int r1;

    cig_check_nargs(1, nargs, "chdir");
    r1 = chdir(cig_string_body(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_scheme_cwd(long nargs, scheme_value *args)
{
    extern int scheme_cwd(const char **);
    scheme_value ret1;
    int r1;
    const char *r2;

    cig_check_nargs(1, nargs, "scheme_cwd");
    r1 = scheme_cwd(&r2);
    ret1 = False_on_zero(r1);
    {AlienVal(CAR(VECTOR_REF(*args,0))) = (long) r2; CDR(VECTOR_REF(*args,0)) = strlen_or_false(r2);}
    return ret1;
    }

scheme_value df_getgid(long nargs, scheme_value *args)
{
    extern gid_t  getgid(void);
    scheme_value ret1;
    gid_t  r1;

    cig_check_nargs(0, nargs, "getgid");
    r1 = getgid();
    ret1 = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_getegid(long nargs, scheme_value *args)
{
    extern gid_t  getegid(void);
    scheme_value ret1;
    gid_t  r1;

    cig_check_nargs(0, nargs, "getegid");
    r1 = getegid();
    ret1 = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_setgid(long nargs, scheme_value *args)
{
    
    scheme_value ret1;
    int r1;

    cig_check_nargs(1, nargs, "setgid");
    r1 = setgid(EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_num_supp_groups(long nargs, scheme_value *args)
{
    extern int num_supp_groups(void);
    scheme_value ret1;
    int r1;

    cig_check_nargs(1, nargs, "num_supp_groups");
    r1 = num_supp_groups();
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_get_groups(long nargs, scheme_value *args)
{
    extern int get_groups(scheme_value );
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "get_groups");
    r1 = get_groups(args[1]);
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_getuid(long nargs, scheme_value *args)
{
    extern uid_t getuid(void);
    scheme_value ret1;
    uid_t r1;

    cig_check_nargs(0, nargs, "getuid");
    r1 = getuid();
    ret1 = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_geteuid(long nargs, scheme_value *args)
{
    extern uid_t geteuid(void);
    scheme_value ret1;
    uid_t r1;

    cig_check_nargs(0, nargs, "geteuid");
    r1 = geteuid();
    ret1 = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_setuid(long nargs, scheme_value *args)
{
    
    scheme_value ret1;
    int r1;

    cig_check_nargs(1, nargs, "setuid");
    r1 = setuid(EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_my_username(long nargs, scheme_value *args)
{
    extern char *my_username(void);
    scheme_value ret1;
    char *r1;

    cig_check_nargs(1, nargs, "my_username");
    r1 = my_username();
    ret1 = VECTOR_REF(*args,0);
    {AlienVal(CAR(ret1)) = (long) r1; CDR(ret1) = strlen_or_false(r1);}
    return ret1;
    }

scheme_value df_getpid(long nargs, scheme_value *args)
{
    extern pid_t getpid(void);
    scheme_value ret1;
    pid_t r1;

    cig_check_nargs(0, nargs, "getpid");
    r1 = getpid();
    ret1 = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_getppid(long nargs, scheme_value *args)
{
    extern pid_t getppid(void);
    scheme_value ret1;
    pid_t r1;

    cig_check_nargs(0, nargs, "getppid");
    r1 = getppid();
    ret1 = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_getpgrp(long nargs, scheme_value *args)
{
    extern pid_t getpgrp(void);
    scheme_value ret1;
    pid_t r1;

    cig_check_nargs(0, nargs, "getpgrp");
    r1 = getpgrp();
    ret1 = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_setpgid(long nargs, scheme_value *args)
{
    extern int setpgid(pid_t , pid_t );
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "setpgid");
    r1 = setpgid(EXTRACT_FIXNUM(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_setsid(long nargs, scheme_value *args)
{
    extern pid_t setsid(void);
    scheme_value ret1;
    pid_t r1;

    cig_check_nargs(1, nargs, "setsid");
    r1 = setsid();
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_umask(long nargs, scheme_value *args)
{
    
    scheme_value ret1;
    mode_t r1;

    cig_check_nargs(1, nargs, "umask");
    r1 = umask(EXTRACT_FIXNUM(args[0]));
    ret1 = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_process_times(long nargs, scheme_value *args)
{
    extern int process_times(int *, int *, int *, int *);
    scheme_value ret1;
    int r1;
    int r2;
    int r3;
    int r4;
    int r5;

    cig_check_nargs(1, nargs, "process_times");
    r1 = process_times(&r2, &r3, &r4, &r5);
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r2);
    VECTOR_REF(*args,1) = ENTER_FIXNUM(r3);
    VECTOR_REF(*args,2) = ENTER_FIXNUM(r4);
    VECTOR_REF(*args,3) = ENTER_FIXNUM(r5);
    return ret1;
    }

scheme_value df_cpu_clock_ticks_per_sec(long nargs, scheme_value *args)
{
    extern int cpu_clock_ticks_per_sec(void);
    scheme_value ret1;
    int r1;

    cig_check_nargs(0, nargs, "cpu_clock_ticks_per_sec");
    r1 = cpu_clock_ticks_per_sec();
    ret1 = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_chmod(long nargs, scheme_value *args)
{
    
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "chmod");
    r1 = chmod(cig_string_body(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_fchmod(long nargs, scheme_value *args)
{
    
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "fchmod");
    r1 = fchmod(EXTRACT_FIXNUM(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_chown(long nargs, scheme_value *args)
{
    
    scheme_value ret1;
    int r1;

    cig_check_nargs(3, nargs, "chown");
    r1 = chown(cig_string_body(args[2]), EXTRACT_FIXNUM(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_fchown(long nargs, scheme_value *args)
{
    
    scheme_value ret1;
    int r1;

    cig_check_nargs(3, nargs, "fchown");
    r1 = fchown(EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_access(long nargs, scheme_value *args)
{
    extern int access(const char *, int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "access");
    r1 = access(cig_string_body(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = ENTER_BOOLEAN(r1);
    return ret1;
    }

scheme_value df_link(long nargs, scheme_value *args)
{
    extern int link(const char *, const char *);
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "link");
    r1 = link(cig_string_body(args[1]), cig_string_body(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_mkfifo(long nargs, scheme_value *args)
{
    
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "mkfifo");
    r1 = mkfifo(cig_string_body(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_mkdir(long nargs, scheme_value *args)
{
    
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "mkdir");
    r1 = mkdir(cig_string_body(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_scm_readlink(long nargs, scheme_value *args)
{
    extern const char *scm_readlink(const char *);
    scheme_value ret1;
    const char *r1;

    cig_check_nargs(2, nargs, "scm_readlink");
    r1 = scm_readlink(cig_string_body(args[1]));
    ret1 = errno_on_zero_or_false(r1);
    {AlienVal(CAR(VECTOR_REF(*args,0))) = (long) r1; CDR(VECTOR_REF(*args,0)) = strlen_or_false(r1);}
    return ret1;
    }

scheme_value df_rename(long nargs, scheme_value *args)
{
    extern int rename(const char *, const char *);
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "rename");
    r1 = rename(cig_string_body(args[1]), cig_string_body(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_rmdir(long nargs, scheme_value *args)
{
    extern int rmdir(const char *);
    scheme_value ret1;
    int r1;

    cig_check_nargs(1, nargs, "rmdir");
    r1 = rmdir(cig_string_body(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_scm_utime(long nargs, scheme_value *args)
{
    extern int scm_utime(const char *, int , int , int , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(5, nargs, "scm_utime");
    r1 = scm_utime(cig_string_body(args[4]), EXTRACT_FIXNUM(args[3]), EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_scm_utime_now(long nargs, scheme_value *args)
{
    extern int scm_utime_now(const char *);
    scheme_value ret1;
    int r1;

    cig_check_nargs(1, nargs, "scm_utime_now");
    r1 = scm_utime_now(cig_string_body(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_scheme_stat(long nargs, scheme_value *args)
{
    extern int scheme_stat(const char *, scheme_value , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(3, nargs, "scheme_stat");
    r1 = scheme_stat(cig_string_body(args[2]), args[1], EXTRACT_BOOLEAN(args[0]));
    ret1 = False_on_zero(r1);
    return ret1;
    }

scheme_value df_scheme_fstat(long nargs, scheme_value *args)
{
    extern int scheme_fstat(int , scheme_value );
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "scheme_fstat");
    r1 = scheme_fstat(EXTRACT_FIXNUM(args[1]), args[0]);
    ret1 = False_on_zero(r1);
    return ret1;
    }

scheme_value df_symlink(long nargs, scheme_value *args)
{
    
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "symlink");
    r1 = symlink(cig_string_body(args[1]), cig_string_body(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_truncate(long nargs, scheme_value *args)
{
    
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "truncate");
    r1 = truncate(cig_string_body(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_ftruncate(long nargs, scheme_value *args)
{
    
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "ftruncate");
    r1 = ftruncate(EXTRACT_FIXNUM(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_unlink(long nargs, scheme_value *args)
{
    extern int unlink(const char *);
    scheme_value ret1;
    int r1;

    cig_check_nargs(1, nargs, "unlink");
    r1 = unlink(cig_string_body(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_fsync(long nargs, scheme_value *args)
{
    extern int fsync(int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(1, nargs, "fsync");
    r1 = fsync(EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_sync(long nargs, scheme_value *args)
{
    

    cig_check_nargs(0, nargs, "sync");
    sync();
    return SCHFALSE;
    }

scheme_value df_close(long nargs, scheme_value *args)
{
    extern int close(int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(1, nargs, "close");
    r1 = close(EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_dup(long nargs, scheme_value *args)
{
    extern int dup(int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "dup");
    r1 = dup(EXTRACT_FIXNUM(args[1]));
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_dup2(long nargs, scheme_value *args)
{
    extern int dup2(int , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(3, nargs, "dup2");
    r1 = dup2(EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]));
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_lseek(long nargs, scheme_value *args)
{
    extern off_t lseek(int , off_t , int );
    scheme_value ret1;
    off_t r1;

    cig_check_nargs(4, nargs, "lseek");
    r1 = lseek(EXTRACT_FIXNUM(args[3]), EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]));
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_char_ready_fdes(long nargs, scheme_value *args)
{
    extern scheme_value char_ready_fdes(int );
    scheme_value ret1;
    scheme_value r1;

    cig_check_nargs(1, nargs, "char_ready_fdes");
    r1 = char_ready_fdes(EXTRACT_FIXNUM(args[0]));
    ret1 = r1;
    return ret1;
    }

scheme_value df_open(long nargs, scheme_value *args)
{
    
    scheme_value ret1;
    int r1;

    cig_check_nargs(4, nargs, "open");
    r1 = open(cig_string_body(args[3]), EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]));
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_scheme_pipe(long nargs, scheme_value *args)
{
    extern int scheme_pipe(int *, int *);
    scheme_value ret1;
    int r1;
    int r2;
    int r3;

    cig_check_nargs(1, nargs, "scheme_pipe");
    r1 = scheme_pipe(&r2, &r3);
    ret1 = False_on_zero(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r2);
    VECTOR_REF(*args,1) = ENTER_FIXNUM(r3);
    return ret1;
    }

scheme_value df_read_fdes_char(long nargs, scheme_value *args)
{
    extern scheme_value read_fdes_char(int );
    scheme_value ret1;
    scheme_value r1;

    cig_check_nargs(1, nargs, "read_fdes_char");
    r1 = read_fdes_char(EXTRACT_FIXNUM(args[0]));
    ret1 = r1;
    return ret1;
    }

scheme_value df_write_fdes_char(long nargs, scheme_value *args)
{
    extern int write_fdes_char(char , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "write_fdes_char");
    r1 = write_fdes_char(EXTRACT_CHAR(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_read_fdes_substring(long nargs, scheme_value *args)
{
    extern int read_fdes_substring(scheme_value , int , int , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(5, nargs, "read_fdes_substring");
    r1 = read_fdes_substring(args[4], EXTRACT_FIXNUM(args[3]), EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]));
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_write_fdes_substring(long nargs, scheme_value *args)
{
    extern int write_fdes_substring(scheme_value , int , int , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(5, nargs, "write_fdes_substring");
    r1 = write_fdes_substring(args[4], EXTRACT_FIXNUM(args[3]), EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]));
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_kill(long nargs, scheme_value *args)
{
    extern int kill(pid_t , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "kill");
    r1 = kill(EXTRACT_FIXNUM(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_pause(long nargs, scheme_value *args)
{
    

    cig_check_nargs(0, nargs, "pause");
    pause();
    return SCHFALSE;
    }

scheme_value df_alarm(long nargs, scheme_value *args)
{
    extern unsigned int alarm(unsigned int );
    scheme_value ret1;
    unsigned int r1;

    cig_check_nargs(1, nargs, "alarm");
    r1 = alarm(EXTRACT_FIXNUM(args[0]));
    ret1 = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_user_info_uid(long nargs, scheme_value *args)
{
    extern int user_info_uid(uid_t , char **, gid_t  *, char **, char **);
    scheme_value ret1;
    int r1;
    char *r2;
    gid_t  r3;
    char *r4;
    char *r5;

    cig_check_nargs(2, nargs, "user_info_uid");
    r1 = user_info_uid(EXTRACT_FIXNUM(args[1]), &r2, &r3, &r4, &r5);
    ret1 = ENTER_BOOLEAN(r1);
    {AlienVal(CAR(VECTOR_REF(*args,0))) = (long) r2; CDR(VECTOR_REF(*args,0)) = strlen_or_false(r2);}
    VECTOR_REF(*args,1) = ENTER_FIXNUM(r3);
    {AlienVal(CAR(VECTOR_REF(*args,2))) = (long) r4; CDR(VECTOR_REF(*args,2)) = strlen_or_false(r4);}
    {AlienVal(CAR(VECTOR_REF(*args,3))) = (long) r5; CDR(VECTOR_REF(*args,3)) = strlen_or_false(r5);}
    return ret1;
    }

scheme_value df_user_info_name(long nargs, scheme_value *args)
{
    extern int user_info_name(const char *, uid_t *, gid_t  *, char **, char **);
    scheme_value ret1;
    int r1;
    uid_t r2;
    gid_t  r3;
    char *r4;
    char *r5;

    cig_check_nargs(2, nargs, "user_info_name");
    r1 = user_info_name(cig_string_body(args[1]), &r2, &r3, &r4, &r5);
    ret1 = ENTER_BOOLEAN(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r2);
    VECTOR_REF(*args,1) = ENTER_FIXNUM(r3);
    {AlienVal(CAR(VECTOR_REF(*args,2))) = (long) r4; CDR(VECTOR_REF(*args,2)) = strlen_or_false(r4);}
    {AlienVal(CAR(VECTOR_REF(*args,3))) = (long) r5; CDR(VECTOR_REF(*args,3)) = strlen_or_false(r5);}
    return ret1;
    }

scheme_value df_group_info_gid(long nargs, scheme_value *args)
{
    extern int group_info_gid(int , char **, char** *, int *);
    scheme_value ret1;
    int r1;
    char *r2;
    char** r3;
    int r4;

    cig_check_nargs(2, nargs, "group_info_gid");
    r1 = group_info_gid(EXTRACT_FIXNUM(args[1]), &r2, &r3, &r4);
    ret1 = ENTER_BOOLEAN(r1);
    {AlienVal(CAR(VECTOR_REF(*args,0))) = (long) r2; CDR(VECTOR_REF(*args,0)) = strlen_or_false(r2);}
    AlienVal(VECTOR_REF(*args,1)) = (long) r3;
    VECTOR_REF(*args,2) = ENTER_FIXNUM(r4);
    return ret1;
    }

scheme_value df_group_info_name(long nargs, scheme_value *args)
{
    extern int group_info_name(const char *, int *, char** *, int *);
    scheme_value ret1;
    int r1;
    int r2;
    char** r3;
    int r4;

    cig_check_nargs(2, nargs, "group_info_name");
    r1 = group_info_name(cig_string_body(args[1]), &r2, &r3, &r4);
    ret1 = ENTER_BOOLEAN(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r2);
    AlienVal(VECTOR_REF(*args,1)) = (long) r3;
    VECTOR_REF(*args,2) = ENTER_FIXNUM(r4);
    return ret1;
    }

scheme_value df_open_dir(long nargs, scheme_value *args)
{
    extern int open_dir(const char *, char** *, int *);
    scheme_value ret1;
    int r1;
    char** r2;
    int r3;

    cig_check_nargs(2, nargs, "open_dir");
    r1 = open_dir(cig_string_body(args[1]), &r2, &r3);
    ret1 = False_on_zero(r1);
    AlienVal(VECTOR_REF(*args,0)) = (long) r2;
    VECTOR_REF(*args,1) = ENTER_FIXNUM(r3);
    return ret1;
    }

scheme_value df_scm_sort_filevec(long nargs, scheme_value *args)
{
    extern void scm_sort_filevec(const char** , int );

    cig_check_nargs(2, nargs, "scm_sort_filevec");
    scm_sort_filevec((const char** )AlienVal(args[1]), EXTRACT_FIXNUM(args[0]));
    return SCHFALSE;
    }

scheme_value df_scm_envvec(long nargs, scheme_value *args)
{
    extern char** scm_envvec(int *);
    scheme_value ret1;
    char** r1;
    int r2;

    cig_check_nargs(1, nargs, "scm_envvec");
    r1 = scm_envvec(&r2);
    ret1 = VECTOR_REF(*args,0);
    AlienVal(ret1) = (long) r1;
    VECTOR_REF(*args,1) = ENTER_FIXNUM(r2);
    return ret1;
    }

scheme_value df_install_env(long nargs, scheme_value *args)
{
    extern int install_env(scheme_value );
    scheme_value ret1;
    int r1;

    cig_check_nargs(1, nargs, "install_env");
    r1 = install_env(args[0]);
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_getenv(long nargs, scheme_value *args)
{
    extern char *getenv(const char *);
    scheme_value ret1;
    char *r1;

    cig_check_nargs(2, nargs, "getenv");
    r1 = getenv(cig_string_body(args[1]));
    ret1 = VECTOR_REF(*args,0);
    {AlienVal(CAR(ret1)) = (long) r1; CDR(ret1) = strlen_or_false(r1);}
    return ret1;
    }

#define errno_on_nonzero_or_false(x) ((x) ? ENTER_FIXNUM(errno) : SCHFALSE)

scheme_value df_putenv(long nargs, scheme_value *args)
{
    
    scheme_value ret1;
    int r1;

    cig_check_nargs(1, nargs, "putenv");
    r1 = putenv(scheme2c_strcpy(args[0]));
    ret1 = errno_on_nonzero_or_false(r1);
    return ret1;
    }

scheme_value df_delete_env(long nargs, scheme_value *args)
{
    extern void delete_env(const char *);

    cig_check_nargs(1, nargs, "delete_env");
    delete_env(cig_string_body(args[0]));
    return SCHFALSE;
    }

scheme_value df_close_fdport(long nargs, scheme_value *args)
{
    extern int close_fdport(scheme_value );
    scheme_value ret1;
    int r1;

    cig_check_nargs(1, nargs, "close_fdport");
    r1 = close_fdport(args[0]);
    ret1 = False_on_zero(r1);
    return ret1;
    }

scheme_value df_fdport_getchar(long nargs, scheme_value *args)
{
    extern scheme_value fdport_getchar(scheme_value );
    scheme_value ret1;
    scheme_value r1;

    cig_check_nargs(1, nargs, "fdport_getchar");
    r1 = fdport_getchar(args[0]);
    ret1 = r1;
    return ret1;
    }

scheme_value df_fdport_char_readyp(long nargs, scheme_value *args)
{
    extern scheme_value fdport_char_readyp(scheme_value );
    scheme_value ret1;
    scheme_value r1;

    cig_check_nargs(1, nargs, "fdport_char_readyp");
    r1 = fdport_char_readyp(args[0]);
    ret1 = r1;
    return ret1;
    }

scheme_value df_fdport_putchar(long nargs, scheme_value *args)
{
    extern int fdport_putchar(scheme_value , char );
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "fdport_putchar");
    r1 = fdport_putchar(args[1], EXTRACT_CHAR(args[0]));
    ret1 = False_on_zero(r1);
    return ret1;
    }

scheme_value df_flush_fdport(long nargs, scheme_value *args)
{
    extern int flush_fdport(scheme_value );
    scheme_value ret1;
    int r1;

    cig_check_nargs(1, nargs, "flush_fdport");
    r1 = flush_fdport(args[0]);
    ret1 = False_on_zero(r1);
    return ret1;
    }

scheme_value df_flush_all_ports(long nargs, scheme_value *args)
{
    extern int flush_all_ports(void);
    scheme_value ret1;
    int r1;

    cig_check_nargs(0, nargs, "flush_all_ports");
    r1 = flush_all_ports();
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_seek_fdport(long nargs, scheme_value *args)
{
    extern int seek_fdport(scheme_value , off_t , int , int *);
    scheme_value ret1;
    int r1;
    int r2;

    cig_check_nargs(4, nargs, "seek_fdport");
    r1 = seek_fdport(args[3], EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]), &r2);
    ret1 = False_on_zero(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r2);
    return ret1;
    }

scheme_value df_tell_fdport(long nargs, scheme_value *args)
{
    extern int tell_fdport(scheme_value , int *);
    scheme_value ret1;
    int r1;
    int r2;

    cig_check_nargs(2, nargs, "tell_fdport");
    r1 = tell_fdport(args[1], &r2);
    ret1 = False_on_zero(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r2);
    return ret1;
    }

scheme_value df_set_fdbuf(long nargs, scheme_value *args)
{
    extern int set_fdbuf(scheme_value , int , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(3, nargs, "set_fdbuf");
    r1 = set_fdbuf(args[2], EXTRACT_FIXNUM(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = False_on_zero(r1);
    return ret1;
    }

scheme_value df_set_cloexec(long nargs, scheme_value *args)
{
    extern int set_cloexec(int , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "set_cloexec");
    r1 = set_cloexec(EXTRACT_FIXNUM(args[1]), EXTRACT_BOOLEAN(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_init_fdports(long nargs, scheme_value *args)
{
    extern void init_fdports(void);

    cig_check_nargs(0, nargs, "init_fdports");
    init_fdports();
    return SCHFALSE;
    }

scheme_value df_install_port(long nargs, scheme_value *args)
{
    extern int install_port(int , scheme_value , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(3, nargs, "install_port");
    r1 = install_port(EXTRACT_FIXNUM(args[2]), args[1], EXTRACT_FIXNUM(args[0]));
    ret1 = False_on_zero(r1);
    return ret1;
    }

scheme_value df_maybe_fdes2port(long nargs, scheme_value *args)
{
    extern scheme_value maybe_fdes2port(int );
    scheme_value ret1;
    scheme_value r1;

    cig_check_nargs(1, nargs, "maybe_fdes2port");
    r1 = maybe_fdes2port(EXTRACT_FIXNUM(args[0]));
    ret1 = r1;
    return ret1;
    }

scheme_value df_move_fdport(long nargs, scheme_value *args)
{
    extern int move_fdport(int , scheme_value , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(3, nargs, "move_fdport");
    r1 = move_fdport(EXTRACT_FIXNUM(args[2]), args[1], EXTRACT_FIXNUM(args[0]));
    ret1 = ENTER_BOOLEAN(r1);
    return ret1;
    }

scheme_value df_read_fdport_substring(long nargs, scheme_value *args)
{
    extern int read_fdport_substring(scheme_value , int , int , scheme_value );
    scheme_value ret1;
    int r1;

    cig_check_nargs(5, nargs, "read_fdport_substring");
    r1 = read_fdport_substring(args[4], EXTRACT_FIXNUM(args[3]), EXTRACT_FIXNUM(args[2]), args[1]);
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_write_fdport_substring(long nargs, scheme_value *args)
{
    extern int write_fdport_substring(scheme_value , int , int , scheme_value );
    scheme_value ret1;
    int r1;

    cig_check_nargs(5, nargs, "write_fdport_substring");
    r1 = write_fdport_substring(args[4], EXTRACT_FIXNUM(args[3]), EXTRACT_FIXNUM(args[2]), args[1]);
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_fcntl_read(long nargs, scheme_value *args)
{
    extern int fcntl_read(int , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(3, nargs, "fcntl_read");
    r1 = fcntl_read(EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]));
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_fcntl_write(long nargs, scheme_value *args)
{
    extern int fcntl_write(int , int , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(3, nargs, "fcntl_write");
    r1 = fcntl_write(EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_sleep_until(long nargs, scheme_value *args)
{
    extern scheme_value sleep_until(int , int );
    scheme_value ret1;
    scheme_value r1;

    cig_check_nargs(2, nargs, "sleep_until");
    r1 = sleep_until(EXTRACT_FIXNUM(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = r1;
    return ret1;
    }

scheme_value df_scm_gethostname(long nargs, scheme_value *args)
{
    extern char *scm_gethostname(void);
    scheme_value ret1;
    char *r1;

    cig_check_nargs(1, nargs, "scm_gethostname");
    r1 = scm_gethostname();
    ret1 = VECTOR_REF(*args,0);
    {AlienVal(CAR(ret1)) = (long) r1; CDR(ret1) = strlen_or_false(r1);}
    return ret1;
    }

scheme_value df_errno_msg(long nargs, scheme_value *args)
{
    extern char *errno_msg(int );
    scheme_value ret1;
    char *r1;

    cig_check_nargs(2, nargs, "errno_msg");
    r1 = errno_msg(EXTRACT_FIXNUM(args[1]));
    ret1 = VECTOR_REF(*args,0);
    {AlienVal(CAR(ret1)) = (long) r1; CDR(ret1) = strlen_or_false(r1);}
    return ret1;
    }

