;;; Module definitions for the scsh regexp system.
;;;     -Olin <shivers@ai.mit.edu> 8/98

(define-interface basic-re-interface
  (export re-dsm? make-re-dsm
	  re-dsm:body
	  re-dsm:pre-dsm 
	  re-dsm:tsm 
	  re-dsm:posix set-re-dsm:posix
	  re-dsm:post-dsm
	  re-dsm open-dsm

	  re-seq? %%make-re-seq %make-re-seq make-re-seq re-seq
	  re-seq:elts
	  re-seq:tsm
	  re-seq:posix set-re-seq:posix

	  re-choice? %%make-re-choice %make-re-choice make-re-choice re-choice
	  re-choice:elts
	  re-choice:tsm
	  re-choice:posix set-re-choice:posix

	  re-repeat? %%make-re-repeat %make-re-repeat make-re-repeat re-repeat
	  re-repeat:from
	  re-repeat:to
	  re-repeat:body
	  re-repeat:tsm
	  re-repeat:posix set-re-repeat:posix

	  re-submatch?
	  %%make-re-submatch %make-re-submatch make-re-submatch re-submatch
	  re-submatch:body
	  re-submatch:pre-dsm
	  re-submatch:tsm
	  re-submatch:posix set-re-submatch:posix
	  re-submatch:post-dsm

	  re-string? make-re-string re-string
	  re-string:chars set-re-string:chars
	  re-string:posix set-re-string:posix

	  re-trivial re-trivial?

	  re-char-set? make-re-char-set re-char-set
	  re-char-set:cset set-re-char-set:cset 
	  re-char-set:posix set-re-char-set:posix

	  re-empty re-empty?
	  re-bos re-bos?	  re-eos re-eos?
	  re-bol re-bol?	  re-eol re-eol?
	  re-bow re-bow?	  re-eow re-eow?

	  re-any re-any?

	  re-nonl
	  re-word

	  regexp?
	  re-tsm

	  flush-submatches	; Can be in code produced by RX expander.
	  uncase		; Can be in code produced by RX expander.
	  uncase-char-set	; Can be in code produced by RX expander.
	  uncase-string
	  ))


;;; These guys were made obsolete by the new SRE package and exist for
;;; backwards compatibility only.
(define-interface re-old-funs-interface
  (export string-match make-regexp regexp-exec ->regexp regexp-quote))


(define-interface re-internals-interface
  (export make-re-string/posix		; Constructors for the Scheme unparser
	  %make-re-seq/posix
	  %make-re-choice/posix
	  make-re-char-set/posix
	  %make-re-repeat/posix
	  %make-re-dsm/posix
	  %make-re-submatch/posix))


(define-interface posix-re-interface
  (export regexp->posix-string		; posixstr.scm
	  posix-string->regexp		; spencer
	  ))

(define-interface re-exports-interface
  (compound-interface posix-re-interface
		      basic-re-interface
		      (export regexp-match?
			      match:start match:end match:substring
			      clean-up-cres
			      regexp-search regexp-search?
			      regexp-substitute regexp-substitute/global
			      sre->regexp regexp->sre
			      )))


(define-structures ((re-exports re-exports-interface)
		    (re-internals re-internals-interface)
		    (sre-syntax-tools (export expand-rx sre-form?))
		    )
  (open scsh-utilities
	defrec-package
	define-foreign-syntax
	weak		
	;re-posix-parsers	; regexp->posix-string
	let-opt
	sort			; Posix renderer
	conditionals
	define-record-types
	defrec-package
	receiving
	scsh
	scheme)
  (files re-low re simp re-high
	 parse posixstr spencer re-syntax)
  (optimize auto-integrate)
  )

;;; Stuff that could appear in code produced by (rx ...)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define-interface rx-lib-interface
  (compound-interface (export coerce-dynamic-regexp
			      coerce-dynamic-charset
			      spec->char-set
			      flush-submatches
			      uncase
			      uncase-char-set
			      uncase-string)
		      re-internals-interface))

(define-structure rx-lib rx-lib-interface
  (open re-internals
	conditionals re-exports scsh scheme)
  (files rx-lib)
  (optimize auto-integrate))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define-structure rx-syntax (export (rx :syntax)
				    (if-sre-form :syntax))
  (open re-exports
	rx-lib
	scheme)
  (for-syntax (open sre-syntax-tools scheme))
  (begin (define-syntax rx expand-rx)
	 (define-syntax if-sre-form
	   (lambda (exp r c)
	     (if (sre-form? (cadr exp) r c)
		 (caddr exp)
		 (cadddr exp)))))
  (optimize auto-integrate))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define-structure re-old-funs re-old-funs-interface
  (open re-exports scsh scheme)
  (files oldfuns))



;;; File	Exports
;;; ----	-------
;;; parse	sre->regexp regexp->sre  
;;;             parse-sre parse-sres regexp->scheme
;;;             char-set->in-pair
;;; posixstr	regexp->posix-string
;;; re-high	compile-regexp regexp-search regexp-search? 
;;;             regexp-substitute regexp-substitute/global
;;; re-low	match:start match:end match:substring
;;;             CRE record, new-cre, compile-posix-re->c-struct
;;;             cre-search cre-search? clean-up-cres
;;; re-syntax	sre-form? if-sre-form expand-rx
;;; re.scm	The ADT. flush-submatches uncase uncase-char-set
;;;             char-set-full? char-set-empty?
;;;             re-char-class? static-char-class?
;;; rx-lib	coerce-dynamic-regexp coerce-dynamic-charset spec->char-set
;;; simp	simplify-regexp
;;; spencer	posix-string->regexp
