/* Sam Thibault
** ODBC/SQL interface for scsh
** Spring 1999
*/

/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/

/* All the functions contained in this file are linked to
** define-foreign functions in the file "interface.scm".  The C stubs
** for those define-foreign functions are located in "interface.c". 
*/

/* double dividers are used to separate functions with very different
** uses, variables, and include file. single dividers separate functions
** with the same general use but for a slightly different purpose (like
** a different variable type). 
**
** dividers:
**
**  single: /*-----*/       
/* 
**  double: /*-----*/
/*          /*-----*/
/*
*/

/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h> /* For malloc. */
#include <string.h>
#include <stddef.h>
/*#include "./../cig/scheme48.h"
 */
#include "libcig.h"


/* the solid header files include odbc function definitions
** and definitions for variables and constants 
*/
#if 0
#include "cli0cli.h"
#include "cli0defs.h"
#include "cli0env.h"
#else
#include <windows.h>
#include <sql.h>
#include <sqlext.h>
#endif

/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/

/* the following variables are used when calling SQLError
** to get error messages from the server. they are used in the
** following functions: GetHenvError, GetHdbcError, GetHstmtError,
** GetHenvState, GetHdbcState, GetHstmtState, GetHenvErrorState,
** GetHdbcErrorState, GetHstmtErrorState 
*/

RETCODE retcode;
UCHAR SqlState[200], ErrorMsg[200];
SDWORD NativeError;
SWORD MsgMax=200;
SWORD pcbError;

/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/

/* the henv functions below are used to make, reference, and
** free environment handles (variables of the type SQLHENV) 
*/

SQLHENV* makesqlhenv(void)
{  
  SQLHENV* EnvPointer = (SQLHENV*)malloc(sizeof(SQLHENV));
  return EnvPointer;
}

SQLHENV derefsqlhenv(SQLHENV* EnvPointer)
{
  return *EnvPointer;
}

scheme_value freesqlhenv(SQLHENV* EnvPointer)
{
  free(*EnvPointer);
  return SCHTRUE;
}

/*---------------------------------------------------------------------*/

/* the SQLHDBC functions below are used to make, reference, and
** free environment handles (variables of the type SQLHDBC) 
*/

SQLHDBC* makesqlhdbc(void)
{
  SQLHDBC* DBCPointer = (SQLHDBC*)malloc(sizeof(SQLHDBC));
  return DBCPointer;
}

SQLHDBC derefsqlhdbc(SQLHDBC* DBCPointer)
{
  return *DBCPointer;
}

scheme_value freesqlhdbc(SQLHDBC* DBCPointer)
{
  free(DBCPointer);
  return SCHTRUE;
}

/*---------------------------------------------------------------------*/

/* the SQLHSTMT functions below are used to make, reference, and
** free environment handles (variables of the type SQLHSTMT) 
*/

SQLHSTMT* makesqlhstmt(void)
{
  SQLHSTMT* StmtPointer = (SQLHSTMT*)malloc(sizeof(SQLHSTMT));
  return StmtPointer;
}

SQLHSTMT derefsqlhstmt(SQLHSTMT* StmtPointer)
{
  return *StmtPointer;
}

scheme_value freesqlhstmt(SQLHSTMT* StmtPointer)
{
  free(StmtPointer);
  return SCHTRUE;
}

/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/

/* the "Storage" functions are used to make and free space in the C
** heap for void* variables.  these are needed to hold information until
** the date can be cast to a specific type 
*/

void* makeStorage(SDWORD* pcbValue)
{
  void* rgbValue = malloc(*pcbValue);
  return rgbValue;
}

scheme_value freeStorage(void* rgbValue)
{
  free(rgbValue);
  return SCHTRUE;
}

/*---------------------------------------------------------------------*/

/* the SDWORD functions below are used to make, reference, get 
** values from, assign new values to, and free variables of the 
** type SDWORD (signed long ints) 
*/

SDWORD* makeSDWORD(void)
{
  SDWORD* SDWORDpointer = (SDWORD*)malloc(sizeof(SDWORD));
  return SDWORDpointer;
}

SDWORD derefSDWORD(SDWORD* SDWORDpointer)
{
  return *SDWORDpointer;
}

SDWORD extractSDWORD(SDWORD* SDWORDpointer)
{
  return *SDWORDpointer;
}

scheme_value assignSDWORD(SDWORD* SDWORDpointer, long value)
{
  *SDWORDpointer = value;
  return SCHTRUE;
}

scheme_value freeSDWORD(SDWORD* SDWORDpointer)
{
  free(SDWORDpointer);
  return SCHTRUE;
}

/*---------------------------------------------------------------------*/

/* the UDWORD functions below are used to make, reference, get 
** values from, assign new values to, and free variables of the 
** type UDWORD (unsigned long ints) 
*/

UDWORD* makeUDWORD(void)
{
  UDWORD* UDWORDpointer = (UDWORD*)malloc(sizeof(UDWORD));
  return UDWORDpointer;
}

UDWORD derefUDWORD(UDWORD* UDWORDpointer)
{
  return *UDWORDpointer;
}

UDWORD extractUDWORD(UDWORD* UDWORDpointer)
{
  return *UDWORDpointer;
}

scheme_value freeUDWORD(UDWORD* UDWORDpointer)
{
  free(UDWORDpointer);
  return SCHTRUE;
}

/*---------------------------------------------------------------------*/

/* the SWORD functions below are used to make, reference, get 
** values from, assign new values to, and free variables of the 
** type SWORD (signed short ints) 
*/

SWORD* makeSWORD(void)
{
  SWORD* SWORDpointer = (SWORD*)malloc(sizeof(SWORD));
  return SWORDpointer;
}

SWORD derefSWORD(SWORD* SWORDpointer)
{
  return *SWORDpointer;
}

SWORD extractSWORD(SWORD* SWORDpointer)
{
  return *SWORDpointer;
}

scheme_value assignSWORD(SWORD* SWORDpointer, long value)
{
  *SWORDpointer = (short)value;
  return SCHTRUE;
}

scheme_value freeSWORD(SWORD* SWORDpointer)
{
  free(SWORDpointer);
  return SCHTRUE;
}

/*---------------------------------------------------------------------*/

/* the UCHAR functions below are used to make, reference, and 
** free variables of the type UCHAR (strings) 
*/

unsigned char * makeUCHAR(void)
{
  unsigned char * UCHARpointer = (unsigned char *)malloc(sizeof(UCHAR));
  return UCHARpointer;
}

UCHAR derefUCHAR(unsigned char * UCHARpointer)
{
  return *UCHARpointer;
}

UCHAR extractUCHAR(unsigned char * UCHARpointer)
{
  return *UCHARpointer;
}

scheme_value freeUCHAR(unsigned char * UCHARpointer)
{
  free(UCHARpointer);
  return SCHTRUE;
}

/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/

/* the VoidTo functions below are used cast void* variables into
** either strings or integers 
*/

const char * VoidToString(PTR pointer)
{
  return (const char *)pointer;
}

int VoidToInteger(PTR pointer)
{
  return *(int*)pointer;
}

/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/

/* the ToVoid functions below are used insert either string or integer
** values into void* variables.
*/

void* StringToVoid(scheme_value sstr, PTR pointer)
{ 
  int slen;
  slen = STRING_LENGTH(sstr);
  strncpy(pointer, (char*)StobData(sstr), slen);
  ((char*)pointer)[slen] = '\000';
  return pointer;
}

void* FixedStringToVoid(scheme_value sstr, UDWORD clen, PTR pointer)
{ 
  int slen, i;
  slen = STRING_LENGTH(sstr);
  strncpy(pointer, (char*)StobData(sstr), slen);
  for (i = slen ; i <= clen ; i ++)
    ((char*)pointer)[i] = ' ';
  ((char*)pointer)[clen] = '\000';
  return pointer;
}

void* IntegerToVoid(int value, PTR pointer)
{
  *((int*)pointer) = value;
  return pointer;
}


/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/

/* the Error(State) functions below make calls to the ODBC function
** SQLError.  the values returned to scheme are strings which contain
** the error message (Error), the error state (State), or the two
** concatenated together (ErrorState). 
*/

/*---------------------------------------------------------------------*/

/* Error */

UCHAR* GetHenvError(SQLHENV sqlhenv)
{
  SQLError(sqlhenv, 0, 0, SqlState, &NativeError, ErrorMsg, MsgMax, &pcbError);
  return ErrorMsg;
}

UCHAR* GetHdbcError(SQLHENV sqlhenv, SQLHDBC sqlhdbc)
{
  SQLError(sqlhenv, sqlhdbc, 0, SqlState, &NativeError, ErrorMsg, MsgMax, &pcbError);
  return ErrorMsg;
}

UCHAR* GetHstmtError(SQLHENV sqlhenv, SQLHSTMT sqlhstmt)
{
  SQLError(sqlhenv, 0, sqlhstmt, SqlState, &NativeError, ErrorMsg, MsgMax, &pcbError);
  return ErrorMsg;
}

/*---------------------------------------------------------------------*/

/* State */

UCHAR* GetHenvtate(SQLHENV sqlhenv)
{
  SQLError(sqlhenv, 0, 0, SqlState, &NativeError, ErrorMsg, MsgMax, &pcbError);
  return SqlState;
}

UCHAR* GetHdbcState(SQLHENV sqlhenv, SQLHDBC sqlhdbc)
{
  SQLError(sqlhenv, sqlhdbc, 0, SqlState, &NativeError, ErrorMsg, MsgMax, &pcbError);
  return SqlState;
}

UCHAR* GetHstmtState(SQLHENV sqlhenv, SQLHSTMT sqlhstmt)
{
  SQLError(sqlhenv, 0, sqlhstmt, SqlState, &NativeError, ErrorMsg, MsgMax, &pcbError);
  return SqlState;
}

/*---------------------------------------------------------------------*/

/* Error and State for multiple value return*/

UCHAR* GetHenvErrorState(SQLHENV sqlhenv, UCHAR** msgval)
{
  SQLError(sqlhenv, 0, 0, SqlState, &NativeError, ErrorMsg, MsgMax, &pcbError);
  *msgval = ErrorMsg;
  return SqlState;
}

UCHAR* GetHdbcErrorState(SQLHENV sqlhenv, SQLHDBC sqlhdbc,  UCHAR** msgval)
{
  SQLError(sqlhenv, sqlhdbc, 0, SqlState, &NativeError, ErrorMsg, MsgMax, &pcbError);
  *msgval = ErrorMsg;
  return SqlState;
}

UCHAR* GetHstmtErrorState(SQLHENV sqlhenv, SQLHSTMT sqlhstmt, UCHAR** msgval)
{
  SQLError(sqlhenv, 0, sqlhstmt, SqlState, &NativeError, ErrorMsg, MsgMax, &pcbError);
  *msgval = ErrorMsg;
  return SqlState;
}

/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/
