/* Need to turn off synchronous error signals (SIGPIPE, SIGSYS). */

#include "../scsh_aux.h"

/* Make sure our exports match up w/the implementation: */
#include "../signals1.h"

/* This table converts Unix signal numbers to S48/scsh interrupt numbers.
** If the signal doesn't have an interrupt number, the entry is -1.
** (Only asynchronous signals have interrupt numbers.)
**
** Note that we bake into this table the integer values of the signals --
** i.e., we assume that SIGHUP=1, SIGALRM=15, etc. So this definition is
** very system-dependent.
*/
const int sig2int[] = {
  	-1,		/* 0 is not a signal */
	scshint_hup,	/* SIGHUP */
	scshint_keyboard,	/* SIGINT */
	scshint_quit,	/* SIGQUIT */
	-1,		/* SIGILL */
	-1,		/* SIGTRAP */
	-1,		/* SIGABRT & SIGIOT */
	-1,		/* SIGEMT */
	-1,		/* SIGFPE */
	-1,		/* SIGKILL */
	-1,		/* SIGBUS */
	-1,		/* SIGSEGV */
	-1,		/* SIGSYS */
	-1,		/* SIGPIPE */
	scshint_alarm,	/* SIGALRM */
	scshint_term,	/* SIGTERM */
	scshint_urg,	/* SIGURG */
	-1,		/* SIGSTOP */
	scshint_tstp,	/* SIGTSTP */
	scshint_cont,	/* SIGCONT */
	scshint_chld,	/* SIGCHLD */
	-1, /*	scshint_ttyin,	/* SIGTTIN */
	-1, /*	scshint_ttou,	/* SIGTTOU */
	scshint_io,	/* SIGIO */
	scshint_xcpu,	/* SIGXCPU */
	scshint_xfsz,	/* SIGXFSZ */
	-1,		/* SIGMSG */
	scshint_winch,	/* SIGWINCH */
	scshint_pwr,	/* SIGPWR */
	scshint_usr1,	/* SIGUSR1 */
	scshint_usr2,	/* SIGUSR2 */
	scshint_prof,	/* SIGPROF */
	-1,		/* SIGDANGER */
	scshint_vtalrm,	/* SIGVTALRM */
	-1,		/* SIGMIGRATE */
	-1,		/* SIGPRE */
	-1,		/* SIGVIRT */
	-1,		/* SIGALRM1 */
	-1		/* SIGWAITING */
        };

const int max_sig = 39; /* SIGWAITING */

/*
scshint_alarm
scshint_keyboard
scshint_memory_shortage
scshint_chld
scshint_cont
scshint_hup
scshint_quit
scshint_term
scshint_tstp
scshint_usr1
scshint_usr2
scshint_info
scshint_io
scshint_poll
scshint_prof
scshint_pwr
scshint_urg
scshint_vtalrm
scshint_winch
scshint_xcpu
scshint_xfsz

SIGALRM
SIGCHLD
SIGCONT
SIGHUP
SIGINFO
SIGINT
SIGIO
SIGPROF
SIGQUIT
SIGTERM
SIGTSTP
SIGTTIN
SIGTTOU
SIGURG
SIGUSR1
SIGUSR2
SIGVTALRM
SIGWINCH
SIGXCPU
SIGXFSZ

SIGHUP	1
SIGINT	2
SIGQUIT	3
SIGILL	4
SIGTRAP	5
SIGABRT	6
SIGIOT	SIGABRT
SIGEMT	7
SIGFPE	8
SIGKILL	9
SIGBUS	10
SIGSEGV	11
SIGSYS	12
SIGPIPE	13
SIGALRM	14
SIGTERM	15
SIGURG	16
SIGSTOP	17
SIGTSTP	18
SIGCONT	19
SIGCHLD	20
SIGTTIN	21
SIGTTOU	22
SIGIO	23
SIGXCPU	24
SIGXFSZ	25
SIGVTALRM 26
SIGPROF	27
SIGWINCH 28
SIGINFO	29
SIGUSR1 30
SIGUSR2 31
*/
