/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;

public class FileOutputStream
extends OutputStream {
    private FileDescriptor fd = new FileDescriptor();

    public native void close() throws IOException;

    protected void finalize() throws IOException {
        this.close();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage());
        }
    }

    public final FileDescriptor getFD() throws IOException {
        return this.fd;
    }

    private native void open(String var1);

    private native void openAppend(String var1);

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2);
    }

    public native void write(int var1) throws IOException;

    private native void writeBytes(byte[] var1, int var2, int var3);

    public FileOutputStream(File file) throws IOException {
        this(file.getPath());
    }

    public FileOutputStream(FileDescriptor fileDescriptor) {
        System.getSecurityManager().checkWrite(fileDescriptor);
        this.fd = fileDescriptor;
    }

    public FileOutputStream(String string) throws IOException {
        this(string, false);
    }

    public FileOutputStream(String string, boolean bl) throws IOException {
        System.getSecurityManager().checkWrite(string);
        if (!bl) {
            this.open(string);
        } else {
            this.openAppend(string);
        }
    }

    static {
        System.loadLibrary("io");
    }
}

