/*
 * Decompiled with CFR 0.152.
 */
package kaffe.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.rmi.server.RemoteCall;
import java.util.Vector;
import kaffe.rmi.server.UnicastConnection;
import kaffe.util.NotImplemented;

public class UnicastRemoteCall
implements RemoteCall {
    private UnicastConnection conn;
    private Object result;
    private Object object;
    private int opnum;
    private long hash;
    private Vector vec;
    private int ptr;

    public ObjectOutput getOutputStream() throws IOException {
        this.vec = new Vector();
        UnicastRemoteCall unicastRemoteCall = this;
        if (unicastRemoteCall == null) {
            throw null;
        }
        return unicastRemoteCall.new DummyObjectOutputStream();
    }

    public void releaseOutputStream() throws IOException {
    }

    public ObjectInput getInputStream() throws IOException {
        if (this.conn != null) {
            return this.conn.getObjectInputStream();
        }
        this.ptr = 0;
        UnicastRemoteCall unicastRemoteCall = this;
        if (unicastRemoteCall == null) {
            throw null;
        }
        return unicastRemoteCall.new DummyObjectInputStream();
    }

    public void releaseInputStream() throws IOException {
    }

    public ObjectOutput getResultStream(boolean bl) throws IOException, StreamCorruptedException {
        this.vec = new Vector();
        UnicastRemoteCall unicastRemoteCall = this;
        if (unicastRemoteCall == null) {
            throw null;
        }
        return unicastRemoteCall.new DummyObjectOutputStream();
    }

    public void executeCall() throws Exception {
        throw new NotImplemented();
    }

    public void done() throws IOException {
    }

    Object returnValue() {
        return this.vec.elementAt(0);
    }

    Object[] getArguments() {
        return this.vec.toArray();
    }

    Object getObject() {
        return this.object;
    }

    int getOpnum() {
        return this.opnum;
    }

    long getHash() {
        return this.hash;
    }

    void setReturnValue(Object object) {
        this.vec.removeAllElements();
        this.vec.addElement(object);
    }

    UnicastRemoteCall(UnicastConnection unicastConnection) {
        this.conn = unicastConnection;
    }

    UnicastRemoteCall(Object object, int n, long l) {
        this.object = object;
        this.opnum = n;
        this.hash = l;
    }

    private class DummyObjectOutputStream
    implements ObjectOutput {
        public void writeBoolean(boolean bl) throws IOException {
            UnicastRemoteCall.this.vec.addElement(new Boolean(bl));
        }

        public void writeByte(int n) throws IOException {
            UnicastRemoteCall.this.vec.addElement(new Byte((byte)n));
        }

        public void writeChar(int n) throws IOException {
            UnicastRemoteCall.this.vec.addElement(new Character((char)n));
        }

        public void writeDouble(double d) throws IOException {
            UnicastRemoteCall.this.vec.addElement(new Double(d));
        }

        public void writeFloat(float f) throws IOException {
            UnicastRemoteCall.this.vec.addElement(new Float(f));
        }

        public void writeInt(int n) throws IOException {
            UnicastRemoteCall.this.vec.addElement(new Integer(n));
        }

        public void writeLong(long l) throws IOException {
            UnicastRemoteCall.this.vec.addElement(new Long(l));
        }

        public void writeShort(int n) throws IOException {
            UnicastRemoteCall.this.vec.addElement(new Short((short)n));
        }

        public void writeObject(Object object) throws IOException {
            UnicastRemoteCall.this.vec.addElement(object);
        }

        public void write(byte[] byArray) throws IOException {
            throw new IOException("not required");
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            throw new IOException("not required");
        }

        public void write(int n) throws IOException {
            throw new IOException("not required");
        }

        public void writeBytes(String string) throws IOException {
            throw new IOException("not required");
        }

        public void writeChars(String string) throws IOException {
            throw new IOException("not required");
        }

        public void writeUTF(String string) throws IOException {
            throw new IOException("not required");
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        DummyObjectOutputStream() {
        }
    }

    private class DummyObjectInputStream
    implements ObjectInput {
        public boolean readBoolean() throws IOException {
            Vector vector = UnicastRemoteCall.this.vec;
            UnicastRemoteCall unicastRemoteCall = UnicastRemoteCall.this;
            int n = unicastRemoteCall.ptr;
            unicastRemoteCall.ptr = n + 1;
            Object e = vector.elementAt(n);
            return (Boolean)e;
        }

        public byte readByte() throws IOException {
            Vector vector = UnicastRemoteCall.this.vec;
            UnicastRemoteCall unicastRemoteCall = UnicastRemoteCall.this;
            int n = unicastRemoteCall.ptr;
            unicastRemoteCall.ptr = n + 1;
            Object e = vector.elementAt(n);
            return (Byte)e;
        }

        public char readChar() throws IOException {
            Vector vector = UnicastRemoteCall.this.vec;
            UnicastRemoteCall unicastRemoteCall = UnicastRemoteCall.this;
            int n = unicastRemoteCall.ptr;
            unicastRemoteCall.ptr = n + 1;
            Object e = vector.elementAt(n);
            return ((Character)e).charValue();
        }

        public double readDouble() throws IOException {
            Vector vector = UnicastRemoteCall.this.vec;
            UnicastRemoteCall unicastRemoteCall = UnicastRemoteCall.this;
            int n = unicastRemoteCall.ptr;
            unicastRemoteCall.ptr = n + 1;
            Object e = vector.elementAt(n);
            return (Double)e;
        }

        public float readFloat() throws IOException {
            Vector vector = UnicastRemoteCall.this.vec;
            UnicastRemoteCall unicastRemoteCall = UnicastRemoteCall.this;
            int n = unicastRemoteCall.ptr;
            unicastRemoteCall.ptr = n + 1;
            Object e = vector.elementAt(n);
            return ((Float)e).floatValue();
        }

        public int readInt() throws IOException {
            Vector vector = UnicastRemoteCall.this.vec;
            UnicastRemoteCall unicastRemoteCall = UnicastRemoteCall.this;
            int n = unicastRemoteCall.ptr;
            unicastRemoteCall.ptr = n + 1;
            Object e = vector.elementAt(n);
            return (Integer)e;
        }

        public long readLong() throws IOException {
            Vector vector = UnicastRemoteCall.this.vec;
            UnicastRemoteCall unicastRemoteCall = UnicastRemoteCall.this;
            int n = unicastRemoteCall.ptr;
            unicastRemoteCall.ptr = n + 1;
            Object e = vector.elementAt(n);
            return (Long)e;
        }

        public short readShort() throws IOException {
            Vector vector = UnicastRemoteCall.this.vec;
            UnicastRemoteCall unicastRemoteCall = UnicastRemoteCall.this;
            int n = unicastRemoteCall.ptr;
            unicastRemoteCall.ptr = n + 1;
            Object e = vector.elementAt(n);
            return (Short)e;
        }

        public Object readObject() throws IOException {
            Vector vector = UnicastRemoteCall.this.vec;
            UnicastRemoteCall unicastRemoteCall = UnicastRemoteCall.this;
            int n = unicastRemoteCall.ptr;
            unicastRemoteCall.ptr = n + 1;
            return vector.elementAt(n);
        }

        public int read(byte[] byArray) throws IOException {
            throw new IOException("not required");
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            throw new IOException("not required");
        }

        public int read() throws IOException {
            throw new IOException("not required");
        }

        public long skip(long l) throws IOException {
            throw new IOException("not required");
        }

        public int available() throws IOException {
            throw new IOException("not required");
        }

        public void readFully(byte[] byArray) throws IOException {
            throw new IOException("not required");
        }

        public void readFully(byte[] byArray, int n, int n2) throws IOException {
            throw new IOException("not required");
        }

        public String readLine() throws IOException {
            throw new IOException("not required");
        }

        public String readUTF() throws IOException {
            throw new IOException("not required");
        }

        public int readUnsignedByte() throws IOException {
            throw new IOException("not required");
        }

        public int readUnsignedShort() throws IOException {
            throw new IOException("not required");
        }

        public int skipBytes(int n) throws IOException {
            throw new IOException("not required");
        }

        public void close() throws IOException {
        }

        DummyObjectInputStream() {
        }
    }
}

