/*
** The Sleuth Kit
**
** Brian Carrier [carrier@sleuthkit.org]
** Copyright (c) 2003 Brian Carrier.  All rights reserved
**
*/

#ifndef _BSD_H
#define _BSD_H


typedef struct {
	u_int8_t magic[4];
	u_int8_t type[2];
	u_int8_t sub_type[2];
	u_int8_t type_name[16];

	u_int8_t packname[16];

	u_int8_t sec_size[4];
	u_int8_t sec_per_tr[4];
	u_int8_t tr_per_cyl[4];
	u_int8_t cyl_per_unit[4];
	u_int8_t sec_per_cyl[4];
	u_int8_t sec_per_unit[4];

	u_int8_t spare_per_tr[2];
	u_int8_t spare_per_cyl[2];

	u_int8_t alt_per_unit[4];

	u_int8_t rpm[2];
	u_int8_t interleave[2];
	u_int8_t trackskew[2];
	u_int8_t cylskew[2];
	u_int8_t headswitch[4];
	u_int8_t track_seek[4];
	u_int8_t flags[4];

	u_int8_t drivedata[20];

	u_int8_t reserved1[20];

	u_int8_t magic2[4];
	u_int8_t checksum[2];

	u_int8_t num_parts[2];
	u_int8_t bootarea_size[4];
	u_int8_t sb_size[4];

	struct {
		u_int8_t size_sec[4];
		u_int8_t start_sec[4];
		u_int8_t frag_size[4];
		u_int8_t fstype;
		u_int8_t frag_per_block;
		u_int8_t cyl_per_grp[2];
	} part[16];

	/* padding to make it a full 512 bytes */
	u_int8_t reserved2[108];

} bsd_disklabel;

#define BSD_MAGIC	0x82564557
#define BSD_PART_OFFSET	1

#endif

