/***************************************************************************
                          player.h  -  description
                             -------------------
    begin                : Fri Jan 19 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __PLAYER_H
#define __PLAYER_H

/* this file contains the player struct */

/* control types */
enum {
    HUMAN = 0,
    CPU,
    NOBODY
};

/* cpu strategy types */
enum {
    AGGR = 0, /*aggressive */
    DEF /* defensive */
};

/* diplomatic relations */
enum {
    NEUTRAL = 0,
    ALLIES,
    ENEMIES
};

/* player struct */
typedef struct {
    char *entry_name; /* name to identify this entry */
    char *name; /* real name */
    int cont; /* control */
    int cpu_strat; /* cpu strategy */
    int *dipl; /* diplomacy */
/*  SDL_Surface *flag_pic */
    int air_tran_count; /* number of air transporters */
    int sea_tran_count; /* number of sea transporters */
    Unit_Lib_Entry *def_air_tran; /* default air transporter */
    Unit_Lib_Entry *def_sea_tran; /* default sea transporter */
    int air_tran_used;
    int sea_tran_used;
    /* available delayed units waiting to be deployed */
    Dyn_List avail_reinf;
} Player;

/* create player */
Player *create_player( char *entry_name, char *name, int cont );

/* deletes player struct */
void delete_player( Player *player );

#endif
