/***************************************************************************
                          map.h  -  description
                             -------------------
    begin                : Sat Jan 20 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __MAP_H
#define __MAP_H

// weather types are declared in unit.h //

// fog is cached with this alpha value //
enum { FOG_ALPHA = 128 };

/* map tile flags */
enum {
    INF_ENTR_BONUS = ( 1L << 1 ), /* min entr + 2, max_entr + 4 for infantry */
    NO_SPOTTING    = ( 1L << 3 ), /* you need all spotting points to recon this tile */
    WATER          = ( 1L << 4 ),
    AIRFIELD       = ( 1L << 5 ),
    RIVER          = ( 1L << 6 ), /* you'll need all move points to pass;engineers can build a bridge
    over this tile */
    MOUNTAIN       = ( 1L << 7 ), /* infantry'll need all move points other units can't even pass */
    DIFFICULT      = ( 1L << 8 ), /* diffcult terrain; needs all movepoints to pass */
    HARBOR          = ( 1L << 9 )
};

/* map tile properties */
typedef struct {
    char *entry_name; /* entry name */
    char *name; /* full name */
    char char_id; /* identification, used within the file */
    SDL_Surface *pic;
    SDL_Surface *fogged_pic; /* picture covered with fog */
    int mov; /* movement coast */
    int spot; /* spotting coast */
    int min_entr; /* minmimum entrenchment */
    int max_entr; /* maximum */
    int flags;
} Map_Tile_Prop;

/* icon ids which are used within unit sel frame */
enum {
    MOVE_ICON = 0,
    ATTACK_ICON
};

/* map definitions */
typedef struct {
    int tile_width;
    int tile_height;
    int tile_x_offset;
    int tile_y_offset;
    // tiles and gfx //
    int tile_count;
    SDL_Surface *fog_pic; /* mask used to create fog */
    SDL_Surface *grid_pic; /* contains the grid */
    SDL_Surface *sel_pic; /* selecting frame picture */
    SDL_Surface *cross_pic; /* crosshair picture */
    SDL_Surface *expl_pic; /* explosion */
    SDL_Surface *damage_bar_icons; /* colored life bars */
    Map_Tile_Prop **tiles;
    char weather_names[4][24]; /* weather names */
#ifdef WITH_SOUND
    /* sounds */
    Sound_Chunk *expl_sound;
    Sound_Chunk *select_sound;
#endif
} Map_Def;

/* map tile */
typedef struct {
    char *name; /* name of this map tile */
    Map_Tile_Prop *prop; /* properties */
    int prop_id; /* id in map_def::tiles */
    int pic_offset; /* picture offset in prop->pic */
    int strat_pic_offset; // offset in prop->strat_pic //
    int nation_id; /* nation_id - which nation owns this flag -- nation_id == -1 -> no flag */
    int player_id; /* analouge */
    int obj; /* military objective ? */
    Unit *unit; /* ground/naval unit pointer */
    Unit *air_unit; /* air unit pointer */
} Map_Tile;

/* map mask struct */
enum {
    F_FOG = ( 1L << 1 ),
    F_SPOT = ( 1L << 2 ),
    F_IN_RANGE = ( 1L << 3 ),
    F_MOUNT = ( 1L << 4 ),
    F_SEA_EMBARK = ( 1L << 5 ),
    F_AUX = ( 1L << 6 ),
    F_INFL = ( 1L << 7 ),
    F_AIR_INFL = ( 1L << 8 ),
    F_VIS_INFL = ( 1L << 9 ),
    F_VIS_AIR_INFL = ( 1L << 10 ),
    F_BLOCKED = ( 1L << 11 ),
    F_BACKUP = ( 1L << 12 ),
    F_MELT = ( 1L << 13),
    F_INVERSE_FOG = ( 1L << 14 ), /* inversion of F_FOG */
    F_DEPLOY = ( 1L << 15 )
};
/* contains flags for each map tile mask */
typedef struct {
    int fog; /* true if map tile is covered with fog; if engine::fog_status is OWN_FOG
    this will be adjusted to the spotted flag below; if fog_status is FOREIGN_FOG this mask
    is set at the beginning of the turn (set_player) and kept until next player is set */
    int spot; /* true if any of your units observes this map tile; you can only attack units
    on a map tile that you spot */
    /* used for a selected unit */
    int in_range; /* this is used for pathfinding; it's -1 if tile isn't in range else it's set to the
    remaining moving points of the unit; enemy influence is not included */
    int blocked; /* units can move over there tiles with an allied unit but they must not stop there;
    so allow movment to a tile only if in_range and !blocked */
    int mount; /* true if unit must mount to reach this tile */
    int sea_embark; /* sea embark possible? */
    int infl; /* at the beginning of a player's turn this mask is set; each tile close to a
    hostile unit gets infl increased; if influence is 1 moving costs are doubled; if influence is >=2
    this tile is impassible (unit stops at this tile); if a unit can't see a tile with infl >= 2 and
    tries to move there it will stop on this tile; independed from a unit's moving points passing an
    influenced tile costs all mov-points */
    int vis_infl; /* analogue to infl but only spotted units contribute to this mask; used to setup
    in_range mask */
    int air_infl; /* analouge for flying units */
    int vis_air_infl;
    int aux; /* used to setup any of the upper values */
    int backup; /* used to backup spot mask for undo unit move */
    int merge; /* this mask is set for a specific unit: if true there is a unit on this tile with which
    the unit may merge (either flying or at ground) */
    int deploy; /* deploy mask: 1: unit may deploy their, 0 unit may not deploy their; setup by deploy.c */
} Mask_Tile;

/* map struct */
typedef struct {
    int width, height;
    Map_Def *def;
    Map_Tile **tiles;
    Mask_Tile **mask;
} Map;

int read_map( char *map_name );
void clear_map( );
/* return map tile at x, y */
Map_Tile* map_tile( int x, int y );
Mask_Tile* mask_tile( int x, int y );
/* set all flags specified to their default value */
void clear_mask( int flags );

/* way point struct */
typedef struct {
    int x, y;
} Way_Point;
/* get a list of waypoints along which the unit moves to it's destination (x,y) */
/* get_way_point checks the way for unspotted influence and ambush and cuts it down if needed */
Way_Point* get_way_points( Unit *unit, int x, int y, int *count, Unit **ambush_unit );

/*
====================================================================
Insert, Remove unit pointer from map.
====================================================================
*/
void insert_unit_to_map( Unit *unit );
void remove_unit_from_map( Unit *unit );

#endif
