/***************************************************************************
                          window.c  -  description
                             -------------------
    begin                : Sun Jan 28 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <SDL.h>

#ifdef WITH_SOUND
#include <SDL_mixer.h>
#include "audio.h"
#endif

#include <stdlib.h>
#include <stdio.h>

#include "sdl.h"
#include "dynlist.h"
#include "tools.h"
#include "gui.h"

extern Sdl sdl;

#define WINDOW_DEBUG

/* oh no! someone called for a hack??? shit I'm too lazy to implement this properly
this sound pointer MUST be set before any window is created if this window is supposed
to have sound. right now this sound is created in main.c */
#ifdef WITH_SOUND
Sound_Chunk *click_sound = 0;
Sound_Chunk *edit_sound = 0;
#endif

/* forwarded declarations */
/* adjust track button position from scrollbar */
void adjust_track_button( Window *window, int ref );
/* set track button pos (and adjust position index)*/
void set_track_button_pos( Window *window, int new_pos, int ref );

/* create parent window */
Window* create_parent_window( SDL_Surface *pic )
{
    Window *window = 0;

    /* get&clear memory */
    window = malloc( sizeof( Window ) );
    memset( window, 0, sizeof( Window ) );
    window->active = 1;
    window->id = ID_NONE;
    window->flags = 0;

    /* initiate children list */
    dl_init( &window->chil, AUTO_DELETE, delete_window );

    /* set type */
    window->type = PARENT_WINDOW;

    /* picture */
    window->pic = pic;

    /* background */
    window->back_pic = create_surf( window->pic->w, window->pic->h, SDL_SWSURFACE );
    SDL_SetColorKey( window->back_pic, 0, 0 );

    /* position ( always centered ) */
    window->x = ( sdl.screen->w - window->pic->w ) / 2;
    window->y = ( sdl.screen->h - window->pic->h ) / 2;
    /* size */
    window->width = window->pic->w;
    window->height = window->pic->h;

    return window;
}

/* create wallpapered parent window; add a frame if frame_pic != 0 */
Window *create_wallpaper_window( SDL_Surface *pic, SDL_Surface *frame_pic, int width, int height )
{
    int i, j;
    int tile_width, tile_height; /* frame tile size */

    Window *window = 0;

    /* get&clear memory */
    window = malloc( sizeof( Window ) );
    memset( window, 0, sizeof( Window ) );
    window->active = 1;
    window->id = ID_NONE;
    window->flags = CLEAR_PIC;

    /* initiate children list */
    dl_init( &window->chil, AUTO_DELETE, delete_window );

    /* set type */
    window->type = PARENT_WINDOW;

    /* picture */
    window->pic = create_surf( width, height, SDL_SWSURFACE );
	if ( pic )
		for ( i = 0; i < width; i += pic->w )
			for ( j = 0; j < height; j += pic->h ) {
	
				DEST( window->pic, i, j, pic->w, pic->h );
				SOURCE( pic, 0, 0 );
				blit_surf();
	
			}
    /* frame */
    if ( frame_pic ) {
        /* frame tile size */
        tile_width = tile_height = frame_pic->w / 3;
        /* add horizontal top/bottom line */
        for ( i = tile_width; i < width - tile_width; i += tile_width ) {

            /* upper line */
            DEST( window->pic, i, 0, tile_width, tile_height );
            SOURCE( frame_pic, tile_width, 0 ); /* upper middle part */
            blit_surf();
            /* lower line */
            DEST( window->pic, i, window->pic->h - tile_height, tile_width, tile_height );
            SOURCE( frame_pic, tile_width, tile_height * 2 ); /* lower middle part */
            blit_surf();

        }
        /* add vertical lines */
        for ( i = tile_height; i < height - tile_height; i += tile_height ) {

            /* upper line */
            DEST( window->pic, 0, i, tile_width, tile_height );
            SOURCE( frame_pic, 0, tile_height ); /* left middle part */
            blit_surf();
            /* lower line */
            DEST( window->pic, window->pic->w - tile_width, i, tile_width, tile_height );
            SOURCE( frame_pic, tile_width * 2, tile_height ); /* right middle part */
            blit_surf();

        }
        /* add corners */
        /* left upper */
        DEST( window->pic, 0, 0, tile_width, tile_height );
        SOURCE( frame_pic, 0, 0 );
        blit_surf();
        /* right upper */
        DEST( window->pic, window->pic->w - tile_width, 0, tile_width, tile_height );
        SOURCE( frame_pic, frame_pic->w - tile_width, 0 );
        blit_surf();
        /* left lower */
        DEST( window->pic, 0, window->pic->h - tile_height, tile_width, tile_height );
        SOURCE( frame_pic, 0, frame_pic->h - tile_height );
        blit_surf();
        /* right lower */
        DEST( window->pic, window->pic->w - tile_width, window->pic->h - tile_height, tile_width, tile_height );
        SOURCE( frame_pic, frame_pic->w - tile_width, frame_pic->h - tile_height );
        blit_surf();
    }
    			
    /* background */
    window->back_pic = create_surf( window->pic->w, window->pic->h, SDL_SWSURFACE );
    SDL_SetColorKey( window->back_pic, 0, 0 );

    /* position ( always centered ) */
    window->x = ( sdl.screen->w - window->pic->w ) / 2;
    window->y = ( sdl.screen->h - window->pic->h ) / 2;
    /* size */
    window->width = window->pic->w;
    window->height = window->pic->h;

    return window;
}

/* create transparent window with frame */
Window *create_trans_window( SDL_Surface *frame_pic, int width, int height )
{
    int i;
    int tile_width, tile_height; /* frame tile size */

    Window *window = 0;

    /* get&clear memory */
    window = malloc( sizeof( Window ) );
    memset( window, 0, sizeof( Window ) );
    window->active = 1;
    window->id = ID_NONE;
    window->flags = CLEAR_PIC;

    /* initiate children list */
    dl_init( &window->chil, AUTO_DELETE, delete_window );

    /* set type */
    window->type = PARENT_WINDOW;

    /* picture */
    window->pic = create_surf( width, height, SDL_SWSURFACE );
    /* fill with black and add surrounding frame */
    FULL_DEST( window->pic ); fill_surf( 0x0 );
    SDL_SetColorKey( window->pic, 0, 0 ); /* no color key */
    /* frame tile size */
    tile_width = tile_height = frame_pic->w / 3;
    /* add horizontal top/bottom line */
    for ( i = tile_width; i < width - tile_width; i += tile_width ) {

        /* upper line */
        DEST( window->pic, i, 0, tile_width, tile_height );
        SOURCE( frame_pic, tile_width, 0 ); /* upper middle part */
        blit_surf();
        /* lower line */
        DEST( window->pic, i, window->pic->h - tile_height, tile_width, tile_height );
        SOURCE( frame_pic, tile_width, tile_height * 2 ); /* lower middle part */
        blit_surf();

    }
    /* add vertical lines */
    for ( i = tile_height; i < height - tile_height; i += tile_height ) {

        /* upper line */
        DEST( window->pic, 0, i, tile_width, tile_height );
        SOURCE( frame_pic, 0, tile_height ); /* left middle part */
        blit_surf();
        /* lower line */
        DEST( window->pic, window->pic->w - tile_width, i, tile_width, tile_height );
        SOURCE( frame_pic, tile_width * 2, tile_height ); /* right middle part */
        blit_surf();

    }
    /* add corners */
    /* left upper */
    DEST( window->pic, 0, 0, tile_width, tile_height );
    SOURCE( frame_pic, 0, 0 );
    blit_surf();
    /* right upper */
    DEST( window->pic, window->pic->w - tile_width, 0, tile_width, tile_height );
    SOURCE( frame_pic, frame_pic->w - tile_width, 0 );
    blit_surf();
    /* left lower */
    DEST( window->pic, 0, window->pic->h - tile_height, tile_width, tile_height );
    SOURCE( frame_pic, 0, frame_pic->h - tile_height );
    blit_surf();
    /* right lower */
    DEST( window->pic, window->pic->w - tile_width, window->pic->h - tile_height, tile_width, tile_height );
    SOURCE( frame_pic, frame_pic->w - tile_width, frame_pic->h - tile_height );
    blit_surf();

    /* show window picture transparent */
    window->trans = 1;
    window->frame_size = tile_width;

    /* background */
    window->back_pic = create_surf( window->pic->w, window->pic->h, SDL_SWSURFACE );
    SDL_SetColorKey( window->back_pic, 0, 0 );

    /* position ( always centered ) */
    window->x = ( sdl.screen->w - window->pic->w ) / 2;
    window->y = ( sdl.screen->h - window->pic->h ) / 2;
    /* size */
    window->width = window->pic->w;
    window->height = window->pic->h;

    return window;
}

/* create button window ( and add to parent automatically )*/
Window* create_button( Window *parent, int id, SDL_Surface *pic, int x, int y, int width, int height,char *text, Window *label )
{
    Window *window = 0;

    /* get&clear memory */
    window = malloc( sizeof( Window ) );
    memset( window, 0, sizeof( Window ) );
    window->parent = parent;
    window->active = 1;
    window->id = id;
    window->flags = IGNORE_CHIL;

    /* initiate children list */
    dl_init( &window->chil, AUTO_DELETE, delete_window );

    /* set type */
    window->type = BUTTON;

    /* picture */
    window->pic = pic;

    /* position */
    window->rel_x = x;
    window->rel_y = y;
    if ( parent ) {

        window->x = window->rel_x + parent->x;
        window->y = window->rel_y + parent->y;

    }
    /* size */
    window->width = width;
    window->height = height;

    /* simple text: just one line */
    window->text = create_text( text, 0 );

    /* background */
    window->back_pic = create_surf( window->width, window->height, SDL_SWSURFACE );
    SDL_SetColorKey( window->back_pic, 0, 0 );

    /* add label */
    if ( label ) {

        set_simple_window_text( label, "", NO_REFRESH );
        dl_add( &window->chil, label );

    }

    /* add to parent */
    if ( parent )
        dl_add( &parent->chil, window );

#ifdef WITH_SOUND
    /* add sound */
    window->click_sound = click_sound;
#endif

    return window;
}

/* create switch button  ( and add to parent automatically )*/
Window* create_switch( Window *parent, int id, SDL_Surface *pic,
                       int x, int y, int width, int height,char *text, Window *label,
                       int is_on )
{
    Window *button = create_button( parent, id, pic, x, y, width, height, text, label );
    button->is_switch = 1;
    button->is_on = is_on;
    return button;
}

/* create simple button window ( and add to parent automatically )*/
Window* create_simple_button( Window *parent, int id, SDL_Surface *pic, int x, int y, int width, int height )
{
    Window *window = 0;

    /* get&clear memory */
    window = malloc( sizeof( Window ) );
    memset( window, 0, sizeof( Window ) );
    window->active = 1;
    window->parent = parent;
    window->id = id;
    window->flags = IGNORE_CHIL;

    /* initiate children list */
    dl_init( &window->chil, AUTO_DELETE, delete_window );

    /* set type */
    window->type = BUTTON;

    /* picture */
    window->pic = pic;

    /* position */
    window->rel_x = x;
    window->rel_y = y;
    if ( parent ) {
        window->x = window->rel_x + parent->x;
        window->y = window->rel_y + parent->y;
    }
    /* size */
    window->width = width;
    window->height = height;

    /* background */
    window->back_pic = create_surf( window->width, window->height, SDL_SWSURFACE );
    SDL_SetColorKey( window->back_pic, 0, 0 );

    /* add to parent */
    if ( parent )
        dl_add( &parent->chil, window );

#ifdef WITH_SOUND
    /* add sound */
    window->click_sound = click_sound;
#endif

    return window;
}

/* create text button window ( and add to parent automatically )*/
Window* create_text_button( Window *parent, int id, SDL_Surface *pic, int x, int y, int width, int height, Font *font, char *text )
{
    Window *window = 0;
    int tile_width = 0;
    int tile_count = 0;
    int i;

    /* get&clear memory */
    window = malloc( sizeof( Window ) );
    memset( window, 0, sizeof( Window ) );
    window->parent = parent;
    window->active = 1;
    window->id = id;
    window->font = font;
    window->flags = IGNORE_CHIL | CLEAR_PIC;

    /* initiate children list */
    dl_init( &window->chil, AUTO_DELETE, delete_window );

    /* set type */
    window->type = TEXT_BUTTON;

    /* text */
    window->text = create_text( text, 0 );
    window->align = ALIGN_X_CENTER | ALIGN_Y_CENTER;

    /* picture */
    /* each picture consists of three vertical graphics like BUTTON but in addition
    of three horizontal parts ( each of the same size ) where the middle part is copied multiple times
    to fit the wanted length at minimum ( resulting button might be a bit longer ) */
    /* first of all the wanted width will be width; if it's zero the wanted length will be
    text_width + 10 */
    if ( width == 0 )
        width = text_width( window->font, window->text->lines[0] ) + 20;
    /* next is what size is the middle part and how many tiles do we need to get the wanted length */
    tile_width = pic->w / 3;
    tile_count = width / tile_width;
    if ( tile_count * tile_width < width ) tile_count++;
    if ( tile_count < 2 ) tile_count = 2;
    /* adjust length */
    width = tile_count * tile_width;
    /* now allocate memory */
    window->pic = create_surf( width, pic->h, SDL_SWSURFACE );
    /* copy left end */
    DEST( window->pic, 0, 0, tile_width, pic->h );
    SOURCE( pic, 0, 0 );
    blit_surf();
    /* copy middle parts */
    for ( i = 0; i < tile_count - 2; i++ ) {

        DEST( window->pic, ( i + 1 ) * tile_width, 0, tile_width, pic->h );
        SOURCE( pic,  tile_width, 0 );
        blit_surf();

    }
    /* copy right end */
    DEST( window->pic, window->pic->w - tile_width, 0, tile_width, pic->h );
    SOURCE( pic, pic->w - tile_width, 0 );
    blit_surf();

    /* position */
    window->rel_x = x;
    window->rel_y = y;
    if ( parent ) {

        window->x = window->rel_x + parent->x;
        window->y = window->rel_y + parent->y;

    }
    /* size */
    window->width = width;
    window->height = height;

    /* background */
    window->back_pic = create_surf( window->width, window->height, SDL_SWSURFACE );
    SDL_SetColorKey( window->back_pic, 0, 0 );

    /* add to parent */
    if ( parent )
        dl_add( &parent->chil, window );

#ifdef WITH_SOUND
    /* add sound */
    window->click_sound = click_sound;
#endif

    return window;
}

/* create label window ( and add to parent automatically )*/
Window* create_label( Window *parent, int id, int x, int y, int width, int height, Font *font, int align, char *text )
{
    Window *window = 0;

    /* get&clear memory */
    window = malloc( sizeof( Window ) );
    memset( window, 0, sizeof( Window ) );
    window->parent = parent;
    window->active = 1;
    window->id = id;
    window->font = font;
    window->align = align;

    /* initiate children list */
    dl_init( &window->chil, AUTO_DELETE, delete_window );

    /* set type */
    window->type = LABEL;

    /* picture */
    window->pic = 0;

    /* position */
    window->rel_x = x;
    window->rel_y = y;
    if ( parent ) {

        window->x = window->rel_x + parent->x;
        window->y = window->rel_y + parent->y;

    }
    /* size */
    window->width = width;
    window->height = height;

    /* text */
    window->text = create_text( text, 0 );

    /* background */
    window->back_pic = create_surf( window->width, window->height, SDL_SWSURFACE );
    SDL_SetColorKey( window->back_pic, 0, 0 );

    /* add to parent */
    if ( parent )
        dl_add( &parent->chil, window );

    return window;
}

/* create edit window ( and add to parent automatically )*/
Window* create_edit( Window *parent, int id, SDL_Surface *pic, int x, int y, int width, int height, int border, Font *font, char *text, int max, int flags )
{
    Window *window = 0;
    int i, tile_count, tile_width, tile_size = 0;
    SDL_Surface *frame_pic = 0;

    /* get&clear memory */
    window = malloc( sizeof( Window ) );
    memset( window, 0, sizeof( Window ) );
    window->parent = parent;
    window->active = 1;
    window->id = id;
    window->font = font;
    window->flags = CLEAR_PIC | flags;
    window->border = border;
    window->max = max;

    /* initiate children list */
    dl_init( &window->chil, AUTO_DELETE, delete_window );

    /* set type */
    window->type = EDIT;

    /* if TRANS_EDIT is set add a frame and set window->trans */
    if ( flags & TRANS_EDIT ) {

        frame_pic = pic;
        window->pic = create_surf( width, height, SDL_SWSURFACE );
        /* fill with black and add surrounding frame */
        FULL_DEST( window->pic ); fill_surf( 0x0 );
        SDL_SetColorKey( window->pic, 0, 0 ); /* no color key */
        /* if frame pic == 0 leave away the frame */
        if ( frame_pic != 0 ) {
            /* frame tile size */
            tile_size = tile_size = frame_pic->w / 3;
            /* add horizontal top/bottom line */
            for ( i = tile_size; i < width - tile_size; i += tile_size ) {

                /* upper line */
                DEST( window->pic, i, 0, tile_size, tile_size );
                SOURCE( frame_pic, tile_size, 0 ); /* upper middle part */
                blit_surf();
                /* lower line */
                DEST( window->pic, i, window->pic->h - tile_size, tile_size, tile_size );
                SOURCE( frame_pic, tile_size, tile_size * 2 ); /* lower middle part */
                blit_surf();

            }
            /* add vertical lines */
            for ( i = tile_size; i < height - tile_size; i += tile_size ) {

                /* upper line */
                DEST( window->pic, 0, i, tile_size, tile_size );
                SOURCE( frame_pic, 0, tile_size ); /* left middle part */
                blit_surf();
                /* lower line */
                DEST( window->pic, window->pic->w - tile_size, i, tile_size, tile_size );
                SOURCE( frame_pic, tile_size * 2, tile_size ); /* right middle part */
                blit_surf();

            }
            /* add corners */
            /* left upper */
            DEST( window->pic, 0, 0, tile_size, tile_size );
            SOURCE( frame_pic, 0, 0 );
            blit_surf();
            /* right upper */
            DEST( window->pic, window->pic->w - tile_size, 0, tile_size, tile_size );
            SOURCE( frame_pic, frame_pic->w - tile_size, 0 );
            blit_surf();
            /* left lower */
            DEST( window->pic, 0, window->pic->h - tile_size, tile_size, tile_size );
            SOURCE( frame_pic, 0, frame_pic->h - tile_size );
            blit_surf();
            /* right lower */
            DEST( window->pic, window->pic->w - tile_size, window->pic->h - tile_size, tile_size, tile_size );
            SOURCE( frame_pic, frame_pic->w - tile_size, frame_pic->h - tile_size );
            blit_surf();
        }

        /* show window picture transparent */
        window->trans = 1;
        window->frame_size = tile_size;

    }
    else
    if ( pic == 0 ) {
        /* copy from parent */
        window->pic = create_surf( width, height, SDL_SWSURFACE );
        FULL_DEST( window->pic );
        SOURCE( window->parent->pic, x, y );
        blit_surf();
    }
    else {
        /* picture */
        /* each picture consists of three horizontal parts ( each of the same size ) where the middle
        part is copied multiple times to fit the wanted length at minimum ( resulting button might be a
        bit longer ) */
        /* first what size is the middle part and how many tiles do we need to get the wanted length */
        tile_width = pic->w / 3;
        tile_count = ( width / tile_width );
        if ( tile_count * tile_width < width ) tile_count++;
        if ( tile_count < 2 ) tile_count = 2;
        /* adjust length */
        width = tile_count * tile_width;
        /* now allocate memory */
        window->pic = create_surf( width, pic->h, SDL_SWSURFACE );
        /* copy left end */
        DEST( window->pic, 0, 0, tile_width, pic->h );
        SOURCE( pic, 0, 0 );
        blit_surf();
        /* copy middle parts */
        for ( i = 0; i < tile_count - 2; i++ ) {

            DEST( window->pic, ( i + 1 ) * tile_width, 0, tile_width, pic->h );
            SOURCE( pic,  tile_width, 0 );
            blit_surf();

        }
        /* copy right end */
        DEST( window->pic, window->pic->w - tile_width, 0, tile_width, pic->h );
        SOURCE( pic, pic->w - tile_width, 0 );
        blit_surf();
    }

    /* position */
    window->rel_x = x;
    window->rel_y = y;
    if ( parent ) {

        window->x = window->rel_x + parent->x;
        window->y = window->rel_y + parent->y;

    }
    /* size */
    window->width = width;
    window->height = height;

    /* text */
    window->text = create_text( text, 0 );
    window->pos = strlen( text );

    /* background */
    window->back_pic = create_surf( window->width, window->height, SDL_SWSURFACE );
    SDL_SetColorKey( window->back_pic, 0, 0 );

    /* add to parent */
    if ( parent )
        dl_add( &parent->chil, window );

#ifdef WITH_SOUND
    /* add sound */
    window->edit_sound = edit_sound;
    window->click_sound = click_sound;
#endif

    return window;
}

/* create scrollbar window ( and add to parent automatically )*/
Window* create_scroll( Window *parent, int id, SDL_Surface *pic, int x, int y, int width, int height,
                       int dir, SDL_Surface *inc_pic, SDL_Surface *dec_pic, SDL_Surface *pos_pic,
                       int min, int max, int step, int pos )
{
    Window *window = 0;
    int i, tile_width, tile_count;
    /* actual size of up/down buttons together */
    int total_button_size;
    /* offset of actual scrollbar */
    int scroll_offset;

    /* get&clear memory */
    window = malloc( sizeof( Window ) );
    memset( window, 0, sizeof( Window ) );
    window->parent = parent;
    window->active = 1;
    window->id = id;
    window->flags = CLEAR_PIC;
    window->min = min;
    window->max = max;
    window->pos = pos;
    window->step = step;

    /* initiate children list */
    dl_init( &window->chil, AUTO_DELETE, delete_window );

    /* set type */
    window->type = SCROLL;
    window->dir = dir;

    /* button size */
    /* buttons are the same size as the scrollbar's width (VERT) or height (HORI) */
    if ( dir == VERT )
        window->button_size = width;
    else
        window->button_size = height;

    /* get scroll bar width */
    total_button_size = 0;
    scroll_offset = 0;
    if ( dec_pic != 0 && inc_pic != 0 ) {
        total_button_size = 2 * window->button_size;
        scroll_offset = window->button_size;
    }

    /* picture */
    /* if pic == 0 back_pic or parent is used when updating */
    if ( pic == 0 ) {
        window->pic = 0;
/*      window->pic = create_surf( width, height, SDL_SWSURFACE );
        FULL_DEST( window->pic );
        SOURCE( window->parent->pic, x, y );
        blit_surf();*/
    }
    else
    /* only for horizontal scrollbars right now */
    /* each picture consists of three horizontal parts ( each of the same size ) where the middle
    part is copied multiple times to fit the wanted length at minimum ( resulting button might be a
    bit longer ) */
    /* first what size is the middle part and how many tiles do we need to get the wanted length */
    if ( dir == HORI ) {

        tile_width = pic->w / 3;
        tile_count = ( ( width - total_button_size ) / tile_width );
        if ( tile_count * tile_width < ( width - total_button_size ) )
            tile_count++;
        if ( tile_count < 2 ) tile_count = 2;
        /* adjust length */
        width = tile_count * tile_width + total_button_size;
        /* now allocate memory */
        window->pic = create_surf( width, pic->h, SDL_SWSURFACE );
        /* copy left end */
        DEST( window->pic, scroll_offset, 0, tile_width, pic->h );
        SOURCE( pic, 0, 0 );
        blit_surf();
        /* copy middle parts */
        for ( i = 0; i < tile_count - 2; i++ ) {

            DEST( window->pic, scroll_offset + ( i + 1 ) * tile_width, 0, tile_width, pic->h );
            SOURCE( pic,  tile_width, 0 );
            blit_surf();

        }
        /* copy right end */
        DEST( window->pic, window->pic->w - tile_width - scroll_offset, 0, tile_width, pic->h );
        SOURCE( pic, pic->w - tile_width, 0 );
        blit_surf();

    }
    else {

        tile_width = pic->h / 3;
        tile_count = ( ( height - total_button_size ) / tile_width );
        if ( tile_count * tile_width < ( height - total_button_size) )
            tile_count++;
        if ( tile_count < 2 ) tile_count = 2;
        /* adjust length */
        height = tile_count * tile_width + total_button_size;
        /* now allocate memory */
        window->pic = create_surf( pic->w, height, SDL_SWSURFACE );
        /* copy left end */
        DEST( window->pic, 0, scroll_offset, pic->w, tile_width );
        SOURCE( pic, 0, 0 );
        blit_surf();
        /* copy middle parts */
        for ( i = 0; i < tile_count - 2; i++ ) {

            DEST( window->pic, 0, scroll_offset + ( i + 1 ) * tile_width, pic->w, tile_width );
            SOURCE( pic, 0, tile_width );
            blit_surf();

        }
        /* copy right end */
        DEST( window->pic, 0, window->pic->h - tile_width - scroll_offset, pic->w, tile_width );
        SOURCE( pic, 0, pic->h - tile_width );
        blit_surf();

    }

    /* position */
    window->rel_x = x;
    window->rel_y = y;
    if ( parent ) {

        window->x = window->rel_x + parent->x;
        window->y = window->rel_y + parent->y;

    }
    /* size */
    window->width = width;
    window->height = height;

    /* add children buttons */
    /* scrollbar does only have up/down children if the passed picture is not 0 */
    if ( dec_pic != 0 )
        create_simple_button( window, ID_DEC, dec_pic, 0, 0, window->button_size, window->button_size );
    if ( dir == HORI ) {
        if ( inc_pic != 0 )
            create_simple_button( window, ID_INC, inc_pic, window->width - window->button_size, 0,
                                  window->button_size, window->button_size );
        create_simple_button( window, ID_TRACK, pos_pic, window->button_size, 0,
                              window->button_size, window->button_size );
    }
    else {
        if ( inc_pic != 0 )
            create_simple_button( window, ID_INC, inc_pic, 0, window->height - window->button_size,
                                  window->button_size, window->button_size );
        create_simple_button( window, ID_TRACK, pos_pic, 0, window->button_size,
                              window->button_size, window->button_size );
    }

    /* background */
    window->back_pic = create_surf( window->width, window->height, SDL_SWSURFACE );
    SDL_SetColorKey( window->back_pic, 0, 0 );

    /* add to parent */
    if ( parent )
        dl_add( &parent->chil, window );

    return window;
}

/* create listbox window */
Window* create_list( Window *parent, int id, SDL_Surface *pic, int x, int y, int width, int height,
                     int border, Font *font, Text *text, int flags, int back_color,
                     SDL_Surface *scroll_pic,
                     SDL_Surface *inc_pic, SDL_Surface *dec_pic, SDL_Surface *pos_pic,
                     int scroll_size )
{
    Window *window = 0;
    int i, j, hori_tile_count, vert_tile_count, tile_size = 0;
    int label_count, label_height, label_width;
    int y_offset;
    SDL_Surface *frame_pic = 0;

    /* get&clear memory */
    window = malloc( sizeof( Window ) );
    memset( window, 0, sizeof( Window ) );
    window->parent = parent;
    window->active = 1;
    window->font = font;
    window->id = id;
    window->flags = CLEAR_PIC | flags;
    window->border = border;
    window->pos = 0;
    window->back_color = back_color;
    window->has_scroll = 1;

    /* initiate children list */
    dl_init( &window->chil, AUTO_DELETE, delete_window );

    /* set type */
    window->type = LIST;

    /* if TRANS_LIST is set add a frame and set window->trans */
    if ( flags & TRANS_LIST ) {

        frame_pic = pic;
        window->pic = create_surf( width, height, SDL_SWSURFACE );
        /* fill with black and add surrounding frame */
        FULL_DEST( window->pic ); fill_surf( 0x0 );
        SDL_SetColorKey( window->pic, 0, 0 ); /* no color key */
        /* if frame pic == 0 leave away the frame */
        if ( frame_pic != 0 ) {
            /* frame tile size */
            tile_size = tile_size = frame_pic->w / 3;
            /* add horizontal top/bottom line */
            for ( i = tile_size; i < width - tile_size; i += tile_size ) {

                /* upper line */
                DEST( window->pic, i, 0, tile_size, tile_size );
                SOURCE( frame_pic, tile_size, 0 ); /* upper middle part */
                blit_surf();
                /* lower line */
                DEST( window->pic, i, window->pic->h - tile_size, tile_size, tile_size );
                SOURCE( frame_pic, tile_size, tile_size * 2 ); /* lower middle part */
                blit_surf();

            }
            /* add vertical lines */
            for ( i = tile_size; i < height - tile_size; i += tile_size ) {

                /* upper line */
                DEST( window->pic, 0, i, tile_size, tile_size );
                SOURCE( frame_pic, 0, tile_size ); /* left middle part */
                blit_surf();
                /* lower line */
                DEST( window->pic, window->pic->w - tile_size, i, tile_size, tile_size );
                SOURCE( frame_pic, tile_size * 2, tile_size ); /* right middle part */
                blit_surf();

            }
            /* add corners */
            /* left upper */
            DEST( window->pic, 0, 0, tile_size, tile_size );
            SOURCE( frame_pic, 0, 0 );
            blit_surf();
            /* right upper */
            DEST( window->pic, window->pic->w - tile_size, 0, tile_size, tile_size );
            SOURCE( frame_pic, frame_pic->w - tile_size, 0 );
            blit_surf();
            /* left lower */
            DEST( window->pic, 0, window->pic->h - tile_size, tile_size, tile_size );
            SOURCE( frame_pic, 0, frame_pic->h - tile_size );
            blit_surf();
            /* right lower */
            DEST( window->pic, window->pic->w - tile_size, window->pic->h - tile_size, tile_size, tile_size );
            SOURCE( frame_pic, frame_pic->w - tile_size, frame_pic->h - tile_size );
            blit_surf();
        }

        /* show window picture transparent */
        window->trans = 1;
        window->frame_size = tile_size;

    }
    else
    if ( pic == 0 ) {
        /* copy from parent */
        window->pic = create_surf( width, height, SDL_SWSURFACE );
        FULL_DEST( window->pic );
        SOURCE( window->parent->pic, x, y );
        blit_surf();
    }
    else {
        /* picture -- assembled from parts in pic */
        /* width,height will be automatically changed to fit the wanted result */
        tile_size = pic->w / 3;
        hori_tile_count = ( width - scroll_size ) / tile_size;
        if ( hori_tile_count * tile_size < width - scroll_size ) hori_tile_count++;
        if ( hori_tile_count < 3 ) hori_tile_count = 3;
        vert_tile_count = height / tile_size;
        if ( vert_tile_count * tile_size < height ) vert_tile_count++;
        if ( vert_tile_count < 3 ) vert_tile_count = 3;
        width = hori_tile_count * tile_size + scroll_size;
        height = vert_tile_count * tile_size;
        /* get mem */
        window->pic = create_surf( width, height, SDL_SWSURFACE );
        /* fill pic */
        /* left upper corner */
        DEST( window->pic, 0, 0, tile_size, tile_size );
        SOURCE( pic, 0, 0);
        blit_surf();
        /* right upper corner */
        DEST( window->pic, window->pic->w - tile_size - scroll_size, 0, tile_size, tile_size );
        SOURCE( pic, tile_size + tile_size, 0);
        blit_surf();
        /* left lower corner */
        DEST( window->pic, 0, window->pic->h - tile_size, tile_size, tile_size );
        SOURCE( pic, 0, tile_size + tile_size );
        blit_surf();
        /* right lower corner */
        DEST( window->pic, window->pic->w - tile_size - scroll_size, window->pic->h - tile_size, tile_size, tile_size );
        SOURCE( pic, tile_size + tile_size, tile_size + tile_size );
        blit_surf();
        /* upper/lower middle parts */
        for ( i = 0; i < hori_tile_count - 2; i++ ) {

            /* upper part */
            DEST( window->pic, tile_size + i * tile_size, 0, tile_size, tile_size );
            SOURCE( pic, tile_size, 0 );
            blit_surf();
            /* lower part */
            DEST( window->pic, tile_size + i * tile_size, window->pic->h - tile_size, tile_size, tile_size );
            SOURCE( pic, tile_size, tile_size + tile_size );
            blit_surf();

        }
        /* left/right middle parts */
        for ( i = 0; i < vert_tile_count - 2; i++ ) {

            /* left part */
            DEST( window->pic, 0, tile_size + i * tile_size, tile_size, tile_size );
            SOURCE( pic, 0, tile_size );
            blit_surf();
            /* right part */
            DEST( window->pic, window->pic->w - tile_size - scroll_size, tile_size + i * tile_size, tile_size, tile_size );
            SOURCE( pic, tile_size + tile_size, tile_size );
            blit_surf();

        }
        /* tiles within */
        for ( i = 0; i < hori_tile_count - 2; i++ )
            for ( j = 0; j < vert_tile_count - 2; j++ ) {

                DEST( window->pic, tile_size + i * tile_size, tile_size + j * tile_size, tile_size, tile_size );
                SOURCE( pic, tile_size, tile_size );
                blit_surf();

            }
    }

    /* position */
    window->rel_x = x;
    window->rel_y = y;
    if ( parent ) {

        window->x = window->rel_x + parent->x;
        window->y = window->rel_y + parent->y;

    }
    /* size */
    window->width = width;
    window->height = height;

    /* background */
    window->back_pic = create_surf( window->width, window->height, SDL_SWSURFACE );
    SDL_SetColorKey( window->back_pic, 0, 0 );

    /* get lines; THIS WINDOW IS RESPONSIBLE FOR FREEING MEMORY LATER!!! */
    window->text = text;
    if ( window->text && window->text->count > 0 )
            window->line_sel = calloc( window->text->count, sizeof( int ) );

    /* create as many labels as possible and center their position */
    label_width = width - 2 * border - scroll_size;
    label_height = font->height;
    label_count = ( height - border * 2 ) / label_height;
    window->step = label_count;
    y_offset = ( height - label_count * label_height ) / 2;
    for ( i = 0; i < label_count; i++ )
        create_label( window, ID_LIST_LABEL + i, border, y_offset + i * label_height, label_width,
                      label_height, font, ALIGN_X_LEFT | ALIGN_Y_TOP, "" );
    /* this character limit is used for all labels to check that they aren't too long */
    window->char_limit = label_width / font->char_width[0];

    /* scrollbar */
    if ( window->text )
        window->max = window->text->count - window->step;
    else
        window->max = 0;
    if ( window->max < 0 ) window->max = 0;
    create_scroll( window, ID_LIST_SCROLL, scroll_pic, window->pic->w - scroll_size, 0, scroll_size,
                   height, VERT, inc_pic, dec_pic, pos_pic, 0, window->max, window->step - 1, 0 );
    /* window_step - 1 so you can see the last line from page above .. */

    /* add to parent */
    if ( parent )
        dl_add( &parent->chil, window );

#ifdef WITH_SOUND
    /* add sound */
    window->click_sound = click_sound;
#endif

    return window;
}

/* create listbox window */
Window* create_simple_list( Window *parent, int id, SDL_Surface *pic, int x, int y, int width, int height,
                     int border, Font *font, Text *text, int flags, int back_color )
{
    Window *window = 0;
    int i, j, hori_tile_count, vert_tile_count, tile_size = 0;
    int label_count, label_height, label_width;
    int y_offset;
    SDL_Surface *frame_pic = 0;

    /* get&clear memory */
    window = malloc( sizeof( Window ) );
    memset( window, 0, sizeof( Window ) );
    window->parent = parent;
    window->active = 1;
    window->font = font;
    window->id = id;
    window->flags = CLEAR_PIC | flags;
    window->border = border;
    window->pos = 0;
    window->back_color = back_color;

    /* initiate children list */
    dl_init( &window->chil, AUTO_DELETE, delete_window );

    /* set type */
    window->type = LIST;

    /* if TRANS_LIST is set add a frame and set window->trans */
    if ( flags & TRANS_LIST ) {

        frame_pic = pic;
        window->pic = create_surf( width, height, SDL_SWSURFACE );
        /* fill with black and add surrounding frame */
        FULL_DEST( window->pic ); fill_surf( 0x0 );
        SDL_SetColorKey( window->pic, 0, 0 ); /* no color key */
        /* if frame pic == 0 leave away the frame */
        if ( frame_pic != 0 ) {
            /* frame tile size */
            tile_size = tile_size = frame_pic->w / 3;
            /* add horizontal top/bottom line */
            for ( i = tile_size; i < width - tile_size; i += tile_size ) {

                /* upper line */
                DEST( window->pic, i, 0, tile_size, tile_size );
                SOURCE( frame_pic, tile_size, 0 ); /* upper middle part */
                blit_surf();
                /* lower line */
                DEST( window->pic, i, window->pic->h - tile_size, tile_size, tile_size );
                SOURCE( frame_pic, tile_size, tile_size * 2 ); /* lower middle part */
                blit_surf();

            }
            /* add vertical lines */
            for ( i = tile_size; i < height - tile_size; i += tile_size ) {

                /* upper line */
                DEST( window->pic, 0, i, tile_size, tile_size );
                SOURCE( frame_pic, 0, tile_size ); /* left middle part */
                blit_surf();
                /* lower line */
                DEST( window->pic, window->pic->w - tile_size, i, tile_size, tile_size );
                SOURCE( frame_pic, tile_size * 2, tile_size ); /* right middle part */
                blit_surf();

            }
            /* add corners */
            /* left upper */
            DEST( window->pic, 0, 0, tile_size, tile_size );
            SOURCE( frame_pic, 0, 0 );
            blit_surf();
            /* right upper */
            DEST( window->pic, window->pic->w - tile_size, 0, tile_size, tile_size );
            SOURCE( frame_pic, frame_pic->w - tile_size, 0 );
            blit_surf();
            /* left lower */
            DEST( window->pic, 0, window->pic->h - tile_size, tile_size, tile_size );
            SOURCE( frame_pic, 0, frame_pic->h - tile_size );
            blit_surf();
            /* right lower */
            DEST( window->pic, window->pic->w - tile_size, window->pic->h - tile_size, tile_size, tile_size );
            SOURCE( frame_pic, frame_pic->w - tile_size, frame_pic->h - tile_size );
            blit_surf();
        }

        /* show window picture transparent */
        window->trans = 1;
        window->frame_size = tile_size;

    }
    else
    if ( pic == 0 ) {
        /* copy from parent */
        window->pic = create_surf( width, height, SDL_SWSURFACE );
        FULL_DEST( window->pic );
        SOURCE( window->parent->pic, x, y );
        blit_surf();
    }
    else {
        /* picture -- assembled from parts in pic */
        /* width,height will be automatically changed to fit the wanted result */
        tile_size = pic->w / 3;
        hori_tile_count = width / tile_size;
        if ( hori_tile_count * tile_size < width ) hori_tile_count++;
        if ( hori_tile_count < 3 ) hori_tile_count = 3;
        vert_tile_count = height / tile_size;
        if ( vert_tile_count * tile_size < height ) vert_tile_count++;
        if ( vert_tile_count < 3 ) vert_tile_count = 3;
        width = hori_tile_count * tile_size;
        height = vert_tile_count * tile_size;
        /* get mem */
        window->pic = create_surf( width, height, SDL_SWSURFACE );
        /* fill pic */
        /* left upper corner */
        DEST( window->pic, 0, 0, tile_size, tile_size );
        SOURCE( pic, 0, 0);
        blit_surf();
        /* right upper corner */
        DEST( window->pic, window->pic->w - tile_size, 0, tile_size, tile_size );
        SOURCE( pic, tile_size + tile_size, 0);
        blit_surf();
        /* left lower corner */
        DEST( window->pic, 0, window->pic->h - tile_size, tile_size, tile_size );
        SOURCE( pic, 0, tile_size + tile_size );
        blit_surf();
        /* right lower corner */
        DEST( window->pic, window->pic->w - tile_size, window->pic->h - tile_size, tile_size, tile_size );
        SOURCE( pic, tile_size + tile_size, tile_size + tile_size );
        blit_surf();
        /* upper/lower middle parts */
        for ( i = 0; i < hori_tile_count - 2; i++ ) {

            /* upper part */
            DEST( window->pic, tile_size + i * tile_size, 0, tile_size, tile_size );
            SOURCE( pic, tile_size, 0 );
            blit_surf();
            /* lower part */
            DEST( window->pic, tile_size + i * tile_size, window->pic->h - tile_size, tile_size, tile_size );
            SOURCE( pic, tile_size, tile_size + tile_size );
            blit_surf();

        }
        /* left/right middle parts */
        for ( i = 0; i < vert_tile_count - 2; i++ ) {

            /* left part */
            DEST( window->pic, 0, tile_size + i * tile_size, tile_size, tile_size );
            SOURCE( pic, 0, tile_size );
            blit_surf();
            /* right part */
            DEST( window->pic, window->pic->w - tile_size, tile_size + i * tile_size, tile_size, tile_size );
            SOURCE( pic, tile_size + tile_size, tile_size );
            blit_surf();

        }
        /* tiles within */
        for ( i = 0; i < hori_tile_count - 2; i++ )
            for ( j = 0; j < vert_tile_count - 2; j++ ) {

                DEST( window->pic, tile_size + i * tile_size, tile_size + j * tile_size, tile_size, tile_size );
                SOURCE( pic, tile_size, tile_size );
                blit_surf();

            }
    }

    /* position */
    window->rel_x = x;
    window->rel_y = y;
    if ( parent ) {

        window->x = window->rel_x + parent->x;
        window->y = window->rel_y + parent->y;

    }
    /* size */
    window->width = width;
    window->height = height;

    /* background */
    window->back_pic = create_surf( window->width, window->height, SDL_SWSURFACE );
    SDL_SetColorKey( window->back_pic, 0, 0 );

    /* get lines; THIS WINDOW IS RESPONSIBLE FOR FREEING MEMORY LATER!!! */
    window->text = text;
    if ( window->text && window->text->count > 0 )
        window->line_sel = calloc( window->text->count, sizeof( int ) );

    /* create as many labels as possible and center their position */
    label_width = width - 2 * border;
    label_height = font->height;
    label_count = ( height - border * 2 ) / label_height;
    window->step = label_count;
    y_offset = ( height - label_count * label_height ) / 2;
    for ( i = 0; i < label_count; i++ )
        create_label( window, ID_LIST_LABEL + i, border, y_offset + i * label_height, label_width,
                      label_height, font, ALIGN_X_LEFT | ALIGN_Y_TOP, "" );
    /* this character limit is used for all labels to check that they aren't too long */
    window->char_limit = label_width / font->char_width[0];

    /* add to parent */
    if ( parent )
        dl_add( &parent->chil, window );

#ifdef WITH_SOUND
    /* add sound */
    window->click_sound = click_sound;
#endif

    return window;
}

/* create icon window ( and add to parent automatically )*/
Window* create_icon( Window *parent, int id, int x, int y, int width, int height, SDL_Surface *icon,
                     int icon_x, int icon_y, int icon_width, int icon_height )
{
    Window *window = 0;

    /* get&clear memory */
    window = malloc( sizeof( Window ) );
    memset( window, 0, sizeof( Window ) );
    window->parent = parent;
    window->active = 1;
    window->id = id;

    /* initiate children list */
    dl_init( &window->chil, AUTO_DELETE, delete_window );

    /* set type */
    window->type = ICON;

    /* picture --- icon is a part of another picture which will be displayed centered */
    window->pic = icon;
    window->icon_x = icon_x;
    window->icon_y = icon_y;
    window->icon_width = icon_width;
    window->icon_height = icon_height;

    /* position */
    window->rel_x = x;
    window->rel_y = y;
    if ( parent ) {

        window->x = window->rel_x + parent->x;
        window->y = window->rel_y + parent->y;

    }
    /* size */
    window->width = width;
    window->height = height;

    /* background */
    window->back_pic = create_surf( window->width, window->height, SDL_SWSURFACE );
    SDL_SetColorKey( window->back_pic, 0, 0 );

    /* add to parent */
    if ( parent )
        dl_add( &parent->chil, window );

    return window;
}

/* create icon with frame */
Window* create_frame_icon( Window *parent, int id, SDL_Surface *frame_pic, int x, int y, int width, int height,
                           SDL_Surface *icon,
                           int icon_x, int icon_y, int icon_width, int icon_height )
{
    Window *window = 0;
    int tile_size;
    int i;

    /* get&clear memory */
    window = malloc( sizeof( Window ) );
    memset( window, 0, sizeof( Window ) );
    window->parent = parent;
    window->active = 1;
    window->id = id;
    window->flags = CLEAR_PIC;

    /* initiate children list */
    dl_init( &window->chil, AUTO_DELETE, delete_window );

    /* set type */
    window->type = FRAME_ICON;

    /* picture is created with frame and black contents */
    /* the additional icon is kept in window::add_icon */
    window->pic = create_surf( width, height, SDL_SWSURFACE );
    /* fill with black and add surrounding frame */
    FULL_DEST( window->pic ); fill_surf( 0x0 );
    /* if frame pic == 0 leave away the frame */
    if ( frame_pic != 0 ) {
        /* frame tile size */
        tile_size = tile_size = frame_pic->w / 3;
        /* add horizontal top/bottom line */
        for ( i = tile_size; i < width - tile_size; i += tile_size ) {

            /* upper line */
            DEST( window->pic, i, 0, tile_size, tile_size );
            SOURCE( frame_pic, tile_size, 0 ); /* upper middle part */
            blit_surf();
            /* lower line */
            DEST( window->pic, i, window->pic->h - tile_size, tile_size, tile_size );
            SOURCE( frame_pic, tile_size, tile_size * 2 ); /* lower middle part */
            blit_surf();

        }
        /* add vertical lines */
        for ( i = tile_size; i < height - tile_size; i += tile_size ) {

            /* upper line */
            DEST( window->pic, 0, i, tile_size, tile_size );
            SOURCE( frame_pic, 0, tile_size ); /* left middle part */
            blit_surf();
            /* lower line */
            DEST( window->pic, window->pic->w - tile_size, i, tile_size, tile_size );
            SOURCE( frame_pic, tile_size * 2, tile_size ); /* right middle part */
            blit_surf();

        }
        /* add corners */
        /* left upper */
        DEST( window->pic, 0, 0, tile_size, tile_size );
        SOURCE( frame_pic, 0, 0 );
        blit_surf();
        /* right upper */
        DEST( window->pic, window->pic->w - tile_size, 0, tile_size, tile_size );
        SOURCE( frame_pic, frame_pic->w - tile_size, 0 );
        blit_surf();
        /* left lower */
        DEST( window->pic, 0, window->pic->h - tile_size, tile_size, tile_size );
        SOURCE( frame_pic, 0, frame_pic->h - tile_size );
        blit_surf();
        /* right lower */
        DEST( window->pic, window->pic->w - tile_size, window->pic->h - tile_size, tile_size, tile_size );
        SOURCE( frame_pic, frame_pic->w - tile_size, frame_pic->h - tile_size );
        blit_surf();

        window->frame_size = tile_size;
    }

    /* icon */
    window->add_icon = icon;
    window->icon_x = icon_x;
    window->icon_y = icon_y;
    window->icon_width = icon_width;
    window->icon_height = icon_height;

    /* position */
    window->rel_x = x;
    window->rel_y = y;
    if ( parent ) {
        window->x = window->rel_x + parent->x;
        window->y = window->rel_y + parent->y;
    }
    /* size */
    window->width = width;
    window->height = height;

    /* background */
    window->back_pic = create_surf( window->width, window->height, SDL_SWSURFACE );
    SDL_SetColorKey( window->back_pic, 0, 0 );

    /* add to parent */
    if ( parent )
        dl_add( &parent->chil, window );

#ifdef WITH_SOUND
    /* add sound */
    window->click_sound = click_sound;
#endif

    return window;
}

/* delete window -- compatible with dyn list */
void delete_window( void *poi )
{
    Window *window = (Window*)poi;

    if ( window == 0 ) return;

    /* solved a bit better this way :) */
    if ( !( window->flags & IGNORE_CHIL ) )
        dl_clear( &window->chil );

    if ( window->flags & CLEAR_PIC )
        if ( window->pic ) SDL_FreeSurface( window->pic );
    if ( window->back_pic ) SDL_FreeSurface( window->back_pic );
    if ( window->text ) delete_text( window->text );
    if ( window->line_sel ) free( window->line_sel );

    free ( window );
}

/* open window */
void open_window( Window *window, int type )
{
    int i;

    /* save background from screen */
    FULL_DEST( window->back_pic );
    SOURCE( sdl.screen, window->x, window->y );
    blit_surf();

    /* show without children .. */
    update_window( window, ALL | IGNORE_CHIL | NO_SCREEN_REF );

    /* ... cause they need their background as well */
    window->chil.cur_entry = &window->chil.head;
    for ( i = 0; i < window->chil.count; i++ )
        open_window( (Window*)dl_next_entry( &window->chil )->data, NO_REFRESH );

    /* refresh when finished */
    if ( type == REFRESH )
        if ( window->parent == 0 )
            refresh_rects();
}

/*close window */
void close_window( Window *window )
{
    /* restore background */
    DEST( sdl.screen, window->x, window->y, window->width, window->height );
    SOURCE( window->back_pic, 0, 0 );
    blit_surf();

    refresh_screen( window->x, window->y, window->width, window->height );
}

/* hide window */
void hide_window( Window *window, int ref )
{
    /* restore background */
    DEST( sdl.screen, window->x, window->y, window->width, window->height );
    SOURCE( window->back_pic, 0, 0 );
    blit_surf();
    if ( ref )
        add_refresh_rect( window->x, window->y, window->width, window->height );
}

/* move window to position and get new background */
void move_window( Window *window, int x, int y, int ref )
{
    /* set position */
    window->x = x;
    window->y = y;
    if ( ref == REFRESH ) {
        /* must be already hidden to get new background */
        DEST( window->back_pic, 0, 0, window->width, window->height );
        SOURCE( sdl.screen, window->x, window->y );
        blit_surf();
        /* set refresh flag */
        if ( ref )
            window->ref = ref;
    }
}

/* handle window events */
void handle_window_event( Window *window, SDL_Event *event, Window **used_child )
{
    int i, old_focus, old_pos;
    char c;
    char *edit_str;
    int edit_length;

    /* clear used_child if very first call */
    if ( window->parent == 0 ) *used_child = 0;

    if ( !window->active ) return;

    /* optimize the recursive tree a bit */
    if ( event->type == SDL_KEYDOWN ) return;

    /* first go down to the children */
    window->chil.cur_entry = &window->chil.head;
    for ( i = 0; i < window->chil.count; i++ )
        handle_window_event( (Window*)dl_next_entry( &window->chil )->data, event, used_child );

    /* then handle event */
    switch ( event->type ) {

        case SDL_KEYUP:
            switch ( window->type ) {

                case EDIT:
                    if ( window->focus ) {

                        /* as text is allocated dynamically we must reallocate memory when editing! */

                        c = event->key.keysym.unicode;
                        if ( c >= 32 && window->pos < window->max ) {

                            /* size of old string + new char + termination */
                            edit_length = strlen( window->text->lines[0] ) + 1 + 1;
                            edit_str = calloc( edit_length, sizeof( char ) );
                            strcpy( edit_str, window->text->lines[0] );
                            edit_str[edit_length - 2] = c;
                            edit_str[edit_length - 1] = 0;
                            /* assign */
                            free( window->text->lines[0] );
                            window->text->lines[0] = edit_str;
                            window->pos++;
                            /* refresh */
                            window->ref = 1;

                        }
                        else
                            if ( c == SDLK_BACKSPACE && window->pos > 0 ) {

                                window->text->lines[0][--window->pos] = 0;
                                window->ref = 1;

                            }
                            else
                                if ( c == SDLK_RETURN && *used_child == 0 )
                                    *used_child = window;
#ifdef WITH_SOUND
                        if ( window->edit_sound )
                            sound_play( window->edit_sound );
#endif

                    }
                    break;

            }
            break;

        case SDL_MOUSEBUTTONDOWN:
            switch ( window->type ) {

                case LABEL:
                    if ( on_window( window, event->button.x, event->button.y ) )
                        window->sel = 1;
                    break;

                case TEXT_BUTTON:
                case BUTTON:
                    if ( on_window( window, event->button.x, event->button.y ) ) {

                        window->sel = 1;
                        window->ref = 1;
#ifdef WITH_SOUND
                        if ( window->click_sound )
                            sound_play( window->click_sound );
#endif

                    }
                    break;

                case EDIT:
                    if ( on_window( window, event->button.x, event->button.y ) )
                        window->sel = 1;
                    break;

                case FRAME_ICON:
                    if ( on_window( window, event->button.x, event->button.y ) )
                        if ( event->button.button == LEFT_BUTTON ) {
                            window->sel = 1;
#ifdef WITH_SOUND
                            if ( window->click_sound )
                                sound_play( window->click_sound );
#endif
                        }
                    break;
            }
            break;

        case SDL_MOUSEBUTTONUP:
            switch ( window->type ) {

                case FRAME_ICON:
                    /* one icon in a group of frame_icons is always selected so only check if selection
                    was made, too externly unselect old frame_icon */
                    if ( on_window( window, event->button.x, event->button.y ) && window->sel )
                        if ( event->button.button == LEFT_BUTTON )
                            if ( *used_child == 0 ) {
                                *used_child = window;
                                window->ref = 1;
                                window->is_on = 1;
                            }
                    /* check if wheel buttons where pressed */
                    /* link with an scrollbar window::list_scroll after creating frame_icons to use
                    this part */
                    if ( window->list_scroll )
                    if ( on_window( window, event->button.x, event->button.y ) )
                        if ( event->button.button == WHEEL_UP || event->button.button == WHEEL_DOWN ) {
                            /* handle this like scrollbar was used */
                            *used_child = window->list_scroll;
                            /* now update scrollbar::pos; the change is checked by our extern function */
                            if ( (*used_child)->max - (*used_child)->min > 0 ) {
                                if ( event->button.button == WHEEL_UP )
                                    if ( (*used_child)->pos > (*used_child)->min )
                                        (*used_child)->pos--;
                                if ( event->button.button == WHEEL_DOWN )
                                    if ( (*used_child)->pos < (*used_child)->max )
                                        (*used_child)->pos++;
                                /* adjust track button */
                                adjust_track_button( *used_child, REFRESH );
                            }
                            else
                                *used_child = 0;
                        }
                    break;

                case LABEL:
                    if ( window->sel ) {
                        window->sel = 0;
                        /* only interesting if parent is listbox */
                        if ( window->parent && window->parent->type == LIST && *used_child == 0 &&
                             on_window( window, event->button.x, event->button.y ) )
                            *used_child = window;
                    }
                    break;

                case TEXT_BUTTON:
                case BUTTON:
                    if ( window->sel ) {
                        window->sel = 0;
                        window->ref = 1;
                        if ( window->is_switch )
                            window->is_on = !window->is_on;
                    }
                    if ( on_window( window, event->button.x, event->button.y ) && *used_child == 0 ) {
                        *used_child = window;
                    }
                    break;

                case EDIT:
                    if ( on_window( window, event->button.x, event->button.y ) && window->sel )
                        window->focus = 1;
                    else
                        window->focus = 0;
                    break;

                case SCROLL:
                    if ( event->button.button != LEFT_BUTTON ) break;
                    /* check scrollbar action (id set by children) */
                    if ( *used_child && (*used_child)->id == ID_DEC && (*used_child)->parent == window ) {
                        if ( window->pos > window->min ) {
                            window->pos--;
                            adjust_track_button( window, REFRESH );
                        }
                        *used_child = window; /* which scrollbar did it? */
                        break;
                    }
                    else
                        if ( *used_child && (*used_child)->id == ID_INC && (*used_child)->parent == window ) {
                            if ( window->pos < window->max ) {
                                window->pos++;
                                adjust_track_button( window, REFRESH );
                            }
                            *used_child = window; /* which scrollbar did it? */
                            break;
                        }
                        else
                            if ( *used_child && (*used_child)->id == ID_TRACK && (*used_child)->parent == window )
                                break;
                    /* check if scrollbar has been directly clicked */
                    if ( window->max == 0 ) break; /* scrollbar not used */
                    if ( on_window( window, event->button.x, event->button.y ) ) {
                        if ( window->dir == HORI ) {
                            /* horizontal */
                            if ( event->button.x < get_child( window, ID_TRACK)->x ) {
                                window->pos -= window->step;
                                if ( window->pos < window->min )
                                    window->pos = window->min;
                                adjust_track_button( window, REFRESH );
                            }
                            else {
                                window->pos += window->step;
                                if ( window->pos > window->max )
                                    window->pos = window->max;
                                adjust_track_button( window, REFRESH );
                            }
                        }
                        else {
                            /* vertical */
                            if ( event->button.y < get_child( window, ID_TRACK)->y ) {
                                window->pos -= window->step;
                                if ( window->pos < window->min )
                                    window->pos = window->min;
                                adjust_track_button( window, REFRESH );
                            }
                            else {
                                window->pos += window->step;
                                if ( window->pos > window->max )
                                    window->pos = window->max;
                                adjust_track_button( window, REFRESH );
                            }
                        }
                        *used_child = window;
                        /* update focus of track button */
                        if ( on_window( get_child( window, ID_TRACK ), event->button.x, event->button.y ) )
                            get_child( window, ID_TRACK )->focus = 1;
                    }
                    break;

                case LIST:
                    /* check possible selection */
                    if ( event->button.button == LEFT_BUTTON )
                    if ( window->text )
                    if ( window->line_sel )
                    if ( !( window->flags & NO_SELECT ) )
                    if ( *used_child )
                    if ( (*used_child)->id >= ID_LIST_LABEL )
                    if ( (*used_child)->id < ID_LIST_LABEL + window->step ) {
                        i = (*used_child)->id - ID_LIST_LABEL + window->pos;
                        if ( i < window->text->count ) {
                            if ( !window->line_sel[i] ) {
                                if ( window->flags & SINGLE_SELECT )
                                     window->line_sel[window->cur_line_sel] = 0;
                                window->line_sel[i] = 1;
                                window->cur_line_sel = i;
                                if ( window->flags & SINGLE_SELECT )
                                    window->sel_lines_count = 1;
                                else
                                    window->sel_lines_count++;
                            }
                            else {
                                window->line_sel[i] = 0;
                                window->sel_lines_count--;
                            }
                            window->ref = 1;
                            *used_child = window; /* return used lstbox */
#ifdef WITH_SOUND
                            if ( window->click_sound )
                                sound_play( window->click_sound );
#endif
                            break;
                        }
                    }
                    /* check if wheel buttons where pressed */
                    if ( on_window( window, event->button.x, event->button.y ) )
                        if ( event->button.button == WHEEL_UP || event->button.button == WHEEL_DOWN ) {
                            /* handle this like scrollbar was used */
                            *used_child = get_child( window, ID_LIST_SCROLL );
                            /* now update scrollbar::pos which will update list in the next step below */
                            if ( (*used_child)->max - (*used_child)->min > 0 ) {
                                if ( event->button.button == WHEEL_UP )
                                    if ( (*used_child)->pos > (*used_child)->min )
                                        (*used_child)->pos--;
                                if ( event->button.button == WHEEL_DOWN )
                                    if ( (*used_child)->pos < (*used_child)->max )
                                        (*used_child)->pos++;
                                /* adjust track button */
                                adjust_track_button( *used_child, REFRESH );
                            }
                            else
                                *used_child = 0;
                        }
                    /* check changed position */
                    if ( window->text )
                        if ( window->text->count <= window->step ) break; /* nothing to check */
                    if ( *used_child )
                        if ( (*used_child)->id == ID_LIST_SCROLL )
                            if ( (*used_child)->parent == window ) {
                                 old_pos = window->pos;
                                 window->pos = get_child( window, ID_LIST_SCROLL )->pos;
                                 if ( old_pos != window->pos )
                                    window->ref = 1;
                                 *used_child = window;
                            }
                    break;

            }
            break;

        case SDL_MOUSEMOTION:
            switch ( window->type ) {

                case TEXT_BUTTON:
                case BUTTON:
                    /* check focus change and refresh if changed */
                    old_focus = window->focus;
                    if ( on_window( window, event->button.x, event->button.y ) )
                        window->focus = 1;
                    else
                        window->focus = 0;
                    if ( old_focus != window->focus ) {

                        if ( window->chil.count > 0 ) {

                            if ( window->focus )
                                set_simple_window_text( (Window*)window->chil.head.next->data, window->text->lines[0], REFRESH );
                            else
                                set_simple_window_text( (Window*)window->chil.head.next->data, "", REFRESH );
                        }
                        if ( window->sel ) /* only if selected the graphics change */
                            window->ref = 1;

                    }
                    if ( window->focus && window->sel && window->id == ID_TRACK && *used_child == 0 )
                        *used_child = window;
                    break;

                case SCROLL:
                    if ( event->motion.state != LEFT_BUTTON ) break;
                    /* scrollbar tracking? id set by children ... */
                    if ( *used_child && (*used_child)->id == ID_TRACK && (*used_child)->parent == window ) {
                        if ( window->dir == HORI )
                            set_track_button_pos( window, event->motion.x - window->button_size / 2,
                                                  REFRESH );
                        else
                            set_track_button_pos( window, event->motion.y - window->button_size / 2,
                                                  REFRESH );
                        *used_child = window;
                    }
                    break;

                case LIST:
                    if ( *used_child && (*used_child)->id == ID_LIST_SCROLL && (*used_child)->parent == window ) {
                        old_pos = window->pos;
                        window->pos = get_child( window, ID_LIST_SCROLL )->pos;
                        if ( old_pos != window->pos )
                            window->ref = 1;
                        *used_child = ID_NONE; /* does not provoke an action */
                    }
                    break;

            }
            break;

    }

}

/* update the changed parts of a window and
refresh all changed rects in the end if NO_SCREEN_REF is not set */
void update_window( Window *window, int flags )
{
    int i, text_x, text_y;

    /* check type and refresh */
    if ( window->ref || ( flags & ALL ) ) {

        window->ref = 0;

        switch ( window->type ) {

            case PARENT_WINDOW:
                DEST( sdl.screen, window->x, window->y, window->width, window->height );
                SOURCE( window->pic, 0, 0 );
                blit_surf();
                add_refresh_rect( window->x, window->y, window->width, window->height );
                /* if window is transparent copy the background opqaue leaving the frame untouched */
                /* copy transparent background */
                if ( window->trans ) {

                    DEST( sdl.screen,
                          window->x + window->frame_size, window->y + window->frame_size,
                          window->width - ( window->frame_size << 1 ),
                          window->height - ( window->frame_size << 1 ) );
                    SOURCE( window->back_pic, window->frame_size, window->frame_size );
                    alpha_blit_surf( 128 );

                }
                flags = flags | ALL;
                break;

            case BUTTON:
                if ( window->pic ) {
                    /* graphic */
                    DEST( sdl.screen, window->x, window->y, window->width, window->height );
                    /* if button's a switch: on: active icon off: deactivated icon */
                    if ( !window->active || ( window->is_switch && !window->is_on && !window->sel ) )
                        SOURCE( window->pic, 0, window->height * 2 )
                    else
                        if ( window->sel && window->focus )
                            SOURCE( window->pic, 0, window->height )
                        else
                            SOURCE( window->pic, 0, 0 );
                    blit_surf();
                    add_refresh_rect( window->x, window->y, window->width, window->height );
                }
                break;

            case TEXT_BUTTON:
                DEST( sdl.screen, window->x, window->y, window->width, window->height );
                /* copy parents background in case some pixels are transparent in this button */
                SOURCE( window->parent->pic, window->rel_x, window->rel_y );
                blit_surf();
                /* button graphic */
                if ( !window->active )
                    SOURCE( window->pic, 0, window->height * 2 )
                else
                    if ( window->sel && window->focus )
                        SOURCE( window->pic, 0, window->height )
                    else
                        SOURCE( window->pic, 0, 0 );
                blit_surf();
                /* write text */
                window->font->align = window->align;
                if ( window->align & ALIGN_X_CENTER )
                    text_x = window->x + window->width / 2;
                else
                    text_x = window->x + 10;
                text_y =  window->y + window->height / 2;
                if ( window->sel && window->focus ) {
                    text_x++;
                    text_y++;
                }
                if ( window->active )
                    write_text( window->font, sdl.screen, text_x, text_y, window->text->lines[0], OPAQUE );
                else
                    write_text( window->font, sdl.screen, text_x, text_y, window->text->lines[0], 64 );
                add_refresh_rect( window->x, window->y, window->width, window->height );
                break;

            case LABEL:
                /* background */
                DEST( sdl.screen, window->x, window->y, window->width, window->height );
                SOURCE( window->back_pic, 0, 0 );
                blit_surf();
                if ( window->back_color ) {

                    /* background color is only used for listbox-labels! */
                    DEST( sdl.screen, window->x, window->y + 1, window->width, window->height - 1);
                    fill_surf( window->back_color );
                    window->back_color = 0; /* and therefore reset after each use */

                }

                /* if a char_limit is set check that string doesn't exceed this limit if parent
                   is a listbox */
                if ( window->parent->type == LIST )
                    if ( window->parent->char_limit )
                        if ( window->text && window->text->lines )
                            if ( strlen( window->text->lines[0] ) > window->parent->char_limit )
                                window->text->lines[0][window->parent->char_limit] = 0;

                /* write text  ... */
                window->font->align = window->align;
                if ( window->align & ALIGN_X_CENTER )
                    text_x = window->x + ( window->width >> 1 );
                else
                    if ( window->align & ALIGN_X_RIGHT )
                        text_x = window->x + window->width;
                    else
                        text_x = window->x;
                if ( window->align & ALIGN_Y_CENTER )
                    text_y = window->y + ( window->height >> 1 );
                else
                    if ( window->align & ALIGN_Y_BOTTOM )
                        text_y = window->y + window->height;
                    else
                        text_y = window->y;
                write_text( window->font, sdl.screen, text_x, text_y, window->text->lines[0], OPAQUE );
                add_refresh_rect( window->x, window->y, window->width, window->height );
                break;

            case EDIT:
                /* picture */
                DEST( sdl.screen, window->x, window->y, window->width, window->height );
                SOURCE( window->pic, 0, 0 );
                blit_surf();
                /* if window is transparent copy the background opqaue leaving the frame untouched */
                /* copy PARENT's transparent background */
                if ( window->trans ) {

                    DEST( sdl.screen,
                          window->x + window->frame_size, window->y + window->frame_size,
                          window->width - ( window->frame_size << 1 ),
                          window->height - ( window->frame_size << 1 ) );
                    SOURCE( window->parent->back_pic,
                            window->frame_size + window->rel_x,
                            window->frame_size + window->rel_y );
                    alpha_blit_surf( 128 );

                }
                /* text */
                window->font->align = ALIGN_X_LEFT | ALIGN_Y_CENTER;
                write_text( window->font, sdl.screen, window->x + window->border,
                            window->y + ( window->height / 2 ), window->text->lines[0], OPAQUE );
                add_refresh_rect( window->x, window->y, window->width, window->height );
                break;

            case SCROLL:
                /* picture */
                DEST( sdl.screen, window->x, window->y, window->width, window->height );
                if ( window->pic )
                    SOURCE( window->pic, 0, 0 )
                else
                    if ( window->parent->pic )
                        SOURCE( window->parent->pic, window->rel_x, window->rel_y )
                    else
                        SOURCE( window->parent->back_pic, window->rel_x, window->rel_y )
                blit_surf();
                add_refresh_rect( window->x, window->y, window->width, window->height );
                /* force children to refresh */
                flags = flags | ALL;
                break;

            case LIST:
                /* picture */
                DEST( sdl.screen, window->x, window->y, window->width, window->height );
                SOURCE( window->pic, 0, 0 );
                blit_surf();
                add_refresh_rect( window->x, window->y, window->width, window->height );
                /* if window is transparent copy the background opqaue leaving the frame untouched */
                /* copy PARENT's transparent background */
                if ( window->trans ) {

                    DEST( sdl.screen,
                          window->x + window->frame_size, window->y + window->frame_size,
                          window->width - ( window->frame_size << 1 ),
                          window->height - ( window->frame_size << 1 ) );
                    SOURCE( window->parent->back_pic,
                            window->frame_size + window->rel_x,
                            window->frame_size + window->rel_y );
                    alpha_blit_surf( 128 );

                }
                /* set label text */
                if ( window->text )
                    for ( i = 0; i < window->step; i++ )
                        if ( window->pos + i < window->text->count ) {
                            set_simple_window_text( get_child( window, ID_LIST_LABEL + i ),
                                             window->text->lines[window->pos + i], REFRESH );
                            if ( window->line_sel[window->pos + i] )
                                get_child( window, ID_LIST_LABEL + i )->back_color = window->back_color;
                        }
                /* force children to refresh */
                flags = flags | ALL;
                break;

            case ICON:
                /* background */
                DEST( sdl.screen, window->x, window->y, window->width, window->height );
                SOURCE( window->back_pic, 0, 0 );
                blit_surf();
                add_refresh_rect( window->x, window->y, window->width, window->height );
                /* show icon (if existing)*/
                if ( window->pic ) {

                    DEST( sdl.screen, window->x + ( window->width - window->icon_width) / 2,
                          window->y + ( window->height - window->icon_height) / 2,
                          window->icon_width, window->icon_height );
                    SOURCE( window->pic, window->icon_x, window->icon_y );
                    blit_surf();

                }
                break;

            case FRAME_ICON:
                /* background */
                DEST( sdl.screen, window->x, window->y, window->width, window->height );
                SOURCE( window->back_pic, 0, 0 );
                blit_surf();
                /* if selection fill with white else black*/
                DEST( window->pic, window->frame_size, window->frame_size,
                      window->width - 2 * window->frame_size, window->height - 2 * window->frame_size );
                if ( window->is_on )
                    fill_surf( 0xffffff );
                else
                    fill_surf( 0x0 );
                /* picture (frame)*/
                DEST( sdl.screen, window->x, window->y, window->width, window->height );
                SOURCE( window->pic, 0, 0 );
                if ( window->is_on )
                    alpha_blit_surf( 128 );
                else
                    blit_surf();
                /* refresh */
                add_refresh_rect( window->x, window->y, window->width, window->height );
                /* show icon (if existing)*/
                if ( window->add_icon ) {
                    DEST( sdl.screen, window->x + ( window->width - window->icon_width) / 2,
                          window->y + ( window->height - window->icon_height) / 2,
                          window->icon_width, window->icon_height );
                    SOURCE( window->add_icon, window->icon_x, window->icon_y );
                    blit_surf();
                }
                break;

        }

    }

    /* refresh children */
    if ( !( flags & IGNORE_CHIL ) ) {

        window->chil.cur_entry = &window->chil.head;
        for ( i = 0; i < window->chil.count; i++ )
            update_window( (Window*)dl_next_entry( &window->chil )->data, flags );

    }

    /* refresh when finished ( current window has no parent ) and NO_SCREEN_REF is not set */
    if ( window->parent == 0 && !( flags & NO_SCREEN_REF ) )
        refresh_rects();
}

/* check if on window */
inline int on_window( Window *window, int x, int y)
{
    return ( x >= window->x && y >= window->y && x < window->x + window->width &&
             y < window->y + window->height );

}

/* set just a single line of text */
void set_simple_window_text( Window *window, char *str, int ref )
{
    if ( window == 0 ) return;
    if ( str == 0 ) return;
    if ( window->text ) delete_text( window->text );
    window->text = create_text( str, 0 );
    /* update position if it's an edit */
    if ( window->type == EDIT ) window->pos = strlen( str );
    if ( ref ) window->ref = ref;
}
/* set text */
void set_window_text( Window *window, Text *text, int ref )
{
    int i;

    /* clear old mem */
    if ( window->text ) delete_text( window->text ); window->text = 0;
    if ( window->line_sel != 0 ) {
        free( window->line_sel );
        window->line_sel = 0;
    }

    /* if this is a list all children labels must be cleared as well */
    if ( window->type == LIST )
        for ( i = 0; i < window->step; i++ )
            set_simple_window_text( get_child( window, ID_LIST_LABEL + i ), "", NO_REFRESH );

    /* set new text */
    window->text = text;
    if ( window->text )
        if ( window->text->count )
            window->line_sel = calloc( window->text->count, sizeof( int ) );

    /* reset selection */
    window->sel_lines_count = 0;
    window->cur_line_sel = 0;

    /* update scrollbar range if it's a listbox with scrollbar */
    if ( window->has_scroll ) {
        if ( window->text )
            window->max = window->text->count - window->step;
        else
            window->max = 0;
        if ( window->max < 0 ) window->max = 0;
        window->pos = 0;
        set_scroll_range( get_child( window, ID_LIST_SCROLL ), 0,
                          window->max, window->step -1, window->pos,
                          ref );
    }

    if ( ref )
        window->ref = ref;
}

/* set icon */
void set_icon( Window *window, SDL_Surface *pic, int x, int y, int width, int height, int ref)
{
    if ( window->type != ICON && window->type != FRAME_ICON ) return;
    window->icon_x = x;
    window->icon_y = y;
    window->icon_width = width;
    window->icon_height = height;

    if ( window->type == ICON )
        window->pic = pic;
    else
        window->add_icon = pic;

    if ( ref )
        window->ref = ref;
}

/* return window pointer from parent and id */
Window* get_child( Window *parent, int id )
{
    int i;
    Window *window;

    parent->chil.cur_entry = &parent->chil.head;
    for ( i = 0; i < parent->chil.count; i++ ) {

        window = (Window*)dl_next_entry( &parent->chil )->data;
        if ( window->id == id )
            return window;

    }
#ifdef WINDOW_DEBUG
    fprintf( stderr, "parent has no child with id %i\n", id );
#endif
    return 0;
}

/* adjust track button position from scrollbar */
void adjust_track_button( Window *window, int ref )
{
    Window *track_button = 0;
    int x, y;
    int length, offset;

    /* check if exists */
    if ( !window || window->type != SCROLL ) return;
    track_button = get_child( window, ID_TRACK );
    if ( !track_button ) return;

    if ( window->max == window->min ) return;

    x = track_button->x;
    y = track_button->y;
    /* get length of actual scrollbar */
    if ( window->dir == HORI )
        length = window->width;
    else
        length = window->height;
    /* if more than one children up/down buttons */
    if ( window->chil.count > 1 ) {
        length -= 3 * window->button_size;
        offset = window->button_size;
    }
    else {
        length -= window->button_size;
        offset = 0;
    }
    /* change position */
    /* if not REFRESH just change coords */
    if ( ref == REFRESH )
        hide_window( track_button, REFRESH );
    if ( window->dir == HORI )
        x = ( (float)( window->pos - window->min ) / ( window->max - window->min ) ) *
              length + offset + window->x;
    else
        y = ( (float)( window->pos - window->min ) / ( window->max - window->min ) ) *
              length + offset + window->y;
    move_window( track_button, x, y, ref );
}

/* set track button pos in pixel (and adjust position index)*/
void set_track_button_pos( Window *window, int new_pos, int ref )
{
    Window *track_button = 0;
    int x, y;
    /* length and offset of actual scrollbar */
    int length, offset;

    /* check if exists */
    if ( !window || window->type != SCROLL ) return;
    track_button = get_child( window, ID_TRACK );
    if ( !track_button ) return;

    /* get length of actual scrollbar */
    if ( window->dir == HORI )
        length = window->width;
    else
        length = window->height;
    /* if more than one children up/down buttons */
    if ( window->chil.count > 1 ) {
        length -= 3 * window->button_size;
        offset = window->button_size;
    }
    else {
        length -= window->button_size;
        offset = 0;
    }

    x = track_button->x;
    y = track_button->y;
    /* change position */
    if ( window->dir == HORI ) {

        x = new_pos;
        if ( x < window->x + offset )
            x = window->x + offset;
        if ( x > window->x + window->width - window->button_size - offset )
            x = window->x + window->width - window->button_size - offset;
        window->pos = ( ( x - offset - window->x ) *
                        ( window->max - window->min ) /
                        length ) + window->min;

    }
    else {

        y = new_pos;
        if ( y < window->y + window->button_size )
            y = window->y + window->button_size;
        if ( y > window->y + window->height - window->button_size - offset )
            y = window->y + window->height - window->button_size - offset;
        window->pos = ( ( y - offset - window->y ) *
                        ( window->max - window->min ) /
                        length ) + window->min;

    }
    if ( window->pos < window->min ) window->pos = window->min;
    if ( window->pos > window->max ) window->pos = window->max;

    if ( ref == REFRESH ) {
        if ( x != track_button->x || y != track_button->y ) {

            hide_window( track_button, REFRESH );
            move_window( track_button, x, y, ref );

        }
    }
}

/* return if switch if set */
int is_on( Window *window ){
    if ( window->is_switch && window->is_on ) return 1;
    return 0;
}

/* set active flag to active and refresh if wanted */
void set_active( Window *window, int active, int ref )
{
    window->active = active;
    if ( ref ) window->ref = REFRESH;
}

/* set scrollbar range */
void set_scroll_range( Window *window, int min, int max, int step, int pos, int ref )
{
    window->min = min;
    window->max = max;
    window->pos = pos;
    window->step = step;

    adjust_track_button( window, ref );

/*    track->x = window->x;
    track->y = window->y;
    if ( window->dir == HORI )
        track->x += window->button_size;
    else
        track->y += window->button_size;*/
}

/*
====================================================================
(Un)Select icon
====================================================================
*/
void select_icon( Window *icon, int ref )
{
    if ( icon->type != FRAME_ICON ) return;
    icon->is_on = 1;
    if ( ref ) icon->ref = REFRESH;
}
void unselect_icon( Window *icon, int ref )
{
    if ( icon->type != FRAME_ICON ) return;
    icon->is_on = 0;
    if ( ref ) icon->ref = REFRESH;
}
