#ifndef __DEVW_CLASS
#define __DEVW_CLASS

class QWidget;
class QPaintEvent;
class QCheckBox;
class QButtonGroup;
class QScrollBar;
class XWire;
class InverterWidget;

#include <xdevice.h>
#include <klogicList.h>

class InverterScrollWidget : public QWidget
{	Q_OBJECT
public:
	InverterScrollWidget(QWidget *, const char *, XDevice *);
	~InverterScrollWidget();
	void setGeometry(int, int, int, int);
	void paintEvent(QPaintEvent *);
	void setInputButtons();
	void setOutputButtons();

private slots:
	void vScroll(int);

private:
	InverterWidget *inverterw;
	QScrollBar *vscroll;
	XDevice *dev;
	int curr_y_size;
};


class InverterWidget : public QWidget
{	Q_OBJECT
public:
	InverterWidget(QWidget *, const char *, XDevice *);
	~InverterWidget();
	void paintEvent(QPaintEvent *);
	void setInputButtons();
	void setOutputButtons();

private slots:
	void inputButton(int);
	void outputButton(int);
private:
	XDevice *dev;

	QCheckBox *iswitch[XDevice::MAXSIZE];
	KlogicList<XWire> iwire[XDevice::MAXSIZE];
	QButtonGroup *bg_i;
	QCheckBox *oswitch[XDevice::MAXSIZE];
	KlogicList<XWire> owire[XDevice::MAXSIZE];
	QButtonGroup *bg_o;
};

#endif
