//*************************************************************************
//* singleton grid object                                                 *
//*************************************************************************

#include <qpainter.h>
#include <qimage.h>
#include "grid.h"

#include "klogic.h"
#undef GRID
#undef GRIDHALF
#undef GRIDDOUBLE
//-- prevent shadows
//-- klogic.h only needed for constants VIRT_SCREEN_SIZE_X
//--									VIRT_SCREEN_SIZE_Y

//=====================================================================
//== init static variables                                           ==
//=====================================================================
QImage Grid::m_oGrid = QImage();

//=====================================================================
//== constructor/destructor/initializing                             ==
//=====================================================================
Grid::Grid()
{
	init();
}
//---------------------------------------------------------------------
//-- creates the grid in an image buffer
//--
//-- performance measure: 
//-- painting 19200 points takes roughly 50 millisecs and 7.5 MByte
void Grid::init()
{
	int x = -1;
	int y = -1;

	// at first create the only grid image
	if( m_oGrid.isNull() )
	{
		// two colors needed(black and white) in 32bit color depth
		m_oGrid = QImage( VIRT_SCREEN_SIZE_X, VIRT_SCREEN_SIZE_Y, 32, 2 );

		// background
		m_oGrid.fill( Qt::white.pixel() );

		// foreground
		for( x = 0; x < VIRT_SCREEN_SIZE_X; x += Grid::GRID )
		{
			for( y = 0; y < VIRT_SCREEN_SIZE_Y; y += Grid::GRID )
			{
				m_oGrid.setPixel( x, y, Qt::black.pixel() );
			}
		}
	}
}
//---------------------------------------------------------------------

//=====================================================================
//== painting                                                        ==
//=====================================================================
//-- paints background and grid for entire virtual screen
//-- this method is normaly called once in a program run
//--
//-- performance measure: painting needs nearly 250 millisecs
void Grid::draw( QPainter* p )
{
	QRect rcVirtScreen( 0, 0, VIRT_SCREEN_SIZE_X, VIRT_SCREEN_SIZE_Y );

	Grid::draw( p, rcVirtScreen );
}
//---------------------------------------------------------------------
//-- paints background and grid for the former position of
//-- a moved device
//--
//-- performance measure:
//-- painting needs nearly 5 millisecs per device movement
void Grid::draw( QPainter* p, QRect rc )
{
	bitBlt
	(
		p->device(),
		rc.x(),
		rc.y(),
		&m_oGrid,
		rc.x(),
		rc.y(),
		rc.width(),
		rc.height()
	);
}
//---------------------------------------------------------------------

//=====================================================================
//== grid alignment                                                  ==
//=====================================================================
//-- ptSrc	Coordinate to align
QPoint Grid::getAligned( QPoint ptSrc )
{
	// Align to the same grid size in x and y direction
	QPoint ptReturn = ( ptSrc / Grid::GRID ) * Grid::GRID;

	return ptReturn;
}
//---------------------------------------------------------------------
//-- rcSrc	Coordinate to align
QRect Grid::getAligned( QRect rcSrc )
{
	QRect 	rcReturn 	= rcSrc;

	// Align only one angle of the bounding rectangle
	QPoint	ptTopLeft	= getAligned( rcReturn.topLeft() );

	// Move along the axis
	rcReturn.moveTopLeft( ptTopLeft );

	return rcReturn;
}
//---------------------------------------------------------------------
