#ifndef __BUS_OUTPUT_ARRAY__
#define __BUS_OUTPUT_ARRAY__

#include "xdevice.h"
#include "tool.h"

class BusOutputArray
{
public:
	BusOutputArray(XDevice *_dev, bool i_flag, bool as_tristate)
	{
		dev = _dev;

		// output bus only
		initOutputBus(as_tristate);

		// input- and output bus
		if (i_flag)
			initInputBus();
	}

	int getOutputWeight(int output_id)
	{
		if (!output_id) return -1;
		for(int i = 0; i < 8; i++)
			if (output_id == bus_output_id[i])
				return Tool::pow2(i);
		return -1;
	}

	int operator [] (int idx)
	{
		return bus_output_id[idx];
	}

private:
	void initOutputBus(bool as_tristate)
	{
		for (int i = 0; i < 8; i++) {
			bus_output_id[i] = dev->addOutputName(IO_BUS_DATA[i], i + 1);
			if (as_tristate)
				dev->outputSetTristate(bus_output_id[i], true);
		}
	}

	void initInputBus()
	{
		for (int i = 0; i < 8; i++) {
			dev->addInputName(IO_BUS_DATA[i], i + 1);
		}
	}

	static const QString IO_BUS_DATA[8];	// defined in xdevice.cpp!

	int bus_output_id[8];   // output bus

	XDevice *dev;
};

#endif
