<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">
<html>
<head>
  <title>Tor: Настройка сервера</title>
  <meta name="Author" content="Roger Dingledine">
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <link rel="stylesheet" type="text/css" href="../stylesheet.css">
  <link rel="shortcut icon" type="image/x-icon" href="../favicon.ico">
</head>
<body>
<div class="center">
<table class="banner" border="0" cellpadding="0" cellspacing="0" summary="">
    <tr>
        <td class="banner-left"><a href="https://www.torproject.org/"><img src="../images/top-left.png" alt="Click to go to home page" width="193" height="79"></a></td>
        <td class="banner-middle">
	<a href="../index.html.ru">Главная</a>
<a href="../overview.html.ru">Обзор</a>
<a href="../download.html.ru">Скачать</a>
<a href="../documentation.html.ru">Документация</a>
<a href="../volunteer.html.ru">Добровольцы</a>
<a href="../people.html.ru">Люди</a>
<a href="https://blog.torproject.org/">Блог</a>
<a href="../donate.html.ru">Donate!</a>
        </td>
        <td class="banner-right">
	<img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-relay.html.en"><acronym title="English"><img src="../images/en.png" alt="English" width="24" height="16"></acronym></a> <a href="tor-doc-relay.html.es"><acronym title="espa&ntilde;ol"><img src="../images/es.png" alt="espa&ntilde;ol" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-relay.html.fr"><acronym title="fran&ccedil;ais"><img src="../images/fr.png" alt="fran&ccedil;ais" width="24" height="16"></acronym></a> <a href="tor-doc-relay.html.it"><acronym title="Italiano"><img src="../images/it.png" alt="Italiano" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-relay.html.pl"><acronym title="polski"><img src="../images/pl.png" alt="polski" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <acronym title="&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)"><img src="../images/ru.png" alt="&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)" width="24" height="16"></acronym> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-relay.html.zh-cn"><acronym title="&#20013;&#25991;(&#31616;) (Simplified Chinese)"><img src="../images/zh-cn.png" alt="&#20013;&#25991;(&#31616;) (Simplified Chinese)" width="24" height="16"></acronym></a>
        </td>
    </tr>
</table>
<div class="center">
<div class="main-column">
<h1>Настройка сервера <a href="../index.html.ru">Tor</a></h1>
<br>
<p>
Сеть Tor основывается на добровольцах делящихся своим трафиком. Чем больше людей
запускают серверы, тем быстрее работает сеть Tor. Если у вас есть по крайней мере
20 килобайт/сек в каждом направлении, пожалуйста помогите сети Tor настроив свой
сервер. Мы реализовали много чего чтобы сделать серверы Tor лёгкими и удобными
в использовании, включая ограничение трафика, ограничения выхода(exit policies),
и поддержку динамических IP.</p>
<p>Размещение серверов в разных уголках Интернета это именно то, что
обеспечивает безопасность пользователей Tor.
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#RelayAnonymity">Вы также получаете
более сильную анонимность сами</a>,
так как третьи стороны не могут знать кем инициированы соединения - вашим локальным компьютером
или другими узлами сети Tor.</p>
<p>Установка сервера Tor проста и удобна:
<ul>
<li>Tor имеет встроенную поддержку
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#LimitBandwidth">
ограничения трафика</a>. Более того, если у вас скоростной канал, но вы хотите
ограничить трафик вашего сервера за день (или неделю или месяц) то это легко
реализуется с помощью автоматического
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Hibernation">
режима бездействия (hibernation)</a>.
</li>
<li>У каждого сервера есть своя
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#RunARelayBut">
политика ограничения выхода</a> которая определяет какие выходящие соединения
разрешены или запрещены на этом конкретном сервере. Если вы не хотите
разрешать выходы с вашего сервера, можно запретить все соединения
кроме как с другими узлами сети Tor.
</li>
<li>Ничего страшного если сервер иногда недоступен в сети. Серверы директорий
замечают это довольно быстро и перестают предлагать недоступный сервер. Только
постарайтесь чтобы это не случалось часто, т.к. уже установленные с выключающимся
сервером соединения разрываются.
</li>
<li>Мы без проблем поддерживаем серверы с динамическим IP &mdash; просто оставьте
в файле настроек опцию Address с пустым значением, и Tor попытается угадать.
</li>
<li>Если ваш сервер находится за NAT и не знает свой публичный IP
(например IP имеет вид 192.168.x.y), то придётся настроить перенаправление
(port forwarding). Перенаправление TCP соединений это системно-зависимая операция,
но в <a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ServerForFirewalledClients">
этом разделе FAQ</a> есть несколько примеров как это делается.
</li>
<li>Ваш сервер будет самостоятельно оценивать и сообщать текущую пропускную
способность, и таким образом "толстые" сервера привлекают больше пользователей.
Следовательно не очень скоростные сервера тоже полезны.
</li>
</ul>
<p>Сервер Tor способен работать на большинстве операционных систем, но в
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#RelayOS">
этом разделе FAQ</a> даны советы какие ОС подходят лучше и с какими проблемами
можно столкнуться.</p>
<hr>
<a id="zero"></a>
<h2><a class="anchor" href="#zero">Шаг нулевой: Скачать и установить Tor</a></h2>
<br>
<p>Перед тем как приступить к серверу, вы должны убедиться что Tor запущен и работает.
</p>
<p>Для Windows, это означает по крайней мере
<a href="../docs/tor-doc-windows.html.ru#installing">первый шаг</a>
из инструкций по установке Tor на Windows.
На Mac OS X вы должны выполнить по крайней мере
<a href="../docs/tor-doc-osx.html#installing">первый шаг</a>
из инструкций по установке Tor на OS X.
На Linux/BSD/Unix вы должны выполнить по крайней мере
<a href="../docs/tor-doc-unix.html.ru#installing">первый шаг</a>
из инструкций по установке Tor на Unix.
</p>
<p>Если это возможно, попробуйте использовать его в качестве клиента
чтобы убедиться что всё на самом деле работает.</p>
<hr>
<a id="setup"></a>
<h2><a class="anchor" href="#setup">Шаг первый: Настройте сервер</a></h2>
<br>
<p>
1. Проверьте что часы установлены точно. Если возможно - синхронизируйте
часы с публичными серверами времени.
</p>
<p>
2. Убедитесь что работает разрешение имён (DNS) (то есть, ваш компьютер
может правильно делать name resolving).
</p>
<p>
3. Отредактируйте последнюю часть файла конфигурации torrc. (Консультируйтесь
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#torrc">с этим
разделом FAQ</a>.)
Вы должны определить по крайней мере Nickname и ORPort. Создайте каталог DataDirectory
если требуется, и убедитесь что он принадлежит пользователю от которого будет запущен
сервер. <em>Если вы хотите запустить более одного сервера, это замечательно,
но тогда пожалуйста обратите внимание на
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#MultipleRelays">
опцию MyFamily</a> в файлах конфигурации для всех серверов.</em>
</p>
<p>
4. Если вы используете файерволл(брандмауэр), разрешите входящие соединения
на порты которые вы указали в torrc (ORPort, и DirPort если вы его включили).
Также разрешите выходящие соединения, чтобы ваш сервер мог достать другие сервера Tor.
</p>
<p>
5. Перезапустите сервер. Если в
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Logs">
логах появились предупреждения</a>, исправьте причины их возникновения.
</p>
<p>
6. Подпишитесь на список рассылки <a
href="http://archives.seul.org/or/announce/">or-announce</a>.
Там очень мало сообщений, и вы будете проинформированы о новых стабильных
релизах. Также можно подписаться на список рассылки
<a href="http://archives.seul.org/or/talk/">or-talk</a> (побольше сообщений будет),
где кроме всего прочего объявляются релизы в разработке.
</p>
<p>
7. Почитайте мануал.
<a href="../tor-manual.html">Мануал</a> для последней стабильной версии
указывает все возможные настройки для клиента и сервера.
Мануал для последней разрабатываемой версии доступен
<a href="../tor-manual-dev.html">здесь</a>.
Русский перевод мануала (довольно устаревший) доступен
<a href="http://www.privoxy.asplinux.net/man-page/tor-man-page.html">здесь</a>
</p>
<hr>
<a id="check"></a>
<h2><a class="anchor" href="#check">Шаг второй: Убедитесь что он работает</a></h2>
<br>
<p>Как только ваш сервер сможет подсоединиться к сети, он попытается
определить доступность своих портов снаружи. Это может занять до 20 минут.
Ищите <a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Logs">сообщения в логах</a>
вида <tt>Self-testing indicates your ORPort is reachable from the outside. Excellent.</tt>
Если вы не видите подобных сообщений, это значит что ваш сервер недоступен из Сети
&mdash; тогда следует перепроверить фаерволл, проверить что сервер пытается достучаться
именно до того адреса/порта где он должен быть, итд.
</p>
<p>Как только сервер определит доступность, он загрузит на сервер директорий
свой дескриптор (описатель, descriptor). Это позволит клиентам
узнать адрес, порты, ключи и другую информацию о вашем сервере.
Вы можете вручную
<a href="http://moria.seul.org:9032/tor/status/authority">
скачать один из статусов сети</a>
и найти там nickname своего сервера, чтобы убедиться что он будет использоваться
клиентами. Может понадобиться немного времени чтобы эта информация обновилась.
</p>
<hr>
<a id="after"></a>
<h2><a class="anchor" href="#after">Шаг третий: После установки сервера</a></h2>
<br>
<p>
Мы рекомендуем предпринять следующие шаги:
</p>
<p>
8. Прочитайте
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/OperationalSecurity">этот документ</a>
чтобы узнать как улучшить безопасность сервера.
</p>
<p>
9. Решите какую политику выхода применять. По умолчанию сервер
разрешает соединения на многие популярные сервисы, но запрещает
некоторые (например порт 25) из-за возможных злоупотреблений.
Вы можете настроить более жёсткую или мягкую политику ограничения выхода,
для этого соответствующим образом отредактируйте torrc.
Прочитайте раздел FAQ чтобы знать
<a href="../faq-abuse.html#TypicalAbuses">с какими проблемами
вы можете встретится при использовании политики по умолчанию</a>.
Если вы выбираете свободную политику выхода, будьте уверены
что ваш провайдер не против. Если с вашего компьютера невозможно достичь
каких-либо ресурсов (например вы находитесь за ограничивающим файерволлом или
фильтром содержания), пожалуйста явно запретите эти ресурсы в вашей политике
выхода &mdash; иначе это будет мешать другим пользователям Tor.
</p>
<p>
10. Определитесь с ограничением скорости. Пользователи кабельных
модемов, DSL, и других типов соединений с асимметричной пропускной способностью
(например больше входа чем выхода) должны ограничится меньшей из двух величин,
дабы избежать перегрузок. Смотрите
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#LimitBandwidth">
этот раздел FAQ</a> для подробностей.
</p>
<p>
11. Сделайте резервную копию приватного ключа сервера (хранится в
"keys/secret_id_key" в DataDirectory). Этот ключ идентифицирует ваш сервер
и вы должны держать его в безопасности, чтобы никто не мог расшифровать трафик
идущий через ваш сервер. Это критический файл который вы должны сохранить
в случае если вам понадобится
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#UpgradeRelay">
передвинуть или восстановить ваш сервер Tor</a> если что-то пойдёт не так.
</p>
<p>
12. Если вы контролируете сервера имён для вашего домена, установите
имя хоста в 'anonymous' или 'proxy' или 'tor-proxy', для того чтобы
другие люди, увидев ваш домен в своих логах, быстрее могли разобраться в
чём дело.
</p>
<p>
13. Если на вашем компьютере нет вебсервера, пожалуйста
установите ORPort в 443 и DirPort в 80. Много пользователей Tor
закрыты фаерволлами которые только позволяют им использовать http,
и это изменение позволит им достичь ваш сервер Tor. Серверы на Win32
могут просто изменить свой ORPort и DirPort напрямую в torrc
и перезапустить Tor. Серверы OS X и Unix не могут напрямую вешаться на этот порт
(так как это требует привилегий суперпользователя), поэтому им понадобится
использовать
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ServerForFirewalledClients">
перенаправление портов</a>. Если у вас уже заняты порты 80 и 443, но вы хотите
помочь пользователям с такими ограничениями, то полезно будет назначить порты 22, 110,
или 143.
</p>
<p>
14. Если ваш сервер предоставляет другие сервисы на этом же IP
&mdash; такие как публичный вебсервер &mdash; будьте уверены что соединения к серверу
разрешены с локального хоста. Вы должны разрешить эти соединения, так как
клиенты Tor определят что ваш сервер это наиболее
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ExitEavesdroppers">
безопасный способ достичь этот вебсервер</a>, и будут строить цепочки которые всегда
будут заканчиваться на вашем сервере. Если вы не хотите разрешать это соединение,
вы должны явно запретить его в политике выхода.
</p>
<p>
15. (Только для Unix). Создайте отдельного пользователя для
запуска сервера. Если вы устанавливали из OS X пакета, или deb или rpm
то это уже было сделано. Иначе вы можете сделать это вручную. Сервер Tor
не требует привилегий root'а для работы, поэтому правильно будет не
запускать Tor от суперпользователя. Запуск под пользователем 'tor' позволит
избежать проблем с identd и другими сервисами который определяют имя
пользователя. (Если вы немного параноик, спокойно запускайте
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorInChroot">
Tor в chroot</a>.)
</p>
<p>
16. (Только для Unix.) Скорее всего ваша опеационная система ограничивает
количество дескрипторов открытых файлов на процесс до 1024 (или даже меньше).
Если вы планируете иметь выходной узел Tor, то этого может оказаться недостаточно.
В Linux вы должны добавить строчку вида "toruser hard nofile 8192" в файл
/etc/security/limits.conf (где toruser это пользователь от которого запускается
процесс Tor), и перезапустите Tor. Если это не сработало, смотрите
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#FileDescriptors">
этот раздел FAQ</a> сдругими предложенными способами выполнить "ulimit -n 8192"
перед запуском Tor.
</p>
<p>
17. Если вы устанавливали Tor из пакета или с помощью инсталлятора, он наверное
автоматически стартует при загрузке системы. Но если вы устанавливали из
исходников, вам придётся вручную это настраивать, и скрипты contrib/tor.sh и/или
contrib/torctl могут вам пригодится.
</p>
<p>
Когда вы изменяете настройки Tor, не забудьте проверить что ваш сервер
продолжает корректно работать после изменений. Пожалуйста заполните
"ContactInfo" в torrc чтобы мы могли связаться с вами если вашему серверу
надо будет обновиться или случится что-то непредвиденное. Если у вас возникли
проблемы или вопросы, смотите раздел <a href="../documentation.html.ru#Support">Помощь</a>
или <a href="../contact.html.ru">свяжитесь с нами</a> через лист рассылки tor-ops. Спасибо за
помощь в развитии сети Tor!
</p>
<hr>
<p>Если у вас есть предложения по улучшению этого документа, пожалуйста
<a href="../contact.html.ru">присылайте их нам</a>. Спасибо!</p>
  </div><!-- #main -->
</div>
</div>
  <div class="bottom" id="bottom">
     <p>
     <i><a href="../contact.html.ru" class="smalllink">Webmaster</a></i> -
      Последние изменения: Sun Mar 2 17:31:17 2008
      -
      Последняя компиляция: Sun Mar 2 17:36:01 2008
     </p>
     <p>"Tor" и "Onion Logo" - <a href="../trademark-faq.html">торговые марки</a> принадлежащие Tor Project, Inc.
     </p>
     <p>
       Эта страница также переведена на следующие языки:
       <a href="tor-doc-relay.html.en">English</a>, <a href="tor-doc-relay.html.es">espa&ntilde;ol</a>, <a href="tor-doc-relay.html.fr">fran&ccedil;ais</a>, <a href="tor-doc-relay.html.it">Italiano</a>, <a href="tor-doc-relay.html.pl">polski</a>, <a href="tor-doc-relay.html.zh-cn">&#20013;&#25991;(&#31616;) (Simplified Chinese)</a>.<br>
       Как установить <a href="http://www.debian.org/intro/cn#howtoset">язык документов по умолчанию</a>.
     </p>
   <p>Разработчики Tor не проверяли этот перевод на точность и корректность.
   Перевод может быть устаревшим или просто неправильным. Официальный веб-сайт
   Tor на английском языке доступен по адресу
   <a href="https://www.torproject.org/">https://www.torproject.org/</a>.
   </p>
  </div>
</body>
</html>
