/*  $Id: IngredientSprite.h,v 1.6 2004/05/02 04:55:48 sarrazip Exp $
    IngredientSprite.h - Sprite that is part of an "ingredient"

    burgerspace - A hamburger-smashing video game.
    Copyright (C) 2001-2004 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

#ifndef _H_IngredientSprite
#define _H_IngredientSprite

#include <flatzebra/Sprite.h>

#include <vector>

using namespace flatzebra;

class IngredientGroup;


class IngredientSprite : public Sprite
/*  This object does not own the 'IngredientGroup' to which it refers.
*/
{
public:

    typedef std::vector<class IngredientSprite *> List;

    enum { LOWERING_DISTANCE = 4 };

    IngredientSprite(const PixmapArray &pixmapArray,
			const Couple &pos,
			IngredientGroup *ig
			/*, int ytarget*/ ) throw(int);

    IngredientGroup *getGroup() const { return myGroup; }

    void lower() { getPos().y += LOWERING_DISTANCE; lowered = true; }
    void setLowered() { lowered = true; }
    void setNormal() { lowered = false; }

    bool isLowered() const { return lowered; }

private:

    IngredientGroup *myGroup;
    bool lowered;

};


#endif  /* _H_IngredientSprite */
