/* treewm - an X11 window manager.
 * Copyright (c) 2000 Thomas Jger <thehunter2000@web.de>
 * This code is released under the terms of the GNU GPL. See
 * the included file LICENSE for details.
 */

#ifndef UEHANDLER_H
#define UEHANDLER_H

#include "global.h"
#include "client.h"


#define QA_NUM 5

#define RESIZERATIO 5

class UEHandler {
  public:
	  UEHandler();
    ~UEHandler();
    void Press(XButtonEvent &);
    void Motion(XMotionEvent &);
    void Release(XButtonEvent &);
    void Key(XKeyEvent &);
    void RemoveClientReferences(Client *c);
    Desktop *SelDesktop;
    Client *SelEntry;
    Client *SelClient;
    Client *RefClient;
    Menu *menu;
    MenuItem *menuitems;
    unsigned long Seltype;
  protected:
    Client *qa[QA_NUM]; // quick access
    Window MoveWin;
    int xdown,ydown;
    Client *NewTarget;
    Icon *SelIcon;
    Time downtime;
    Action *act[2];
    bool motion;
    	
};

#endif
