/* treewm - an X11 window manager.
 * Copyright (c) 2000 Thomas Jger <thehunter2000@web.de>
 * This code is released under the terms of the GNU GPL. See
 * the included file LICENSE for details.
 */

#include "menuinfo.h"
#include "action.h"

struct MenuItemList {
  MenuItem mi;
  MenuItemList *next;
};

MenuInfo::MenuInfo(Section *section) {
  s = section;
}

void MenuInfo::Init() {
  n = 0;
  MenuItemList *actions=0,*last=0;
  Action *a;
  for (Entry *e=s->fe;e;e=e->next)
    if (!strncasecmp("Action",e->tag,6)) {
      lower(e->value);
      a = (Action *)rman->GetInfo(SE_ACTION,e->value);
      if (a) {
        if (last) {
          last->next = new MenuItemList;
          last = last->next;
        } else {
          actions = new MenuItemList;
          last = actions;
        }
        last->mi.text = a->name;
        last->mi.key = "";
        last->mi.data = a;
        last->mi.flags = 0;
        last->next = 0;
        ++n;
      }
    }
  if (!n) {
    menu = 0;
    return;
  }
  menu = new MenuItem[n];
  int k=0;
  while (actions) {
    menu[k] = actions->mi;
    last = actions;
    actions = actions->next;
    delete last;
    ++k;
  }
}

MenuInfo::~MenuInfo() {

}
