/* treewm - an X11 window manager.
 * Copyright (c) 2000 Thomas Jger <thehunter2000@web.de>
 * This code is released under the terms of the GNU GPL. See
 * the included file LICENSE for details.
 */

#ifndef MANAGER_H
#define MANAGER_H

#include "global.h"

// see notes below
struct ClientList {
  Client *client;
  ClientList *next;
};


void SigHandler(int);

class Manager {
  public:
    Manager(int argc, char **argv);
    void AddDeleteClient(Client *);
    void AddReDrawClient(Client *);
    ~Manager();
    int Run();
    void Quit();
    Client *WantFocus,*ToBeRaised;
    bool NextLeave;
    struct ClientList *MustBeDeleted, *FirstReDraw, *LastReDraw;
    bool alive;

};
#endif
