/* treewm - an X11 window manager.
 * Copyright (c) 2000 Thomas Jger <thehunter2000@web.de>
 * This code is released under the terms of the GNU GPL. See
 * the included file LICENSE for details.
 */

#ifndef GLOBAL_H
#define GLOBAL_H

#ifdef DEBUG2
#define DEBUG
#endif


#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#ifdef SHAPE
#include <X11/extensions/shape.h>
#endif
#ifdef DEBUG
#include <stdarg.h>
#endif

#define TF_ISICON 1024

//Class Declarations
class TWindow {
  public:
  long flags;
};
class Manager;
class Client;
class Desktop;
class Icon;
class Action;
class ClientInfo;
class RPixmap;
class ClientTree;
class Section;
class ResManager;
class Options;
class Sceme;
class UEHandler;
class Menu;
class Info {
  public:
    virtual ~Info();
    virtual void Init() = 0;
};

#define ButtonMask (ButtonPressMask|ButtonReleaseMask|ButtonMotionMask)
#define ChildMask (SubstructureRedirectMask|SubstructureNotifyMask)
#define MouseMask (ButtonPressMask|ButtonReleaseMask|PointerMotionMask)


extern Display *dpy;
extern ClientTree *ct;
extern UEHandler *UEH;
extern Manager *man;
extern ResManager *rman;
extern int screen;
extern Window root;
extern Atom wm_state, wm_change_state, wm_protos, wm_delete, wm_cmapwins, wm_client_leader,
            mwm_hints;

int handle_xerror(Display *dpy, XErrorEvent *e);

#ifdef SHAPE
extern Bool shape;
extern int shape_event;
#endif

void lower(char * str);

#ifdef DEBUG
void err(const char *fmt, ...);
#endif

#define MAXTITLE 150
#define MAXICON 30


#endif
