/* treewm - an X11 window manager.
 * Copyright (c) 2000 Thomas Jger <thehunter2000@web.de>
 * This code is released under the terms of the GNU GPL. See
 * the included file LICENSE for details.
 */

#ifndef CLIENTINFO_H
#define CLIENTINFO_H

#include "global.h"
#include "resmanager.h"


// defines for flags
#define CI_X                       (1L<< 0)
#define CI_Y                       (1L<< 1)
#define CI_WIDTH                   (1L<< 2)
#define CI_HEIGHT                  (1L<< 3)
#define CI_DESKTOP                 (1L<< 4)
#define CI_ICONX                   (1L<< 5)
#define CI_ICONY                   (1L<< 6)
#define CI_VIRTUALX                (1L<< 7)
#define CI_VIRTUALY                (1L<< 8)
#define CI_BW                      (1L<< 9)
#define CI_AUTOCLOSE               (1L<<10)
#define CI_MAXIMIZED               (1L<<11)
#define CI_MMAXIMIZED              (1L<<12)
#define CI_HASTITLE                (1L<<13)
#define CI_HASTBENTRY              (1L<<14)
#define CI_TILE                    (1L<<15)
#define CI_STICKY                  (1L<<16)
#define CI_AUTOSCROLL              (1L<<17)
#define CI_NOBACKGROUND            (1L<<18)


struct ActionList {
  Action *a;
  ActionList *next;
};

class ClientInfo : public Info {
  public:
    ClientInfo(Section *);
    virtual ~ClientInfo();
    virtual void Init();
    char	*name;
    int	x, y, width, height;
    int IconX,IconY;
    int VirtualX, VirtualY;
    RPixmap *iconpm, *bgpm;
    int target;
    long flags;
    int stacking;
    Sceme *Sc;
    ActionList *actions;

    Section *s;

};

#endif
