#include <math.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <stdio.h>
#include "trippy.h"

struct pt
{
  int x, y;
  int dx,dy;
  int pixel;
  struct pt *next, *prev;
};

typedef struct pt PT;

struct PTList
{
  int size;
  PT *next, *prev;
};
typedef struct PTList ptList;

ptList *head1,*head2,*head3,*head4;

int HCV;

void add(ptList *here,int init,int winno)
{
  PT *point;
  
  point=(PT *)malloc(sizeof(PT));
  
  if(init)
  {
    point->x=rndm(CX[winno]);
    point->y=rndm(CY[winno]);
    point->dx=1;
    point->dy=1;
    point->pixel=rndm(numcolors-1)+1;
  }
  else
  {
    int radius = (int)hypot(head2[winno].next->x-head1[winno].next->x,
			    head2[winno].next->y-head1[winno].next->y);
    point->x=here->next->x+here->next->dx;
    point->y=here->next->y+here->next->dy;
    point->dx=here->next->dx;
    point->dy=here->next->dy;
    point->pixel=(here->next->pixel+HCV)%numcolors;
    if (!rndm((long)(1000)))
      point->pixel=rndm(numcolors-1)+1;
    if((point->x<0)|| ((options.mode==circ)&&(point->x<radius)))
    {
      point->dx=rndm(7);
      point->x+=point->dx;
    }
    else if((point->x>CX[winno])||
	    ((options.mode==circ)&&(CX[winno]-point->x<radius)))
    {
      point->dx= -rndm(7);
      point->x+=point->dx;
    }
    if((point->y<0)|| ((options.mode==circ)&&(point->y<radius)))
    {
      point->dy=rndm(7);
      point->y+=point->dy;
    }
    else if((point->y>CY[winno])||
	    ((options.mode==circ)&&(CY[winno]-point->y<radius)))
    {
      point->dy= -rndm(7);
      point->y+=point->dy;
    }
  }
  
  if(here->prev==NULL)
    here->prev=point;
  if(here->next==NULL)
    here->next=point;
  else
  {
    here->next->prev=point;
    point->next=here->next;
    point->prev=here->prev;
    here->next=point;
  }
  here->size++;
}

void delete1(ptList *here)
{
  PT *temp=here->prev->prev;
  here->next->prev=temp;
  temp->next=here->next;
  
  free(here->prev);
  here->prev=temp;
  
  here->size--;
}

void
init_boxes(int winno)
{
  static int inited=0;
  int count;

/* make the first level */
  if(!inited)
  {
    /* 4 lists for each window, one for each point */
      
    head1=(ptList *)calloc(options.windows,sizeof(ptList));
    head2=(ptList *)calloc(options.windows,sizeof(ptList));
    if(options.mode==bozo || options.mode==bez)
    {
      head3=(ptList *)calloc(options.windows,sizeof(ptList));
      head4=(ptList *)calloc(options.windows,sizeof(ptList));
    }
    inited=1;
  }

/* and now the second level */

/* init the 4 points */
  head1[winno].prev=NULL;
  head1[winno].next=NULL;
  head1[winno].size=0;
  head2[winno].prev=NULL;
  head2[winno].next=NULL;
  head2[winno].size=0;
  if(options.mode==bozo || options.mode==bez)
  {
    head3[winno].prev=NULL;
    head3[winno].next=NULL;
    head3[winno].size=0;
    head4[winno].prev=NULL;
    head4[winno].next=NULL;
    head4[winno].size=0;
  }
  add(&head1[winno],1,winno);
  add(&head2[winno],1,winno);
  if(options.mode==bozo || options.mode==bez)
  {
    add(&head3[winno],1,winno);
    add(&head4[winno],1,winno);
  }
  
  if(options.multi)
    HCV=1;
  else
    HCV=0;  
}

void
move_boxes(int winno)
{
  int count;

  if(head1[winno].size>=options.number)
    delete1(&head1[winno]);
  if(head2[winno].size>=options.number)
    delete1(&head2[winno]);
  if(options.mode==bozo || options.mode==bez)
  {
    if(head3[winno].size>=options.number)
      delete1(&head3[winno]);
    if(head4[winno].size>=options.number)
      delete1(&head4[winno]);
  }
  
  if (options.mode==circ)
  {
    int radius = (int)hypot(head2[winno].next->x-head1[winno].next->x,
			    head2[winno].next->y-head1[winno].next->y);
    if(radius>40)
    {
      if(rndm(1))
	/* X2[winno][0]=X1[winno][0]-40; */
	head2[winno].next->x=head1[winno].next->x-40;
      else
	/* Y2[winno][0]=Y1[winno][0]-40; */
	head2[winno].next->y=head1[winno].next->y-40;
    }
  }
}

void
bounce(int winno)
{ 
  /*#*#* Bouncing Code *#*#*/
  add(&head1[winno],0,winno);
  add(&head2[winno],0,winno);
  if(options.mode==bozo|| options.mode==bez)
  {
    add(&head3[winno],0,winno);
    add(&head4[winno],0,winno);
  }
}

void draw_qix(int winno)
{ 
  XDrawLine(display,window[winno],color_gcs[head1[winno].next->pixel],
	    head1[winno].next->x,head1[winno].next->y,
	    head2[winno].next->x,head2[winno].next->y);
  XDrawLine(display,window[winno],color_gcs[options.mono],
	    head1[winno].prev->x,head1[winno].prev->y,
	    head2[winno].prev->x,head2[winno].prev->y);
}

void draw_qix4(int winno)
{ 
  
  XDrawLine(display,window[winno],color_gcs[head1[winno].next->pixel],
	    head1[winno].next->x,head1[winno].next->y,
	    head2[winno].next->x,head2[winno].next->y);
  XDrawLine(display,window[winno],color_gcs[head1[winno].next->pixel],
	    CX[winno]-head1[winno].next->x,head1[winno].next->y,
	    CX[winno]-head2[winno].next->x,head2[winno].next->y);
  XDrawLine(display,window[winno],color_gcs[head1[winno].next->pixel],
	    head1[winno].next->x,CY[winno]-head1[winno].next->y,
	    head2[winno].next->x,CY[winno]-head2[winno].next->y);
  XDrawLine(display,window[winno],color_gcs[head1[winno].next->pixel],
	    CX[winno]-head1[winno].next->x,CY[winno]-head1[winno].next->y,
	    CX[winno]-head2[winno].next->x,CY[winno]-head2[winno].next->y);

  XDrawLine(display,window[winno],color_gcs[options.mono],
	    head1[winno].prev->x,head1[winno].prev->y,
	    head2[winno].prev->x,head2[winno].prev->y);
  XDrawLine(display,window[winno],color_gcs[options.mono],
	    CX[winno]-head1[winno].prev->x,head1[winno].prev->y,
	    CX[winno]-head2[winno].prev->x,head2[winno].prev->y);
  XDrawLine(display,window[winno],color_gcs[options.mono],
	    head1[winno].prev->x,CY[winno]-head1[winno].prev->y,
	    head2[winno].prev->x,CY[winno]-head2[winno].prev->y);
  XDrawLine(display,window[winno],color_gcs[options.mono],
	    CX[winno]-head1[winno].prev->x,CY[winno]-head1[winno].prev->y,
	    CX[winno]-head2[winno].prev->x,CY[winno]-head2[winno].prev->y);
}

void draw_bozo(int winno)
{
  /* draw the bozogon (actually just a quadrilateral,
  ** but that's not as fun a name as 'bozogon' 
  */

  XDrawLines(display,window[winno],color_gcs[head1[winno].next->pixel],
	     make_bozo(head1[winno].next->x,head1[winno].next->y,
		       head2[winno].next->x,head2[winno].next->y,
		       head3[winno].next->x,head3[winno].next->y,
		       head4[winno].next->x,head4[winno].next->y),
	     5,CoordModeOrigin);
  /* and erase the last one */
  XDrawLines(display,window[winno],color_gcs[options.mono],
	     make_bozo(head1[winno].prev->x,head1[winno].prev->y,
		       head2[winno].prev->x,head2[winno].prev->y,
		       head3[winno].prev->x,head3[winno].prev->y,
		       head4[winno].prev->x,head4[winno].prev->y),
	     5,CoordModeOrigin);
}

void draw_bez(int winno)
{
  /* draw a Bezier curve (4 control points, 21 points on the curve */

  XDrawLines(display,window[winno],color_gcs[head1[winno].next->pixel],
	     Bezier(make_bozo(head1[winno].next->x,head1[winno].next->y,
			      head2[winno].next->x,head2[winno].next->y,
			      head3[winno].next->x,head3[winno].next->y,
			      head4[winno].next->x,head4[winno].next->y),4),
	     21,CoordModeOrigin);
  /* and erase the last one */
  XDrawLines(display,window[winno],color_gcs[options.mono],
	     Bezier(make_bozo(head1[winno].prev->x,head1[winno].prev->y,
			      head2[winno].prev->x,head2[winno].prev->y,
			      head3[winno].prev->x,head3[winno].prev->y,
			      head4[winno].prev->x,head4[winno].prev->y),4),
	     21,CoordModeOrigin);
}


void draw_circ(int winno)
{
  /* ok, not a circle, a 32-gon... close 'nuff */		  

  XDrawLines(display,window[winno],color_gcs[head1[winno].next->pixel],
	     make_circle(head1[winno].next->x,head1[winno].next->y,
			 head2[winno].next->x,head2[winno].next->y),
	     33,CoordModeOrigin);

  /* and erase the last one */

  XDrawLines(display,window[winno],color_gcs[options.mono],
	     make_circle(head1[winno].prev->x,head1[winno].prev->y,
			 head2[winno].prev->x,head2[winno].prev->y),
	     33,CoordModeOrigin);
}

void draw_boxes(int winno)
{ 
  /* draw the rectangles */
/*
   I USED to be able to just call 'XDrawRectangle', but apparently X11R5's
   version of that function doesn't deal with negative widths and heights.
   So I'm using XDrawLines and an extra XDrawLine *sigh*. If your
   XDrawRectangle works, uncomment them and use 'em
*/
/*
  XDrawRectangle(display,window[winno],color_gcs[head1[winno].next->pixel],
		 head1[winno].next->x,head1[winno].next->y,
		 head2[winno].next->x-head1[winno].next->x,
		 head2[winno].next->y-head1[winno].next->y );
*/
  XDrawLines(display,window[winno],color_gcs[head1[winno].next->pixel],
	     wrecked(head1[winno].next->x,head1[winno].next->y,
		     head2[winno].next->x,head2[winno].next->y),
	     4,CoordModeOrigin);
  XDrawLine(display,window[winno],color_gcs[head1[winno].next->pixel],
	    head1[winno].next->x,head1[winno].next->y,
	    head1[winno].next->x,head2[winno].next->y);
  
  /* and erase the last one */
/*
  XDrawRectangle(display,window[winno],color_gcs[options.mono],
  head1[winno].prev->x,head1[winno].prev->y,
  head2[winno].prev->x-head1[winno].prev->x,
  head2[winno].prev->y-head1[winno].prev->y );
  */
  XDrawLines(display,window[winno],color_gcs[options.mono],
	     wrecked(head1[winno].prev->x,head1[winno].prev->y,
		     head2[winno].prev->x,head2[winno].prev->y),
	     4,CoordModeOrigin);
  XDrawLine(display,window[winno],color_gcs[options.mono],
	    head1[winno].prev->x,head1[winno].prev->y,
	    head1[winno].prev->x,head2[winno].prev->y);

}

