/* retawq/parser.h - content parsing (HTML, ...)
   This file is part of retawq (<http://retawq.sourceforge.net/>), a network
   client created by Arne Thomassen; retawq is basically released under certain
   versions of the GNU General Public License and WITHOUT ANY WARRANTY.
   Read the file COPYING for license details, README for program information.
   Copyright (C) 2001-2005 Arne Thomassen <arne@arne-thomassen.de>
*/

#ifndef __retawq_parser_h__
#define __retawq_parser_h__

#include "stuff.h"
#include "resource.h"
#if CONFIG_JAVASCRIPT
#include "javascript.h"
#endif

/* begin-autogenerated */
enum
{ htkText = 0, /* a very special tag kind :-) */
  htkA = 1, htkAddress = 2, htkArea = 3, htkB = 4, htkBig = 5,
  htkBlockquote = 6, htkBody = 7, htkBr = 8, htkButton = 9, htkCaption = 10,
  htkCenter = 11, htkCite = 12, htkDd = 13, htkDel = 14, htkDfn = 15,
  htkDir = 16, htkDiv = 17, htkDl = 18, htkDt = 19, htkEm = 20,
  htkFieldset = 21, htkFont = 22, htkForm = 23, htkFrame = 24,
  htkFrameset = 25, htkH1 = 26, htkH2 = 27, htkH3 = 28, htkH4 = 29, htkH5 = 30,
  htkH6 = 31, htkHead = 32, htkHr = 33, htkHtml = 34, htkI = 35,
  htkIframe = 36, htkImg = 37, htkInput = 38, htkLi = 39, htkMenu = 40,
  htkMeta = 41, htkNoframes = 42, htkNoscript = 43, htkObject = 44, htkOl = 45,
  htkOptgroup = 46, htkOption = 47, htkP = 48, htkPre = 49, htkQ = 50,
  htkS = 51, htkScript = 52, htkSelect = 53, htkStrike = 54, htkStrong = 55,
  htkStyle = 56, htkSub = 57, htkSup = 58, htkTable = 59, htkTd = 60,
  htkTextarea = 61, htkTh = 62, htkTitle = 63, htkTr = 64, htkU = 65,
  htkUl = 66, 
  htkInvalid = 255
};
typedef unsigned char tHtmlTagKind;

my_enum1 enum
{ anUnknown = 0,
  anAction = 1, anAlign = 2, anAlt = 3, anChecked = 4, anColor = 5,
  anContent = 6, anDeclare = 7, anDisabled = 8, anEnctype = 9, anFace = 10,
  anHref = 11, anHttpEquiv = 12, anId = 13, anInternalTagname = 14,
  anInternalText = 15, anLabel = 16, anMaxlength = 17, anMethod = 18,
  anMultiple = 19, anName = 20, anReadonly = 21, anSelected = 22, anSize = 23,
  anSrc = 24, anTitle = 25, anType = 26, anValue = 27, anWidth = 28
/* #if CONFIG_CSS */
  , anClass = 29, anMedia = 30, anStyle = 31
/* #endif */
/* #if CONFIG_JAVASCRIPT */
  , anLanguage = 32
/* #endif */
} my_enum2(unsigned char) tAttributeName;
#define NUM_ATTRNAMES (33) /* (ignores anJavascript stuff) */
#if CONFIG_JAVASCRIPT
#define anJavascriptBegin (33)
#define is_an_for_javascript(an) ( ((an) >= anJavascriptBegin) && \
  ((an) <= anJavascriptBegin + JAVASCRIPT_MAX_EVENT_CODE) )
#endif
/* end-autogenerated */

typedef struct tAttribute
{ struct tAttribute* next;
  char* value;
  tAttributeName name;
} tAttribute;

my_enum1 enum
{ hnfNone = 0, hnfIsEndtag = 0x01, hnfTagblockEnds = 0x02,
  hnfStoredInTree = 0x04, hnfHasAeBase = 0x08, hnfAlignLeft = 0x10,
  hnfAlignCenter = 0x20, hnfAlignRight = 0x40, hnfGoodForm = 0x80
} my_enum2(unsigned char) tHtmlNodeFlags;
#define hnfAlignAny (hnfAlignLeft | hnfAlignCenter | hnfAlignRight)

typedef struct tHtmlNode
{ struct tHtmlNode* next;
  void* data; /* text (char*) or attribute list head (tAttribute*) */
  tHtmlNodeFlags flags;
  tHtmlTagKind kind;
} tHtmlNode;

#define aenum_incvalue(max) \
  ( ((max) >= 1000) ? 1000 : (((max) >= 100) ? 100 : 20) )

my_enum1 enum
{ hofNone = 0, hofSelected = 0x01, hofDisabled = 0x02, hofOptgroupStart = 0x04
} my_enum2(unsigned char) tHtmlOptionFlags;
typedef tHtmlInputLength tHtmlOptionNumber;

typedef struct tHtmlOption
{ struct tHtmlOption* next;
  char *value, *render;
  tHtmlOptionFlags flags;
} tHtmlOption;

extern void deallocate_html_node(const tHtmlNode*);
extern void deallocate_one_aebase(const tActiveElementBase*);

extern tBoolean htk_forbids_endtag(const tHtmlTagKind);
extern tBoolean htk_forbids_pre(const tHtmlTagKind);
extern tBoolean htk_is_block(const tHtmlTagKind);
extern tBoolean htk_is_par(const tHtmlTagKind);

extern void parser_html_start(tCantent*);
extern const tHtmlNode* parser_html_next(tBoolean);
extern void parser_html_finish(void);

extern void parser_initialize(void);

#endif /* #ifndef __retawq_parser_h__ */
