/*
 * Copyright (c) 2005 Aleksander Piotrowski <aleksander.piotrowski@nic.com.pl>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef ICB_H
#define ICB_H

#define ICB_VERSION "20050618"

#define OLD_GAIM

#define ICB_PACKET_SIZE     255
#define ICB_MAX_DATA_SIZE   230 /* XXX Max value is 252 *but* some servers
                                 * don't allow that big packets
                                 */
#define ICB_MAX_NO_FIELDS   20
#define ICB_NICKLEN         12
#define ICB_BUFSIZE         4096

#define ICB_SEPARATOR        '\001'
#define ICB_CMD_LOGIN         'a'
#define ICB_CMD_OPEN_MSG      'b'
#define ICB_CMD_PERSONAL_MSG  'c'
#define ICB_CMD_STATUS_MSG    'd'
#define ICB_CMD_ERROR         'e'
#define ICB_CMD_EXIT          'g'
#define ICB_CMD_COMMAND       'h'
#define ICB_CMD_COMMAND_RESP  'i'
#define ICB_CMD_PROTO_VERSION 'j'
#define ICB_CMD_MSG           'm'
#define ICB_CMD_WHO           'w'

#define ICB_STAT_JOIN "You are now in group"
#define ICB_STAT_JOIN_LEN 20
#define ICB_STAT_SIGNON "Sign-on"
#define ICB_STAT_SIGNON_LEN 7
#define ICB_STAT_SIGNOFF "Sign-off"
#define ICB_STAT_SIGNOFF_LEN 8
#define ICB_STAT_ARRIVE "Arrive"
#define ICB_STAT_ARRIVE_LEN 6
#define ICB_STAT_DEPART "Depart"
#define ICB_STAT_DEPART_LEN 6
#define ICB_NICK_CHANGE "Name"
#define ICB_NICK_CHANGE_LEN 4
#define ICB_STAT_BOOTED "Boot"
#define ICB_STAT_BOOTED_LEN 4
#define ICB_STAT_TOPIC "Topic"
#define ICB_STAT_TOPIC_LEN 5
#define ICB_STAT_PASS "Pass"
#define ICB_STAT_PASS_LEN 4 

#define ICB_TOPIC "Topic: "

#define ICB_CONNECT_STEPS   3

#define ICB_DEFAULT_SERVER "default.icb.net"
#define ICB_DEFAULT_PORT   7326
#define ICB_DEFAULT_GROUP  "1"

typedef struct {
	GaimAccount *account;
	int          fd;
	char        *server;
	char        *user;
	int          port;
	char        *group;
	int          chat_id;
} IcbSession;

typedef struct {
	int    length;
	char   command;
	char **fields;
	int    nof;
} IcbPacket;

#ifdef OLD_GAIM
static GList      *icb_status_types(GaimConnection *);
#else
static GList      *icb_status_types(GaimAccount *);
#endif
static void        icb_dump_packet(IcbPacket *);
static void        icb_free_packet(IcbPacket **);
static IcbPacket  *icb_parse_buf();
static void        icb_login_cb(gpointer, gint, GaimInputCondition);
static int         icb_send(IcbSession *, char, int, ...);
#ifdef OLD_GAIM
static void        icb_login(GaimAccount *);
#else
static void        icb_login(GaimAccount *, GaimStatus *);
#endif
static void        icb_close(GaimConnection *);
static void        icb_input_cb(gpointer, gint, GaimInputCondition);
static void        icb_dump_buf(char *, int);
static void        icb_join_chat(GaimConnection *, GHashTable *);
static void        icb_leave_chat(GaimConnection *, int);
static GList      *icb_chat_info(GaimConnection *);
static GHashTable *icb_chat_info_defaults(GaimConnection *, const char *);

#endif /* ICB_H */
