#ifndef _NAP_NAP_H
#define _NAP_HAP_H

/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#include <dirent.h>
#include "sscr.h"

/* for host addresses, need 32 bit integer type. Apparently on an
   alpha, a long has 64 bits, but maybe 16 bit ints still exist on
   some other machine?  Better to check. This is an improvement of 
   patch #403468, by Christoph Hebeisen. */

#ifndef int32
# if SIZEOF_INT==4
# define int32 int
# else
# define int32 long
# endif
#endif

extern int cloaked;  /* whether we are cloaked */

struct phead_s 
{
  unsigned short len;
  unsigned short op;
};
typedef struct phead_s phead_t;

/* the info structure contains certain global values that are set on
   the command line, prompted from the user, or read from the
   configuration file at startup. Some of these values can later be updated
   with user commands. */
struct info_s 
{
  char *user;            /* our Napster login name */
  char *pass;            /* our Napster password */
  char *email;           /* our Napster email address */
  char *up;              /* list of upload directories, separated by ";" */
  char *down;            /* a single download directory */
  int d;                 /* debug level */
  char *serverlist;      /* ';'-separated list of servers to connect to */
  char *logallfile;      /* name of general log file (or NULL) */
  char *logfile;         /* name of transfer log file (or NULL) */
  int maxuploads;        /* max number of simultaneous uploads */
  int autorestart;       /* auto reconnect when connection to server lost? */

  int port;              /* local port to use for incoming upload requests */
  int port_max;          /* if specified port busy, try others up to this */ 
  int conn;              /* connection speed 0-9 */
  char *shared_filename; /* name of shared library file */
  char *config_filename; /* name of configuration file */
  int daemon;            /* if !=0, run without user interface. When 1,
			    output to stdout, when 2, suppress output */
  int build;             /* 0=don't build, 1=build library, 2=build and exit */
  int create;            /* create new account? This is reset to 0 after acct created */
  int reconnect;         /* keep reconnecting until connection established? */
  int notop;             /* if set, display no title */
};
typedef struct info_s info_t;

/* alias.c supplies user-defined variables. We want certain of these
   variables to be hard-wired. The hard-wired variables are defined in
   the following structures. They usually correspond to elements of
   the info structure. The actual correspondence is defined in alias.c. */

struct hardwired_s {
  char *nm;       /* name of variable */
  int type;       /* 1 for read-write string, 2 for password (write-only) */
  char **strp;    /* pointer to string value */
  char *comment;  /* comment for this variable in config file */
};
typedef struct hardwired_s hardwired_t;

void ctrlc(int);
void doquit(void);
void tresize(int);
void sigint(int);
void dochecks(void);

int readcfg(char *);
void checkhotlist(int, char *);
int isshared(char *);
char *findent(FILE *, char *);
int msprintf(char **, char *, ...);
int strcnt(char *, char);
void phelp(char *);
void dopts(int, char **);
char *glistn(char *);
void savechans(chans_t *);
void loadchans(int);
void initssock(int);
int inssock(WINDOW *, sock_t *);
void checknv(char *, int, char *);
int rebuild(int, char *, char *);
int buildflist(char *, char *);
void dir(char *, FILE *);
void ddir(char *, DIR *, FILE *);
int lfiles(int, char *);
int32 resolve(char *);
int conn(char *, unsigned short);
int login(int, char *, char *, int, char *, int, char *);
int makeact(int, char *, char *, int, char *, int, char *);
int inipc(WINDOW *, sock_t *);
int inserv(WINDOW *, sock_t *);
unsigned char gchr(WINDOW *);
chans_t *findchan(chans_t *, char *);
chans_t *findquery(chans_t *, char *);
int sendpack(int, unsigned short, char *, ...);
int ssock(int, char *, ...);
int recvpack(int, char **, phead_t **);
int rsock(int, char **);
char *fxp(char *);
int gconn(WINDOW *, sock_t *);
int lsock(WINDOW *, sock_t *);
int doget(WINDOW *, sock_t *);
int dosend(WINDOW *, sock_t *);
int initfserv(int, int);
void closefserv(void);
int initsend(WINDOW *, sock_t *);
int ssize(WINDOW *, sock_t *);
int initget(WINDOW *, sock_t *);
int gsize(WINDOW *, sock_t *);
int sfile(WINDOW *, sock_t *);
int gfile(WINDOW *, sock_t *);

#endif /* not _NAP_NAP_H */
