/*
 * This is an implementation of the znum interface.  It uses the basic
 * "unsigned long int" which I do not bother to guard against possible
 * overflows.  You should only enable this if you want to build a
 * small-size shunt executable (around 10K).  You enable it by
 * disabling the BUILD_SHUNT_USING_LIBCALC macro in Config.mk.
 */

#include <limits.h>
#include <stdlib.h>
#include <stdio.h>
#include "../xposix/xposix.h"
#include "znum_basic_p.h"

extern void
znum_initialize(void)
{
    /* empty */
}

extern void
znum_finalize(void)
{
    /* empty */
}

extern znum_t
znum_new(void)
{
    znum_t zn = xcalloc(1, sizeof(*zn));
    zn->n = 0;
    return zn;
}

extern void
znum_delete(znum_t zn)
{
    free(zn);
}

extern void
znum_increment(znum_t zn)
{
    ++zn->n;
}

extern const char*
znum_as_string(znum_t zn)
{
    /* snprintf() if surprisingly non-portable.  Fortunately, we do
     * not a general interface.  Determining the length of integers as
     * strings is trivial: A number printed in binary is at least as
     * long (and usually longer) than the same number printed in
     * decimal. */
    char* rv = NULL;
    unsigned long int len = 0;
    len = sizeof(zn->n) * CHAR_BIT + 1;
    rv = xmalloc(len);
    sprintf(rv, "%lu", zn->n);
    return rv;
}

extern void
znum_delete_string(const char* s)
{
    free((void*)s);
}
