#include "drs.h"

/* Directory Record Structure */
typedef struct {
    unsigned char     length_of_extended_attribute_record;
    unsigned long int location_of_extent;
    unsigned long int data_length;
    unsigned char     years_since_1900;
    unsigned char     month;
    unsigned char     day;
    unsigned char     hour;
    unsigned char     minute;
    unsigned char     second;
    unsigned char     offset_from_GMT;
    unsigned char     file_flags;
    unsigned char     file_unit_size;
    unsigned char     interleave_gap_size;
    unsigned long int volume_sequence_number;
    unsigned char     length_of_file_identifier;
    char              file_identifier[256];
} dr_t;

struct drs {

    /* Array of directory descriptors. */
    dr_t* info;

    /* Count of the number of directory descriptors in the "info"
     * array. */
    size_t count;

    /* Current maximum count of the "info" array.  If the user tries
     * to push_back() another entry on the array.  The code will
     * realloc() the array and update this value. */
    size_t count_max;

    /* There are so many elements in the dr_t structure, I decided it
     * would just be easier when getting and setting values to have
     * the user change the "current" element.  Then all the get and
     * set methods would operate on that element. */
    size_t current;
};
