;; Copyright (C) 1996, 1997 Free Software Foundation, Inc.
;; 
;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public License
;; along with this software; see the file COPYING.  If not, write to
;; the Free Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111, USA.
;;
;; As a special exception, the Free Software Foundation gives permission
;; for additional uses of the text contained in its release of GUILE.
;;
;; The exception is that, if you link the GUILE library with other files
;; to produce an executable, this does not by itself cause the
;; resulting executable to be covered by the GNU General Public License.
;; Your use of that executable is in no way restricted on account of
;; linking the GUILE library code into it.
;;
;; This exception does not however invalidate any other reasons why
;; the executable file might be covered by the GNU General Public License.
;;
;; This exception applies only to the code released by the
;; Free Software Foundation under the name GUILE.  If you copy
;; code from other Free Software Foundation releases into a copy of
;; GUILE, as the General Public License permits, the exception does
;; not apply to the code that you add in this way.  To avoid misleading
;; anyone as to the status of such modified files, you must delete
;; this exception notice from them.
;;
;; If you write modifications of your own for GUILE, it is your choice
;; whether to permit this exception to apply to your modifications.
;; If you do not wish that, delete this exception notice.  

;;;; "bench.scm", Scheme benchmark computing digits of pi.
;;; Author: Aubrey Jaffer.

(require (in-vicinity (implementation-vicinity) "pi.scm"))
(require 'transcript)
(define isqrt
  (cond ((provided? 'inexact) sqrt)
	(else (require 'root) integer-sqrt)))
(define i/
  (cond ((provided? 'inexact) /)
	(else quotient)))
(define around
  (cond ((provided? 'inexact)
	 (lambda (x)
	   (cond ((>= 3000 (abs x) 3) (inexact->exact (round x)))
		 (else x))))
	(else identity)))

(define (time-pi digits)
  (let ((start-time (get-internal-run-time)))
    (pi digits 4)
    (i/ (* 1000 (- (get-internal-run-time) start-time))
       internal-time-units-per-second)))

(define (benchmark . arg)
  (define file
    (cond ((null? arg) "bench.log")
	  (else (car arg))))
  (do ((digits 50 (+ digits digits))
       (t 0 (time-pi (+ digits digits))))
      ((> t 3000)
       (do ((tl '() (cons (time-pi digits) tl))
	    (j 12 (+ -1 j)))
	   ((zero? j)
	    (let* ((avg (i/ (apply + tl) (length tl)))
		   (dev (isqrt (i/ (apply
				    + (map (lambda (x) (* (- x avg) (- x avg)))
						 tl))
				   (length tl)))))
	      (and file (transcript-on file))
	      (for-each display
			(list digits " digits took " (around avg) " mSec +/- "
			      (around dev) " mSec."))
	      (newline)
	      (let ((scaled-avg (i/ (* (i/ (* avg 1000) digits) 1000) digits)))
		(for-each display
			  (list " That is about " scaled-avg
				" mSec/k-digit^2 +/- "
				(around
				 (i/ (* 100 (i/ (* (i/ (* dev 1000) digits)
						   1000) digits))
				     scaled-avg))
				"%."))
		(newline)
		(and file (transcript-off)))
	      ))))))
(benchmark)
