#!/usr/bin/env python
# -*- coding: UTF-8 -*-

# Copyright 2006-2007 (C) Raster Software Vigo (Sergio Costas)
# Copyright 2006-2007 (C) Peter Gill - win32 parts

# This file is part of DeVeDe
#
# DeVeDe is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# DeVeDe is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import pygtk # for testing GTK version number
pygtk.require ('2.0')
import gtk
import gtk.glade
import pickle
import os

import devede_dialogs

class load_save_config:
	
	def __init__(self,gladefile,structure,global_vars):
		
		self.gladefile=gladefile
		self.structure=structure
		self.global_vars=global_vars
		
	def load(self):
		
		""" This method loads a configuration file """
		
		self.done = False
		
		if (len(self.structure)>1) or (len(self.structure[0])>1):
			w = devede_dialogs.ask_overwrite_onload(self.gladefile)
			retval = w.run()
			w = None
			if retval!=-5:
				return

		tree=gtk.glade.XML(self.gladefile,"wloadconfig",domain="devede")
		window = tree.get_widget("wloadconfig")
		
		filter = gtk.FileFilter()
		filter.add_pattern("*.devede")
		filter.set_name(".devede")
		window.add_filter(filter)
		
		window.show()
		retval = window.run()
		window.hide()
		if retval!=-5:
			window.destroy()
			window = None
			return
		
		file_name=window.get_filename()
		window.destroy()
		window = None
		
		try:
			output=open(file_name)
		except:
			w = devede_dialogs.show_error(self.gladefile,_("Can't open the file."))
			w = None
			return
	
		try:
			values=pickle.load(output)
		except:
			w = devede_dialogs.show_error(self.gladefile,_("That file doesn't contain a disc structure."))
			w = None
			return
		
		if values!="DeVeDe":
			w = devede_dialogs.show_error(self.gladefile,_("That file doesn't contain a disc structure."))
			w = None
			return
		
		global_vars2={}
		try:
			values=pickle.load(output)
			global_vars2=pickle.load(output)
		except:
			w = devede_dialogs.show_error(self.gladefile,_("That file doesn't contain a DeVeDe structure."))
			w = None
			return
	
		output.close()
		
		not_found=[]
		for element in values:
			for element2 in element[1:]:
				if False==element2.has_key("copy_sound"):
					element2["copy_audio"]=False # for backward compatibility
				if False==element2.has_key("sound51"):
					element2["sound51"]=False # for backward compatibility
				if False==element2.has_key("gop12"):
					element2["gop12"]=False # for backward compatibility
				try:
					v=os.stat(element2["path"])
				except:
					not_found.append(str(element2["path"]))
	
		if len(not_found)!=0:
			t_string=_("Can't find the following movie files. Please, add them and try to load the disc structure again.\n")
			for element in not_found:
				t_string+="\n"+element
			w = devede_dialogs.show_error(self.gladefile,t_string)
			w = None
			return
		
		try:
			os.stat(global_vars2["menu_bg"])
		except:
			w = devede_dialogs.show_error(self.gladefile,_("Can't find the menu background. I'll open the disc structure anyway with the default menu background, so don't forget to fix it before creating the disc."))
			w = None
			global_vars2["menu_bg"]=self.global_vars["path"]+"background.png"

		while (len(self.structure)>0):
			self.structure.pop()
		
		for element in values:
			self.structure.append(element)
		for element in global_vars2:
			self.global_vars[element]=global_vars2[element]
		
		self.global_vars["struct_name"]=file_name # update the path
		
		self.done = True


	def save(self,mode):
	
		""" This method stores the current disk structure in a file. If MODE is True,
			it will ask before a new name. If it's False and there's a filename
			(from a previous save), it will overwrite the old file """
	
		if mode or (self.global_vars["struct_name"]==""):
			tree=gtk.glade.XML(self.gladefile,"wsaveconfig",domain="devede")
			saveconfig=tree.get_widget("wsaveconfig")
			
			filter=gtk.FileFilter()
			filter.add_pattern("*.devede")
			filter.set_name(".devede")
			saveconfig=tree.get_widget("wsaveconfig")
			saveconfig.add_filter(filter)
			saveconfig.set_do_overwrite_confirmation(True)

			saveconfig.show()
			value=saveconfig.run()
			saveconfig.hide()
			if value!=-5:
				saveconfig.destroy()
				saveconfig=None
				return
			fname=saveconfig.get_filename()
			saveconfig.destroy()
			saveconfig=None
			
			if fname==None:
				w=devede_dialogs.show_error(self.gladefile,_("No filename"))
				w=None
				return

			if (len(fname)<7) or (fname[-7:]!=".devede"):
				fname+=".devede"

			self.global_vars["struct_name"]=fname
		
		try:
			output=open(self.global_vars["struct_name"],"wb")
			id="DeVeDe"
			pickle.dump(id,output)
			pickle.dump(self.structure,output)
			vars={}
			vars["disctocreate"]=self.global_vars["disctocreate"]
			vars["titlecounter"]=self.global_vars["titlecounter"]
			vars["do_menu"]=self.global_vars["do_menu"]
			vars["menu_widescreen"]=self.global_vars["menu_widescreen"]
			vars["PAL"]=self.global_vars["PAL"]
			vars["menu_bg"]=self.global_vars["menu_bg"]
			vars["menu_PAL"]=self.global_vars["menu_PAL"]
			vars["struct_name"]=self.global_vars["struct_name"]
			vars["fontname"]=self.global_vars["fontname"]
			pickle.dump(vars,output)
			output.close()
		except:
			w=devede_dialogs.show_error(self.gladefile,_("Can't save the file."))
			w=None

