/* $Id: script.cc,v 1.4 2001/10/24 11:10:22 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2001 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "script.h"
#include "global.h"

ScriptList::ScriptList() : ModalDialog("Script List") {
  GtkWidget *v,*sw,*bh;
  int i;

  SelectedRow=-1;
  
  gtk_window_set_default_size(GTK_WINDOW(widget),350,300);

  v=gtk_vbox_new(FALSE,0);
  gtk_container_add(GTK_CONTAINER(widget),v);

  sw=gtk_scrolled_window_new(0,0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
				 GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);

  clist=gtk_clist_new(2);
  gtk_clist_set_shadow_type(GTK_CLIST(clist),GTK_SHADOW_IN);
  gtk_clist_set_selection_mode(GTK_CLIST(clist),GTK_SELECTION_SINGLE);
  gtk_clist_set_column_title(GTK_CLIST(clist),0,"Script");
  gtk_clist_set_column_title(GTK_CLIST(clist),1,"Description");
  gtk_clist_column_titles_passive(GTK_CLIST(clist));
  gtk_clist_column_titles_show(GTK_CLIST(clist));

  gtk_box_pack_start(GTK_BOX(v),sw,TRUE,TRUE,0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
                                 GTK_POLICY_AUTOMATIC,
                                 GTK_POLICY_AUTOMATIC);
  gtk_container_add(GTK_CONTAINER(sw),clist);

  for(i=0;i<2;i++)
    gtk_clist_set_column_min_width(GTK_CLIST(clist),i,96);

  bh=gtk_hbox_new(TRUE,0);
  gtk_box_pack_start(GTK_BOX(v),bh,FALSE,FALSE,0);

  b[0]=gtk_button_new_with_label("Refresh List");
  b[1]=gtk_button_new_with_label("Run");
  b[2]=gtk_button_new_with_label("Dismiss");

  for(i=0;i<3;i++) {
    gtk_box_pack_start(GTK_BOX(bh),b[i],FALSE,TRUE,0);
    gtk_widget_show(b[i]);
  }

  gtk_widget_set_sensitive(b[1],FALSE);

  gtk_widget_show(bh);
  gtk_widget_show(clist);
  gtk_widget_show(sw);
  gtk_widget_show(v);

  gtk_signal_connect(GTK_OBJECT(b[0]),"clicked",
		     GTK_SIGNAL_FUNC(script_refresh),(gpointer)this);
  gtk_signal_connect(GTK_OBJECT(b[1]),"clicked",
		     GTK_SIGNAL_FUNC(script_run),(gpointer)this);

  setDismiss(GTK_OBJECT(b[2]),"clicked");

  gtk_signal_connect(GTK_OBJECT(clist),"select_row",
		     GTK_SIGNAL_FUNC(script_select),(gpointer)this);
  gtk_signal_connect(GTK_OBJECT(clist),"unselect_row",
		     GTK_SIGNAL_FUNC(script_unselect),(gpointer)this);

  refresh();
}

void ScriptList::refresh() {
  DIR *sd;
  char *p, z[256],w[256],desc[256],tmp[512],*dp[2];
  struct dirent *de;
  struct stat statd;
  mode_t mode;
  FILE *f;

  gtk_clist_freeze(GTK_CLIST(clist));
  gtk_clist_clear(GTK_CLIST(clist));

  p=getenv("HOME");
  if (p) {
    sprintf(z,"%s/.eboard/scripts",p);
    sd=opendir(z);
    if (sd) {
      while(de=readdir(sd)) {
	sprintf(tmp,"%s/%s",z,de->d_name);
	if (!stat(tmp,&statd)) {	  
	  mode=statd.st_mode;
	  if (S_ISREG(mode)&&(mode&(S_IRUSR|S_IXUSR)))
	    if (geteuid()==statd.st_uid) {
	      strncpy(w,de->d_name,255);
	      // grab description
	      f=fopen(tmp,"r");
	      if (!f) continue;
	      if (fgetc(f)!='#') {
		fclose(f);
		desc[0]=0;
	      } else {
		fgets(desc,255,f);
		do {
		  if (!fgets(desc,255,f))
		    break;
		} while(desc[0]!='#');
		fclose(f);
		if (desc[0]=='#') {
		  strcpy(tmp,desc);
		  strcpy(desc,tmp+1);
		  desc[strlen(desc)-1]=0;
		} else {
		  desc[0]=0;
		}
	      }
	      dp[0]=w;
	      dp[1]=desc;
	      gtk_clist_append(GTK_CLIST(clist),dp);
	    }
	}
      }
      closedir(sd);
    }
  }
  gtk_clist_thaw(GTK_CLIST(clist));
}

void script_refresh (GtkWidget * w, gpointer data) {
  ScriptList *me;
  me=(ScriptList *)data;
  me->refresh();
}

void script_run (GtkWidget * w, gpointer data) {
  ScriptList *me;
  char *z;
  me=(ScriptList *)data;
  gtk_clist_get_text(GTK_CLIST(me->clist),me->SelectedRow,0,&z);
  new ScriptInstance(z);
  me->release();
}

void script_select  (GtkCList *cl, gint row, gint column, GdkEventButton *eb,
		     gpointer data) {
  ScriptList *me;
  me=(ScriptList *)data;
  me->SelectedRow=row;
  gtk_widget_set_sensitive(me->b[1],TRUE);

}

void script_unselect(GtkCList *cl, gint row, gint column, GdkEventButton *eb,
		     gpointer data) {
 ScriptList *me;
  me=(ScriptList *)data;
  me->SelectedRow=-1;
  gtk_widget_set_sensitive(me->b[1],FALSE);
}

// -------------------------

ScriptInstance::ScriptInstance(char *name) : WidgetProxy() {
  GtkWidget *v,*l,*h,*k;
  char z[256],fp[512],*p;
  FILE *f;

  p=getenv("HOME");
  if (!p) {
    delete this;
    return;
  }
  sprintf(fp,"%s/.eboard/scripts/%s",p,name);

  f=fopen(fp,"r");
  if (!f) {
    delete this;
    return;
  }
  fclose(f);

  child=new PipeConnection("/bin/sh","-c",fp,0,0);
  child->Quiet=1;
  if (child->open()) {
    delete child;
    delete this;
    return;
  }
  global.addAgent(child);

  widget=gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(widget),"Script");
  gtk_window_set_position(GTK_WINDOW(widget),GTK_WIN_POS_CENTER);
  gtk_container_set_border_width(GTK_CONTAINER(widget),6);
  gtk_widget_realize(widget);

  sprintf(z,"Script %s running",name);

  v=gtk_vbox_new(FALSE,4);
  l=gtk_label_new(z);
  k=gtk_button_new_with_label("Kill");
  h=gtk_hbox_new(FALSE,2);
  
  gtk_container_add(GTK_CONTAINER(widget),v);
  gtk_box_pack_start(GTK_BOX(v),l,FALSE,FALSE,2);
  gtk_box_pack_start(GTK_BOX(v),h,FALSE,FALSE,2);
  gtk_box_pack_end(GTK_BOX(h),k,FALSE,FALSE,2);

  gtk_signal_connect(GTK_OBJECT(widget),"delete_event",
		     GTK_SIGNAL_FUNC(scripti_delete),(gpointer)this);
  gtk_signal_connect(GTK_OBJECT(k),"clicked",
		     GTK_SIGNAL_FUNC(scripti_kill),(gpointer)this);

  gtk_widget_show(k);
  gtk_widget_show(h);
  gtk_widget_show(l);
  gtk_widget_show(v);

  toid=gtk_timeout_add(500,scripti_check,(gpointer)this);
  show();
}

gint scripti_delete (GtkWidget * widget, GdkEvent * event, gpointer data) {
  return TRUE;
}

void scripti_kill(GtkWidget *w,gpointer data) {
  ScriptInstance *me;
  me=(ScriptInstance *)data;
  gtk_timeout_remove(me->toid);
  global.removeAgent(me->child);
  me->child->close();
  gtk_widget_destroy(me->widget);
  delete me->child;
  delete me;
}

gboolean scripti_check(gpointer data) {
  ScriptInstance *me;
  me=(ScriptInstance *)data;
  if (! me->child->isConnected()) {
    scripti_kill(0,data);
    return FALSE;
  }
  return TRUE;
}
