/**
 * \file math_binominset.C
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Andr Pnitz
 *
 * Full author contact details are available in file CREDITS.
 */

#include <config.h>

#include "math_binominset.h"
#include "math_data.h"
#include "math_support.h"
#include "math_mathmlstream.h"


using std::max;
using std::auto_ptr;


MathBinomInset::MathBinomInset(bool choose)
	: choose_(choose)
{}


auto_ptr<InsetBase> MathBinomInset::doClone() const
{
	return auto_ptr<InsetBase>(new MathBinomInset(*this));
}


int MathBinomInset::dw() const
{
	int w = dim_.height() / 5;
	if (w > 15)
		w = 15;
	if (w < 6)
		w = 6;
	return w;
}


void MathBinomInset::metrics(MetricsInfo & mi, Dimension & dim) const
{
	ScriptChanger dummy(mi.base);
	cell(0).metrics(mi);
	cell(1).metrics(mi);
	dim.asc = cell(0).height() + 4 + 5;
	dim.des = cell(1).height() + 4 - 5;
	dim.wid = max(cell(0).width(), cell(1).width()) + 2 * dw() + 4;
	metricsMarkers2(dim);
	dim_ = dim;
}


void MathBinomInset::draw(PainterInfo & pi, int x, int y) const
{
	int m = x + dim_.width() / 2;
	ScriptChanger dummy(pi.base);
	cell(0).draw(pi, m - cell(0).width() / 2, y - cell(0).descent() - 3 - 5);
	cell(1).draw(pi, m - cell(1).width() / 2, y + cell(1).ascent()  + 3 - 5);
	mathed_draw_deco(pi, x, y - dim_.ascent(), dw(), dim_.height(), "(");
	mathed_draw_deco(pi, x + dim_.width() - dw(), y - dim_.ascent(),
		dw(), dim_.height(), ")");
	drawMarkers2(pi, x, y);
}


void MathBinomInset::write(WriteStream & os) const
{
	if (choose_)
		os << '{' << cell(0) << " \\choose " << cell(1) << '}';
	else
		os << "\\binom{" << cell(0) << "}{" << cell(1) << '}';
}


void MathBinomInset::normalize(NormalStream & os) const
{
	os << "[binom " << cell(0) << ' ' << cell(1) << ']';
}
