#!/bin/sh

# little script to generate root.c from the actual root 
# nameserver data
# (c) NLnet Labs,  2004
# See the file LICENSE for the license

# 
# depends on dig, awk, egrep

# header of the file
cat <<EOF
/* root.c
 * contains the root nameservers in a t_rr struct
 * The struct is global
 *
 * (c) NLnet Labs 2004
 *
 * See the file LICENSE for the license
 */

#include "common.h"

struct t_rr *root_servers;

/**
 * Fills the root nameserver list
 */
int 
fill_root(void)
{
	struct t_rdata *rdata_root = rdata_create((uint8_t*)".",1);       
        root_servers = ns_create(rdata_root,
		(uint8_t*) A_ROOT, TYPE_A); /* A root */
	rdata_destroy(rdata_root);
EOF
# now the nameservers
# there is no IPv6 in the root, yet...
dig +nocmd +noanswer +nocomments +bufsize=4096 @a.root-servers.net. NS . | \
egrep '^[A-Za]' | sort | tail -n 12 | \
awk '{ print "\troot_servers = ns_add_ip(root_servers,(uint8_t*)\"" $5 "\", TYPE_A);" }'
echo -e "\treturn RET_SUC;"
echo "}"
