/***************************************************************************
                           main.cpp  -  description
                             -------------------
    begin                : Tue Feb 12 00:09:29 EST 2002
    copyright            : (C) 2002 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kdebug.h>

#include "flashkard.h"

static const char *description = I18N_NOOP("FlashKard");
	
	
static KCmdLineOptions options[] =
{
  { "+[file(s)]", I18N_NOOP("File(s) to open"), 0 },
  { 0, 0, 0 }
};

int main(int argc, char *argv[])
{
  
  KAboutData aboutData( "flashkard", I18N_NOOP("FlashKard"),
			"1.0", description, KAboutData::License_GPL,
			"(c) 2002, Scott Wheeler", 0, "http://edu.kde.org/flashkard/");

  aboutData.addAuthor("Scott Wheeler", 0, "wheeler@kde.org");
  KCmdLineArgs::init(argc, argv, &aboutData);
  KCmdLineArgs::addCmdLineOptions(options);

  KApplication a;
  FlashKard *flashkard = new FlashKard();
  a.setMainWidget(flashkard);
  flashkard->show();  

  return a.exec();
}
