/* GtkamlState.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#ifndef __GTKAMLSTATE_H__
#define __GTKAMLSTATE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "GtkamlClassDefinition.h"
#include "GtkamlAttribute.h"

G_BEGIN_DECLS


#define GTKAML_TYPE_STATE_ID (gtkaml_state_id_get_type ())

#define GTKAML_TYPE_STATE (gtkaml_state_get_type ())
#define GTKAML_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_STATE, GtkamlState))
#define GTKAML_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_STATE, GtkamlStateClass))
#define GTKAML_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_STATE))
#define GTKAML_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_STATE))
#define GTKAML_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_STATE, GtkamlStateClass))

typedef struct _GtkamlState GtkamlState;
typedef struct _GtkamlStateClass GtkamlStateClass;
typedef struct _GtkamlStatePrivate GtkamlStatePrivate;

typedef enum  {
	GTKAML_STATE_ID_SAX_PARSER_INITIAL_STATE = 0,
	GTKAML_STATE_ID_SAX_PARSER_CONTAINER_STATE,
	GTKAML_STATE_ID_SAX_PARSER_ATTRIBUTE_STATE
} GtkamlStateId;

/* here we generate the class declaration, based on current tag, attributes and namespaces 
 then we can add things to the current container, based on current tag and attributes 
 the characters are then used as value, string literal - we need the current instance.property */
struct _GtkamlState {
	GObject parent_instance;
	GtkamlStatePrivate * priv;
};

struct _GtkamlStateClass {
	GObjectClass parent_class;
};


GType gtkaml_state_id_get_type (void);
GtkamlState* gtkaml_state_new (GtkamlStateId state_id, GtkamlClassDefinition* class_definition, GtkamlAttribute* attribute, const char* attribute_name);
GtkamlStateId gtkaml_state_get_state_id (GtkamlState* self);
void gtkaml_state_set_state_id (GtkamlState* self, GtkamlStateId value);
GtkamlClassDefinition* gtkaml_state_get_class_definition (GtkamlState* self);
void gtkaml_state_set_class_definition (GtkamlState* self, GtkamlClassDefinition* value);
GtkamlAttribute* gtkaml_state_get_attribute (GtkamlState* self);
void gtkaml_state_set_attribute (GtkamlState* self, GtkamlAttribute* value);
const char* gtkaml_state_get_attribute_name (GtkamlState* self);
void gtkaml_state_set_attribute_name (GtkamlState* self, const char* value);
GType gtkaml_state_get_type (void);


G_END_DECLS

#endif
