/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *
 *	$Id: lamspawn.c,v 6.4.2.1 2002/10/09 19:49:11 brbarret Exp $
 *
 *	Function:	- collect real IDX and PID from spawned processes
 *			- allows spawning of non-MPI jobs, scripts/debuggers
 *			- when MPI prog is finally launched, sends back 
 *                        this info
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <app_mgmt.h>
#include <app_schema.h>
#include <args.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <ndi.h>
#include <net.h>
#include <portable.h>
#include <rpisys.h>
#include <sfh.h>
#include <terror.h>
#include <typical.h>
#include <debug.h>
#include <lam_config.h>


/*
 *	lam_get_mpi_world
 *
 *	Function:	- get MPI world
 *	Accepts:	- size of world
 *			- initial process world
 *			- MPI process world (out)
 *			- string prefix to print in error message
 *	Returns:	- full pathname or NULL
 */
int
lam_get_mpi_world(int4 world_n, struct _gps *world, struct _gps *mpiworld,
		  char *prefix)
{
    struct nmsg		msg;
    int			i;
    int			j;

    memcpy(mpiworld, world, world_n * sizeof(struct _gps));
    for (i = 0; i < world_n; i++) {
	mpiworld[i].gps_pid = 0;
    }

    LAM_ZERO_ME(msg);
    msg.nh_event = (-getpid()) & 0xBFFFFFFF;
    msg.nh_length = 0;
    msg.nh_flags = DINT4DATA;

    for (i = 0; i < world_n; i++) {
	msg.nh_type = 3;
	if (nrecv(&msg)) {
	    terror("mpirun");
	    return(LAMERROR);
	}

	if (msg.nh_type == 1) {
	    fprintf(stderr, 
		    "%s: process terminated before completing MPI_Init()\n",
		    prefix);
	    return(LAMERROR);
	}
/*
 * Set the MPI process pid and index.
 */
	j = msg.nh_data[0];
	if (j < 0 || j >= world_n) {
	    errno = EIMPOSSIBLE;
	    terror("mpirun");
	    return(LAMERROR);
	}

	mpiworld[j].gps_pid = msg.nh_data[1];
	mpiworld[j].gps_idx = msg.nh_data[2];
    }

    return(0);
}
