/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: kinit.c,v 6.7.2.1 2002/10/09 19:49:04 brbarret Exp $
 *
 *	Function:	- initializes data structures for kernel interface
 *			- calls kattach()
 *			- based on Trollius 2.0 Copyright 1990
 *			  The Ohio State University and Cornell Research
 *			  Foundation
 *	Accepts:	- scheduling priority
 */

#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>

#include <freq.h>
#include <kio.h>
#include <kreq.h>
#include <ktrace.h>
#include <net.h>
#include <typical.h>

/*
 * external data structures
 */
extern struct kio_t	_kio;		/* Kernel I/O block */
extern struct fclient	_ufd[FUMAX];	/* user file desc. */

/*
 * external functions
 */
extern int		_cipc_init();	/* initialize kernel I/O */
extern void		_ksig_init();	/* initialize signals */
extern void		_vcfree();	/* free v.c. table */


int
kinit(int priority)
{
    int		i;		/* favourite index */

    if (_kio.ki_pid != getpid()) {
	LAM_ZERO_ME(_kio);
/*
 * Initialize signal handling module.
 */
	_ksig_init();
/*
 * Initialize the exit table.
 */
	for (i = 0; i < TNEXIT; ++i) {
	    _kio.ki_exit[i] = (void (*)()) 0;
	}
/*
 * Initialize route cache.
 */
	for (i = 0; i < MAXRCACHE; ++i) {
	    _kio.ki_route[i].r_nodeid = NOTNODEID;
	}

	_kio.ki_nodeid = NOTNODEID;
	_kio.ki_origin = NOTNODEID;
	_kio.ki_index = -1;
	_kio.ki_jobid.jid_node = getnodeid();
	_kio.ki_jobid.jid_pid = getpid();
/*
 * Free the virtual circuit table.
 */
	if (_kio.ki_pid < 0) {
	    _vcfree();
	}
/*
 * Initialize kernel request interface.
 */
	if (_cipc_init()) {
	    return(LAMERROR);
	}
/*
 * Initialize user file descriptor table
 */
	for (i = 0; i < FUMAX; ++i) {
	    _ufd[i].fu_tflags = 0;
	}

	_ufd[0].fu_tflags = LAM_O_RDONLY | LAM_O_1WAY;
	_ufd[0].fu_node = _kio.ki_ionode;
	_ufd[0].fu_tfd = _kio.ki_stdin;
	_ufd[1].fu_tflags = LAM_O_WRONLY | LAM_O_1WAY;
	_ufd[1].fu_node = _kio.ki_ionode;
	_ufd[1].fu_tfd = _kio.ki_stdout;
	_ufd[2].fu_tflags = LAM_O_WRONLY | LAM_O_1WAY;
	_ufd[2].fu_node = _kio.ki_ionode;
	_ufd[2].fu_tfd = _kio.ki_stderr;

	atkexit(rfatexit, (char *) 0);
/*
 * Attach process to the kernel.
 */
	if (kattach(priority)) {
	    return(LAMERROR);
	}
/*
 * Initialize the trace subsystem.
 */
	if (_kio.ki_rtf & RTF_TRACE) {
	    lam_trinit();
	}

	return(0);
    }

    else {
/*
 * Attach process to the kernel.
 */
	return(kattach(priority));
    }
}
