/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *
 *	$Id: rpi_lamd.h,v 6.1.2.1 2002/10/09 19:49:00 brbarret Exp $
 *
 *	Function:	- RPI implementation for LAM daemon
 *			- constants and templates
 */

#ifndef _RPI_LAMD_H
#define _RPI_LAMD_H

#include <net.h>

/*
 * lamd request
 */
struct lamd_req {
	struct nmsg	lmq_msg_data;		/* data LAM message */
	struct nmsg	lmq_msg_ack;		/* ack LAM message */
	struct nmsg	lmq_msg_ger;		/* GER LAM message */
	int		lmq_state;		/* progress state */
	int		lmq_flags;		/* misc. flags */
	int		lmq_ndata;		/* #bytes to ship */
	int		lmq_ndata_moved;	/* #bytes shipped */
};

/*
 * lamd request states
 */
#define LAMD_START	0			/* no communication yet */
#define LAMD_ACK	1			/* ship ack next */
#define LAMD_TAIL	2			/* shipping data tail */
#define LAMD_GER	4			/* GER protocol */
#define LAMD_DONE	3			/* completed */

/*
 * lamd request flags
 */
#define LAMD_RECVMODE	1			/* recv or probe */
#define LAMD_SSEND	2			/* msg is synchronous */

/*
 * polling defaults
 */
#ifndef MPIL_LPD_BASE
#define MPIL_LPD_BASE	50000
#endif

#ifndef MPIL_LPD_MAX
#define MPIL_LPD_MAX	1000000
#endif

/*
 * public functions
 */
int			_rpi_lamd_init(void);
int			_rpi_lamd_addprocs(void);
int			_rpi_lamd_build(MPI_Request req);
int			_rpi_lamd_start(MPI_Request req_top,
					MPI_Request req);
int			_rpi_lamd_destroy(MPI_Request req);
int			_rpi_lamd_advance(MPI_Request req_top,
					  int flag_block);
int			_rpi_lamd_iprobe(MPI_Request req);
int			_rpi_lamd_finalize(struct _proc	*p);


#endif	/* _RPI_LAMD_H */
