/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *
 *	$Id: lamnet.h,v 6.6.2.1 2002/10/09 19:48:59 brbarret Exp $
 * 
 *	Function:	- LAM network description
 */

#ifndef _LAMNET
#define _LAMNET

#include <lam_config.h>
#include <sys/types.h>
#include <netinet/in.h>

#include <portable.h>

/*
 * default filenames
 */
#define DEFFBHOST	"lam-bhost.def"	/* default host file */

/*
 * default search paths
 */
#ifndef DEFPBHOST
#define DEFPBHOST	"/tmp/lam/boot"	/* default boot directory */
#endif

/*
 * default tools
 */
#define DEFTHBOOT	"hboot"
#define DEFTTKILL	"tkill"
#define DEFTWIPE	"wipe"

/*
 * node description
 */
struct lamnode {			/* node information */
	int4		lnd_nodeid;	/* node identifier */
	int4		lnd_type;	/* node type */
	int4		lnd_ncpus;	/* number of CPUs on node */
	int		lnd_bootport;	/* booting port # */
	char		*lnd_hname;	/* host name */
	char		*lnd_uname;	/* user name */
	struct sockaddr_in
			lnd_addr;	/* internet address */
};

#ifdef __cplusplus
extern "C" {
#endif

extern int		lamnet_dups __ARGS((struct lamnode *lamnet,
					int nlamnet, int *pdup));
extern int		lamnet_findhosts __ARGS((struct lamnode *lamnet,
					int nlamnet, int *badhost));
extern int		lamnet_findorig __ARGS((struct lamnode *lamnet,
					int nlamnet));

#ifdef __cplusplus
}
#endif

#endif	/* _LAMNET */
