/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *
 *      Revision 6.2  1999/03/17 14:19:40  jsquyres
 *
 *      Revision 6.1  1996/11/23 21:55:04  nevin
 *      Ohio Release
 *
 * Revision 6.0  96/02/29  13:53:28  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/02/18  01:26:58  gdburns
 * major overhaul
 * 
 * Revision 5.2  94/08/22  14:00:37  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:44:28  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:48:55  gdburns
 * Ohio Release
 * 
 *	Function:	- constants and templates associated with the
 *			  runtime trace system
 */

#ifndef _KTRACE
#define _KTRACE

#include <lam_config.h>
#include <portable.h>

/*
 * trace header
 */
struct trhead {
	char		*trh_buf;	/* trace buffer ptr */
	int4		trh_length;	/* trace buffer length */
};

/*
 * constants
 */
#define TRHMAX		4		/* TRHMAX * MAXNMSGLEN = len limit */
#define TRHQUAN		2		/* TRHQUAN * MAXNMSGLEN = alloc hunk */

#ifdef __cplusplus
extern "C" {
#endif

extern char		*lam_trpoint __ARGS((int4 size));
extern void		lam_trexit __ARGS((void));
extern void		lam_trinit __ARGS((void));
extern void		lam_trunload __ARGS((void));

#ifdef __cplusplus
}
#endif

#endif	/* _KTRACE */
