/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *
 *	$Id: show_version.c,v 1.3.2.2 2002/10/09 19:48:52 brbarret Exp $
 * 
 *	Function:	- show the version of LAM/MPI
 *
 */

#include <lam_config.h>

#include <stdio.h>

#include <etc_misc.h>

void
lam_show_version(int verbose)
{
  printf("\nLAM %s", LAM_VERSION);
#if LAM_WANT_IMPI
  printf("/IMPI");
#endif
#if LAM_WANT_MPI2CPP
  printf("/MPI 2 C++");
#endif
#if LAM_WANT_ROMIO
  printf("/ROMIO");
#endif
  printf(" - Indiana University\n\n");
  if (verbose == 1) {
    printf("\tArch:\t\t%s\n", LAM_ARCH);
    printf("\tRPI:\t\t%s\n", LAM_RPI);
  }
}
