/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD
 *
 *	$Id: getinetaddr.c,v 1.1.2.1 2002/10/09 19:48:51 brbarret Exp $
 * 
 *	Function:	- return the machine Internet address (OTB only)
 *			- address is a 4-byte array
 *	Accepts:	- machine name
 *			- 4-byte machine address (returned value)
 *	Returns:	- 0 or ERROR
 */

#include <string.h>

#include <netdb.h>
#include <portable.h>
#include <terror.h>
#include <typical.h>

int
getinetaddr(hostname, hostaddr)

char			*hostname;
unsigned char		*hostaddr;

{
	struct hostent	*p;
/*
 * Get host name entry.
 */
	p = gethostbyname(hostname);

	if (p == 0) {
		errno = EBADHOST;
		return(LAMERROR);
	}
/*
 * Copy the 4-byte Internet address.
 */
	if (p->h_length == 4) {
		memcpy((char *) hostaddr, p->h_addr, 4);
	}
/*
 * Not an Internet address.  Do nothing for now, it's an error.
 */
	else {
		errno = EINVAL;
		return(LAMERROR);
	}

	return(0);
}
