// -*- c++ -*-
//
// $Id: pintracomm.h,v 1.1.1.1.2.1 2001/10/29 04:33:22 bbarrett Exp $
//
// Copyright 1997-2001, University of Notre Dame.
// Authors: Jeffrey M. Squyres, Jeremy G. Siek, Michael P. McNally, and
//          Andrew Lumsdaine
// 
// This file is part of the Notre Dame C++ bindings for MPI.
// 
// You should have received a copy of the License Agreement for the Notre
// Dame C++ bindings for MPI along with the software; see the file
// LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN 46556.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted subject to the conditions specified in the
// LICENSE file.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
// IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
// 
// Additional copyrights may follow.
//

class Intracomm : public Comm {
public:
  // construction
  Intracomm() { }
  // copy
  Intracomm(const Intracomm& data) : Comm(data) { }
  
  // inter-language operability
  inline Intracomm(const MPI_Comm& data);

  //
  // Collective Communication
  //

  virtual void Barrier() const;

  virtual void Bcast(void *buffer, int count, 
		     const Datatype& datatype, int root) const;

  virtual void Gather(const void *sendbuf, int sendcount, 
		      const Datatype & sendtype, 
		      void *recvbuf, int recvcount, 
		      const Datatype & recvtype, int root) const;
  
  virtual void Gatherv(const void *sendbuf, int sendcount, 
		       const Datatype & sendtype, void *recvbuf, 
		       const int recvcounts[], const int displs[], 
		       const Datatype & recvtype, int root) const;
  
  virtual void Scatter(const void *sendbuf, int sendcount, 
		       const Datatype & sendtype, 
		       void *recvbuf, int recvcount, 
		       const Datatype & recvtype, int root) const;
  
  virtual void Scatterv(const void *sendbuf, const int sendcounts[], 
			const int displs[], const Datatype & sendtype,
			void *recvbuf, int recvcount, 
			const Datatype & recvtype, int root) const;
  
  virtual void Allgather(const void *sendbuf, int sendcount, 
			 const Datatype & sendtype, void *recvbuf, 
			 int recvcount, const Datatype & recvtype) const;

  virtual void Allgatherv(const void *sendbuf, int sendcount, 
			  const Datatype & sendtype, void *recvbuf, 
			  const int recvcounts[], const int displs[],
			  const Datatype & recvtype) const;

  virtual void Alltoall(const void *sendbuf, int sendcount, 
			const Datatype & sendtype, void *recvbuf, 
			int recvcount, const Datatype & recvtype) const;

  virtual void Alltoallv(const void *sendbuf, const int sendcounts[], 
			 const int sdispls[], const Datatype & sendtype, 
			 void *recvbuf, const int recvcounts[], 
			 const int rdispls[], const Datatype & recvtype) const;

  virtual void Reduce(const void *sendbuf, void *recvbuf, int count, 
		      const Datatype & datatype, const Op & op, 
		      int root) const;

  virtual void Allreduce(const void *sendbuf, void *recvbuf, int count,
			 const Datatype & datatype, const Op & op) const;

  virtual void Reduce_scatter(const void *sendbuf, void *recvbuf, 
			      int recvcounts[], 
			      const Datatype & datatype, 
			      const Op & op) const;

  virtual void Scan(const void *sendbuf, void *recvbuf, int count, 
		    const Datatype & datatype, const Op & op) const;

  Intracomm Dup() const;

#if MPI2CPP_VIRTUAL_FUNC_RET
  Intracomm&
#else
  Comm&
#endif
  Clone() const;

  virtual Intracomm Create(const Group& group) const;
  
  virtual Intracomm Split(int color, int key) const;

  virtual Intercomm Create_intercomm(int local_leader, const Comm& peer_comm,
				     int remote_leader, int tag) const;
  
  virtual Cartcomm Create_cart(int ndims, const int dims[],
			       const MPI2CPP_BOOL_T periods[], 
			       MPI2CPP_BOOL_T reorder) const;
  
  virtual Graphcomm Create_graph(int nnodes, const int index[],
				 const int edges[], 
				 MPI2CPP_BOOL_T reorder) const;


protected:

public: // JGS, friends issue
  static Op* current_op;

};
