#!/usr/bin/env python

"""To use this setup script to install Pebrot:

        python pebrot.py install

"""
from distutils.core import setup

import sys
import os
import glob

from distutils.core import setup
from distutils.sysconfig import get_python_lib

mo_dirs = glob.glob(os.path.join("i18n", "*"))
excluded= ["pebrot.pot", "Makefile"]
translations = []
for mo in mo_dirs:
	p, lang = os.path.split(mo)
	if lang in excluded:
		continue
	translations.append((os.path.join("share", "locale", lang, "LC_MESSAGES"), [os.path.join(mo, "LC_MESSAGES", "pebrot.mo")]))


docs= [ ( 'share/doc/pebrot', ['README', 'pebrotrc', 'AUTHORS', 'ChangeLog', 'COPYING'] ) ]
utils= [ ( 'share/doc/pebrot/utils', glob.glob( 'utils/*py' ) ) ]
utils+= [ ( 'share/doc/pebrot/utils/transparent_bg', glob.glob( 'utils/transparent_bg/*' ) ) ]
logos= [ ( 'share/doc/pebrot/logos', glob.glob( 'logos/*' ) ) ]

data= translations + docs + utils + logos

if __name__ == '__main__' :
    
    from pypebrot.__init__ import VERSION

    setup( 
        name            = "pebrot",
        version         = VERSION,
        license         = "GPL",
        description     = "MSN messenger text mode client",
        author          = "Angel Luis Jimenez Martinez",
        author_email    = "inspector_chan@ono.com",
        url             = "http://pebrot.sourceforge.net",
        packages        = [ 'pypebrot' ],
        scripts         = [ 'pebrot' ],
        data_files		= data
      )
